#! /usr/local/bin/tclsap
##################################################################
#  Sap_System_Info.tcl
#
# This script executes the SAP ABAP RFC_SYSTEM_INFO
# This is intended as an example of teh use of tclsap
#
# No claims are made to the quality of the tcl/tk code.
# 
# Garth Kennedy    15 August 1995
#
#  Part of tclsap - version 0.2  released 14 December 1995
#
# AUTHOR:
#      Garth Kennedy (garth@comm.mot.com or garth@mcs.net)
#      Land Mobile Products  Motorola Inc. 
#      Schaumburg, Ill.
#
# COPYRIGHT NOTICE:
#      Copyright 1995   Motorola Inc.;
#      Permission to use, copy modify and distribute without charge
#      this software, documentation etc. is granted, provided that
#      this comment and the author's name is retained. Neither the
#      author or Motorola assume any responsibility for problems
#     resulting from the use of this software.
#
################################################################

if {$argc < 4} {
    error "Usage: sap_system_info.tcl <SID> <client> <user> <password>"
}

set sid [lindex $argv 0]
set client [lindex $argv 1]
set user [lindex $argv 2]
set pword [lindex $argv 3]
set trace "NO"


Sap_Open $sid $client $user $pword $trace
Sap_RfcPing
set infos [Sap_SysInfo]
Sap_Close

set sap_dest    [string range $infos  13  44]
set sap_host    [string range $infos  45  52]
set sap_system  [string range $infos  53  60]
set sap_dbhost  [string range $infos  69 100]
set sap_db      [string range $infos 101 110]
set sap_release [string range $infos 111 114]
set sap_os      [string range $infos 120 129]
set sap_tz      [string range $infos 130 135]
set sap_dstflag [string index $infos 136]


set sap_dest    [string trimright $sap_dest]
set sap_host    [string trimright $sap_host]
set sap_system  [string trimright $sap_system]
set sap_dbhost  [string trimright $sap_dbhost]
set sap_db      [string trimright $sap_db]
set sap_release [string trimright $sap_release]
set sap_os      [string trimright $sap_os]
set sap_tz      [string trimright $sap_tz]

puts " "
puts "SAP System Information"
puts " "
puts [format "  Logical Destination - %s" $sap_dest]
puts [format "  Contacted Host - %s" $sap_host]
puts [format "  SAP System ID - %s" $sap_system]
puts [format "  Database Host Name - %s" $sap_dbhost]
puts [format "  Database System Type - %s" $sap_db]
puts [format "  SAP Basis Release - %s" $sap_release]
puts [format "  Operating System - %s" $sap_os]
puts [format "  Time Zone Offset (sec) - %s" $sap_tz]
if {[string compare $sap_dstflag "X"] == 0 } {
    puts "  This system uses Daylight Savings Time" 
} else { puts "  This system does not use Daylight Savings Time"}
puts " "

exit
