/***********************************************************************
 * Sap_Sysinfo.c
 *
 * Part of tclsap - version 0.2  released 14 December 1995
 *
 * AUTHOR:
 *      Garth Kennedy (garth@comm.mot.com or garth@mcs.net)
 *      Land Mobile Products  Motorola Inc. 
 *      Schaumburg, Ill.

 * COPYRIGHT NOTICE:
 *      Copyright 1995   Motorola Inc.;
 *      Permission to use, copy modify and distribute without charge
 *      this software, documentation etc. is granted, provided that
 *      this comment and the author's name is retained. Neither the
 *      author or Motorola assume any responsibility for problems
 *     resulting from the use of this software.
 *
 ***********************************************************************/
#include "Sap_Header.h"

/*****************************************************************
 * sap_sysinfoCmd()
 *
 * Description:	get some info about the target system
 *              Return as a string - not a structure.
 *
 * Garth Kennedy    15 Aug 1995
 *****************************************************************/
sap_sysinfoCmd( ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
   RFC_PARAMETER      exporting[32];
   RFC_PARAMETER      importing[32];
   RFC_TABLE          tables[32];
   static RFC_RC      rfc_rc;
   char 	      *exception_ptr;
   char sysinfo[250];


   importing[0].name = "RFCSI_EXPORT";
   importing[0].nlen = 12;
   importing[0].addr = sysinfo;
   importing[0].leng = 200;
   importing[0].type = TYPC;

   importing[1].name = NULL;
   exporting[0].name = NULL;
   tables[0].name    = NULL;

   
            
    rfc_rc = RfcCallReceive( handle, "RFC_SYSTEM_INFO",
                                    exporting,
                                    importing,
                                    tables,
                                    &exception_ptr );
            
    if( rfc_rc != RFC_OK )
        return TCL_ERROR;
        
    sprintf(interp->result, "%s", sysinfo);
    
    return TCL_OK;
}  /* end sap_sysinfoCmd() */
   

