/* tclMain.c */
/***********************************************************************
 * tclMain.c
 *
 * Part of tclsap - version 0.2  released 14 December 1995
 *
 * AUTHOR:
 *      Garth Kennedy (garth@comm.mot.com or garth@mcs.net)
 *      Land Mobile Products  Motorola Inc. 
 *      Schaumburg, Ill.

 * COPYRIGHT NOTICE:
 *      Copyright 1995   Motorola Inc.;
 *      Permission to use, copy modify and distribute without charge
 *      this software, documentation etc. is granted, provided that
 *      this comment and the author's name is retained. Neither the
 *      author or Motorola assume any responsibility for problems
 *     resulting from the use of this software.
 *
 ***********************************************************************/
#define MAIN

#include "Sap_Header.h"

/*
 * Declarations for application-specific command procedures
 */
int sap_openCmd(ClientData clientData,
				Tcl_Interp *interp,
				int argc, char *argv[]);
int sap_closeCmd(ClientData clientData,
				Tcl_Interp *interp,
				int argc, char *argv[]);
int sap_callrxCmd1(ClientData clientData,
				Tcl_Interp *interp,
				int argc, char *argv[]);
int sap_callrxCmd2(ClientData clientData,
				Tcl_Interp *interp,
				int argc, char *argv[]);
int sap_RfcPingCmd(ClientData clientData,
				Tcl_Interp *interp,
				int argc, char *argv[]);
int sap_sysinfoCmd(ClientData clientData,
				Tcl_Interp *interp,
				int argc, char *argv[]);
int sap_helpCmd(ClientData clientData,
				Tcl_Interp *interp,
				int argc, char *argv[]);
int sap_versionCmd(ClientData clientData,
				Tcl_Interp *interp,
				int argc, char *argv[]);


main(int argc, char *argv[]) {
	Tcl_Main(argc, argv, Tcl_AppInit);
	exit(0);
}
/*
 * Tcl_AppInit is called from Tcl_Main
 * after the Tcl interpreter has been created,
 * and before the script file
 * or interactive command loop is entered.
 */
int
Tcl_AppInit(Tcl_Interp *interp) {
	/*
	 * Initialize packages
	 * Tcl_Init sets up the Tcl library facility.
	 */
	if (Tcl_Init(interp) == TCL_ERROR) {
		return TCL_ERROR;
	}
	/*
	 * Register application-specific commands.
	 */
	Tcl_CreateCommand(interp, "Sap_Open", sap_openCmd,
			(ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
			
        Tcl_CreateCommand(interp, "Sap_Close", sap_closeCmd,
			(ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
 			
        Tcl_CreateCommand(interp, "Sap_Callrx1", sap_callrxCmd1,
			(ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
  			
        Tcl_CreateCommand(interp, "Sap_Callrx2", sap_callrxCmd2,
			(ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
   			
        Tcl_CreateCommand(interp, "Sap_RfcPing", sap_RfcPingCmd,
			(ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
    			
        Tcl_CreateCommand(interp, "Sap_SysInfo", sap_sysinfoCmd,
			(ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
     			
        Tcl_CreateCommand(interp, "Sap_Help", sap_helpCmd,
			(ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
      			
        Tcl_CreateCommand(interp, "Sap_Version", sap_versionCmd,
			(ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
  
	/*
	 * Define startup filename. This file is read in
	 * case the program is run interactively.
	 */
	tcl_RcFileName = "~/.myapp.tcl";
	/*
	 * Test of Tcl_Invoke.
	 */
	Tcl_Invoke(interp, "set", "foo", "$xyz [foo] {", NULL);
	return TCL_OK;
}
