#!/usr/local/bin/tclsap
#############################################################
# Inv_Info_Www.tcl
#
# This script executes an ABAP that returns the Inventory for
# a passed Material (eg Item) Number. The inventory is returned 
# as a repeating series of <stock location> <inventory quantity> 
# record pairs in a single record.
#
# The returned record is of 250 character length, as currently
# implemented, the <stock location> <inventory quantity> pair
# is 22 characters long. This allows 11 inventory locations.
#
# The Inventory returned is the total of the following fields 
# from the MARD table:
#     LABST  -  Unrestricted stock
#     UMLME  -  Stock in transit
#     INSME  -  Stock in Inspection
#     KLABS  -  Unrestricted consignment stock
#     KINSM  -  Consignment Stock in inspection
#
# These are the fields that are used for our MRP, so those are
# the inventory fields used here.
#
#
# Garth Kennedy  14 September 1995
#
# Copyright Motorola Inc. 1995
#
#
#  Part of tclsap - version 0.2  released 14 December 1995
#
# AUTHOR:
#      Garth Kennedy (garth@comm.mot.com or garth@mcs.net)
#      Land Mobile Products  Motorola Inc. 
#      Schaumburg, Ill.
#
# COPYRIGHT NOTICE:
#      Copyright 1995   Motorola Inc.;
#      Permission to use, copy modify and distribute without charge
#      this software, documentation etc. is granted, provided that
#      this comment and the author's name is retained. Neither the
#      author or Motorola assume any responsibility for problems
#     resulting from the use of this software.
#
############################################################
#
set envvars {SERVER_SOFTWARE SERVER_NAME GATEWAY_INTERFACE SERVER_PROTOCOL SERVER_PORT REQUEST_METHOD PATH_INFO PATH_TRANSLATED SCRIPT_NAME QUERY_STRING REMOTE_HOST REMOTE_ADDR REMOTE_USER AUTH_TYPE CONTENT_TYPE CONTENT_LENGTH HTTP_ACCEPT HTTP_REFERER HTTP_USER_AGENT}

#
# UnCgi Translation hack, in Tcl, v1.4 5/1995 by dl@hplyot.obspm.fr
#
proc uncgi {buf} {
# looks like ncsa httpd transforms ' -> \'
regsub -all {\\'} $buf {'} buf ;
regsub -all {\\} $buf {\\\\} buf ;
regsub -all { }  $buf {\ } buf ;
regsub -all {\+} $buf {\ } buf ;
regsub -all {\$} $buf {\$} buf ;
regsub -all \n   $buf {\n} buf ;
regsub -all {;}  $buf {\;} buf ;
regsub -all {\[} $buf {\[} buf ;
regsub -all \" $buf \\\" buf ;
# the next one can probably be skipped as the first char is prolly not
# an \{, but, hey who knows... lets be safe...
regsub  ^\{ $buf \\\{ buf ;
# I think everything has been escaped, now the real work :
regsub -all -nocase {%([a-fA-F0-9][a-fA-F0-9])} $buf {[format %c 0x\1]} buf
# And now lets replace all those escaped back, along with excuting of
# the format :
eval return \"$buf\"
# now everything is in buf, but translated, nice trick no ?
}

# returns in the 'cgi' array all the parameters sent to the script
# through 'message' (each array cell is a list (ie if only one value
# is expected through 'test' variable, use [lindex $cgi(test) 0] to get it)).
proc parse_cgi_message {message} {
global cgi;
set cgi() "";
foreach pair [split $message &] {
  set plst [split $pair =];
  set name [uncgi [lindex $plst 0]];
  set val  [uncgi [lindex $plst 1]];
  lappend cgi($name) $val;
}
}


#################################################################
#
# get_sapinv

proc get_sapinv { sap_item } {

    global  xsap_login sap_inv_loc1 sap_inv_qty1 \
    sap_inv_loc2 sap_inv_qty2 sap_inv_loc3 sap_inv_qty3 sap_inv_loc4 sap_inv_qty4 \
    sap_inv_loc5 sap_inv_qty5 sap_inv_loc6 sap_inv_qty6 sap_inv_loc7 sap_inv_qty7 \
    sap_inv_loc8 sap_inv_qty8 sap_inv_loc9 sap_inv_qty9 \
    sap_inv_loc10 sap_inv_qty10 sap_inv_loc11 sap_inv_qty11 
   
    set sap_inv_tot 0
    
    set sap_item [string toupper $sap_item]
 
    set tmp [string toupper $xsap_login]
    puts "Inventory for Item Number  <B>$sap_item</B><P>"
#    puts "<PRE>"        
    puts "<TABLE BORDER>"
       # TT

    if { [string compare $tmp "YES"] == 0 } {
#        puts [format "%9s     %13s" "Stockroom" "Inventory Qty"]
#        puts "---------     -------------" 
        puts "<TR><TH>Stockroom</TH> <TH>Inventory Qty</TH></TR>";  # TT


        set inv_dat " "
        set sap_tem "xx$sap_item                    "   
                  # SAP puts blanks after the material number - 
                  # hence the requirement for the trailing blanks
        
        # NOTE: the inventory quantites have an additioal '000' trailing
        set inv_dat [Sap_Callrx1 Z_WWW_INV1 $sap_tem ]

            set sap_inv_loc1 [string range $inv_dat  0  3 ]
            set str_len [string length [string trim $sap_inv_loc1]]
            if {$str_len > 0} {
                set sap_inv_qty1 [join [ split [string range $inv_dat  5 16 ] ','] \x00]
                set sap_inv_qty1 [string trim $sap_inv_qty1]
                set sap_inv_tot [expr 0 + $sap_inv_qty1]
#                puts [format "%9s     %13s" $sap_inv_loc1 $sap_inv_qty1]
                puts [format "<tr><td>%9s</td> <TD ALIGN=right>%10s</td></tr>" $sap_inv_loc1 $sap_inv_qty1]; # TT
            } else {
                set sap_inv_qty1 " "
            }
            
            set sap_inv_loc2 [string range $inv_dat  22  25 ]
            set str_len [string length [string trim $sap_inv_loc2]]
            if {$str_len > 0} {
                set sap_inv_qty2 [join [ split [string range $inv_dat  27 38 ] ','] \x00]
                set sap_inv_qty2 [string trim $sap_inv_qty2]
                set sap_inv_tot [expr $sap_inv_tot + $sap_inv_qty2]
#                puts [format "%9s     %13s" $sap_inv_loc2 $sap_inv_qty2]
                puts [format "<TR><TD>%9s</td> <TD ALIGN=right>%10s</td></tr>" $sap_inv_loc2 $sap_inv_qty2]; # TT
            } else {
                set sap_inv_qty2 " "
            }
            
            set sap_inv_loc3 [string range $inv_dat  44  47 ]
            set str_len [string length [string trim $sap_inv_loc3]]
            if {$str_len > 0} {
                set sap_inv_qty3 [join [ split [string range $inv_dat  49 60 ] ','] \x00]
                set sap_inv_qty3 [string trim $sap_inv_qty3]
                set sap_inv_tot [expr $sap_inv_tot + $sap_inv_qty3]
#                puts [format "%9s     %13s" $sap_inv_loc3 $sap_inv_qty3]
                 puts [format "<TR><TD>%9s</td> <TD ALIGN=right>%10s</td></tr>" $sap_inv_loc3 $sap_inv_qty3];  # TT
           } else {
                set sap_inv_qty3 " "
            }

            set sap_inv_loc4 [string range $inv_dat  66  69 ]
            set str_len [string length [string trim $sap_inv_loc4]]
            if {$str_len > 0} {
                set sap_inv_qty4 [join [ split [string range $inv_dat  71 82 ] ','] \x00]
                set sap_inv_qty4 [string trim $sap_inv_qty4]
                set sap_inv_tot [expr $sap_inv_tot + $sap_inv_qty4]
#                puts [format "%9s     %13s" $sap_inv_loc4 $sap_inv_qty4]
                puts [format "<TR><TD>%9s</td> <TD ALIGN=right>%10s</td></tr>" $sap_inv_loc4 $sap_inv_qty4];  #TT
            } else {
                set sap_inv_qty4 " "
            }
            
            set sap_inv_loc5 [string range $inv_dat  88  91 ]
            set str_len [string length [string trim $sap_inv_loc5]]
            if {$str_len > 0} {
                set sap_inv_qty5 [join [ split [string range $inv_dat  93 104 ] ','] \x00]
                set sap_inv_qty5 [string trim $sap_inv_qty5]
                set sap_inv_tot [expr $sap_inv_tot + $sap_inv_qty5]
#                puts [format "%9s     %13s" $sap_inv_loc5 $sap_inv_qty5]
                puts [format "<TR><TD>%9s</td> <TD ALIGN=right>%10s</TD></TR>" $sap_inv_loc5 $sap_inv_qty5];  # TT
            } else {
                set sap_inv_qty5 " "
            }
 
            set sap_inv_loc6 [string range $inv_dat  110  113 ]
            set str_len [string length [string trim $sap_inv_loc6]]
            if {$str_len > 0} {
                set sap_inv_qty6 [join [ split [string range $inv_dat  115 126 ] ','] \x00]
                set sap_inv_qty6 [string trim $sap_inv_qty6]
                set sap_inv_tot [expr $sap_inv_tot + $sap_inv_qty6]
#                puts [format "%9s     %13s" $sap_inv_loc6 $sap_inv_qty6]
                puts [format "<TR><TD>%9s</td> <TD ALIGN=right>%10s</TD></TR>" $sap_inv_loc6 $sap_inv_qty6] ; # TT
            } else {
                set sap_inv_qty6 " "
            }
            
            set sap_inv_loc7 [string range $inv_dat  132  135 ]
            set str_len [string length [string trim $sap_inv_loc7]]
            if {$str_len > 0} {
                set sap_inv_qty7 [join [ split [string range $inv_dat  137 148 ] ','] \x00]
                set sap_inv_qty7 [string trim $sap_inv_qty7]
                set sap_inv_tot [expr $sap_inv_tot + $sap_inv_qty7]
#                puts [format "%9s     %13s" $sap_inv_loc7 $sap_inv_qty7]
                puts [format "<TR><TD>%9s</td> <TD ALIGN=right>%10s</td></tr>" $sap_inv_loc7 $sap_inv_qty7];
            } else {
                set sap_inv_qty7 " "
            }
            
            set sap_inv_loc8 [string range $inv_dat  154  157 ]
            set str_len [string length [string trim $sap_inv_loc8]]
            if {$str_len > 0} {
                set sap_inv_qty8 [join [ split [string range $inv_dat  159 170 ] ','] \x00]
                set sap_inv_qty8 [string trim $sap_inv_qty8]
                set sap_inv_tot [expr $sap_inv_tot + $sap_inv_qty8]
#                puts [format "%9s     %13s" $sap_inv_loc8 $sap_inv_qty8]
                 puts [format "<TR><TD>%9s</td> <TD ALIGN=right>%10s</TD></TR>" $sap_inv_loc8 $sap_inv_qty8];  # TT
           } else {
                set sap_inv_qty8 " "
            }
            
            set sap_inv_loc9 [string range $inv_dat  176  179 ]
            set str_len [string length [string trim $sap_inv_loc9]]
            if {$str_len > 0} {
                set sap_inv_qty9 [join [ split [string range $inv_dat  181 192 ] ','] \x00]
                set sap_inv_qty9 [string trim $sap_inv_qty9]
                set sap_inv_tot [expr $sap_inv_tot + $sap_inv_qty9]
#                puts [format "%9s     %13s" $sap_inv_loc9 $sap_inv_qty9]
                puts [format "<TR><TD>%9s</td> <TD ALIGN=right>%10s</TD><TR>" $sap_inv_loc9 $sap_inv_qty9] ;  # TT
            } else {
                set sap_inv_qty9 " "
            }
            
            set sap_inv_loc10 [string range $inv_dat  198  201 ]
            set str_len [string length [string trim $sap_inv_loc10]]
            if {$str_len > 0} {
                set sap_inv_qty10 [join [ split [string range $inv_dat  203 214 ] ','] \x00]
                set sap_inv_qty10 [string trim $sap_inv_qty10]
                set sap_inv_tot [expr $sap_inv_tot + $sap_inv_qty10]
#                puts [format "%9s     %13s" $sap_inv_loc10 $sap_inv_qty10]
                puts [format "<TR><TD>%9s</td> <TD ALIGN=right>%10s</TD></TR>" $sap_inv_loc10 $sap_inv_qty10]; # TT
            } else {
                set sap_inv_qty10 " "
            }
            
            set sap_inv_loc11 [string range $inv_dat  220  223 ]
            set str_len [string length [string trim $sap_inv_loc11]]
            if {$str_len > 0} {
                set sap_inv_qty11 [join [ split [string range $inv_dat  225 236 ] ','] \x00]
                set sap_inv_qty11 [string trim $sap_inv_qty11]
                set sap_inv_tot [expr $sap_inv_tot + $sap_inv_qty11]
#                puts [format "%9s     %13s" $sap_inv_loc11 $sap_inv_qty11]
                puts [format "<TR><TD>%9s</td> <TD ALIGN=right>%10s</TD></TR>" $sap_inv_loc11 $sap_inv_qty11];
            } else {
                set sap_inv_qty11 " "
            }
            
        puts "</table>"
        puts "<HR>"
        puts [format "<B>Total Inventory = %s</B>" $sap_inv_tot]

    } 
#    puts "</PRE>"

} 
# end of proc get_sapinv

############################################################
#
# clr_sapmatl

proc clr_sapmatl {  } {

    global .r  sap_dest sap_host sap_system \
    sap_dbhost sap_db sap_release sap_os sap_tz sap_dst \
    sap_inv_tot sap_inv_loc1 sap_inv_qty1 \
    sap_inv_loc2 sap_inv_qty2 sap_inv_loc3 sap_inv_qty3 sap_inv_loc4 sap_inv_qty4 \
    sap_inv_loc5 sap_inv_qty5 sap_inv_loc6 sap_inv_qty6 sap_inv_loc7 sap_inv_qty7 \
    sap_inv_loc8 sap_inv_qty8 sap_inv_loc9 sap_inv_qty9 \
    sap_inv_loc10 sap_inv_qty10 sap_inv_loc11 sap_inv_qty11 

    set sap_inv_tot 0
    
    set sap_inv_loc1 "  "
    set sap_inv_qty1 0
    set sap_inv_loc2 "  "
    set sap_inv_qty2 0
    set sap_inv_loc3 "  "
    set sap_inv_qty3 0
    set sap_inv_loc4 "  "
    set sap_inv_qty4 0
    set sap_inv_loc5 "  "
    set sap_inv_qty5 0
    set sap_inv_loc6 "  "
    set sap_inv_qty6 0
       
    set sap_inv_loc7 "  "
    set sap_inv_qty7 0
    set sap_inv_loc8 "  "
    set sap_inv_qty8 0
    set sap_inv_loc9 "  "
    set sap_inv_qty9 0
    set sap_inv_loc10 "  "
    set sap_inv_qty10 0
    set sap_inv_loc11 "  "
    set sap_inv_qty11 0
 } 
# end of proc clr_sapmatl



########################################################################
# Main Body

puts "Content-type: text/html\n"
puts "<HTML>"
puts "<HEAD>"
puts "<TITLE>Simple SAP Material Inventory Report</TITLE>"
puts "</HEAD>"


puts "<BODY>"
puts "<H1>Simple SAP Material Inventory Report</H1>"
puts "<P>"
puts "<HR>"


if {[string compare $env(REQUEST_METHOD) "POST"]==0} {
set message [read stdin $env(CONTENT_LENGTH)];
} else {
set message $env(QUERY_STRING)
}
parse_cgi_message $message;

##set sid [lindex $cgi(sid) 0]
set sid "APS"
##set client [lindex $cgi(client) 0]
set client "100"
##set user [lindex $cgi(user) 0]
set user "wwwrpt"
##set pword  [lindex $cgi(pword) 0]
set pword "report"
set trace "0"
set sap_item [lindex $cgi(sap_item) 0]

set sid  [string trimright $sid]
set client  [string trimright $client]
set user  [string trimright $user]
set pword [string trimright $pword]
set sap_item [string trimright $sap_item]

set sid [string toupper $sid]
set client [string toupper $client]
set user [string toupper $user]
set pword  [string toupper $pword]
set sap_item [string toupper $sap_item]

if [catch {Sap_Open $sid $client $user $pword $trace } result] { 
    set sap_conn "No" 
} else {  
    set sap_conn "Yes" 
} 
 
if [catch {Sap_RfcPing } result] { 
    set xsap_login "No" 
} else { 
    set xsap_login "Yes" 
} 


# Was the login Successful ?
if { [string compare $sap_conn "Yes"] == 0 } {
    if { [string compare $xsap_login "Yes"] == 0 } {
        
        get_sapinv  $sap_item
                
    }  else {       
        puts "<P>"
        puts "The connect to SAP was successful, but the login was not.<P>"
        puts "Did you use the right User ID, Password and Client ?"
    }
} else {
    puts "<P>"
    puts "The connect to SAP was NOT successful.<P>"
    puts "Did you use the right System ID ?"
    puts "<P>"
}
puts "<P>"
puts "<HR>"
puts "<P>"
puts "This report was brought you courtesy of tclsap"
puts "<HR>"
puts "</BODY>"
puts "</HTML>"

Sap_Close

exit


