/***********************************************************************
 * Sap_CallRX.c
 *
 * Part of tclsap - version 0.2  released 14 December 1995
 *
 * AUTHOR:
 *      Garth Kennedy (garth@comm.mot.com or garth@mcs.net)
 *      Land Mobile Products  Motorola Inc. 
 *      Schaumburg, Ill.

 * COPYRIGHT NOTICE:
 *      Copyright 1995   Motorola Inc.;
 *      Permission to use, copy modify and distribute without charge
 *      this software, documentation etc. is granted, provided that
 *      this comment and the author's name is retained. Neither the
 *      author or Motorola assume any responsibility for problems
 *     resulting from the use of this software.
 *
 ***********************************************************************/
#include "Sap_Header.h"

/******************************************************************************
 * sap_callrxCmd2()
 *
 * Description:	Call the SAP RFC and and pass a message
 *              Receives two (2) parameters from SAP. 
 *              Returns the first received parameter
 *
 * Garth Kennedy   15 Aug 1995
 ******************************************************************************/
sap_callrxCmd2( ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
   RFC_PARAMETER      exporting[32];
   RFC_PARAMETER      importing[32];
   RFC_TABLE          tables[32];
   static RFC_RC      rfc_rc;
   char 	      *exception_ptr;
   char rfc_cmd[50];
   char  rfc_mess[250];
   char               e_status[300];       /* error and status return */
   char               sjunk[300];          /* return of exported record */
   int                i;
   int error;
       

    /* did the right number of arguments come over ? */
    /* should be <command> rfc_abap message_string  */
    if (argc != 3)
    {
        interp->result = "Usage:Sap_Callrx2 rfc_abap message_string";
        return TCL_ERROR;
    }

/***************************************************   
    error = Tcl_GetInt(interp, argv[1], &rfc_cmd);
    if (error != TCL_OK)
        return error;
       
    error = Tcl_GetInt(interp, argv[2], &rfc_mess);
    if (error != TCL_OK)
        return error;
********************************************************/
    for (i = 0; i < 250; i++)
        rfc_mess[i] = ' ';

    strcpy(rfc_cmd, argv[1]);   /* copy the RFC name */
    strcpy(rfc_mess, argv[2]);  /* copy the message to pass */
         
     
    strncpy(rfc_cmd, argv[1],248);   /* copy the RFC name */
    strncpy(rfc_mess, argv[2], 248);  /* copy the message to pass */
         
     for (i = 0; i < 250; i++)
     {    /* make sure that the string is space filled */
         if (rfc_mess[i] < 0x20)
             rfc_mess[i] = 0x20;
         e_status[i] = 0x20;
     }
    

       /* argument passed to the remote R/3 ABAP function */
   exporting[0].name = "IMPORT_STRING";
   exporting[0].nlen = 13;
   exporting[0].addr = rfc_mess;
   exporting[0].leng = 250;
   exporting[0].type = TYPC;
   exporting[1].name = NULL;

       /* result that we expect from the remote R.3 ABAP function */
   importing[0].name = "EXPORT_STRING";
   importing[0].nlen = 13;
   importing[0].addr = e_status;
   importing[0].leng = 250;
   importing[0].type = TYPC;
   importing[1].name = "EXPORT_STRING2";
   importing[1].nlen = 14;
   importing[1].addr = sjunk;
   importing[1].leng = 250;
   importing[1].type = TYPC;
   importing[2].name = NULL;

       /* not used */
   tables[0].name    = NULL;

            
       /* do the call */
    rfc_rc = RfcCallReceive( handle, rfc_cmd, exporting,
                             importing, tables, &exception_ptr);
                             
    if (rfc_rc != RFC_OK)
        return TCL_ERROR;

    sprintf(interp->result, "%s", e_status);
    
    return TCL_OK;

}    /* end sap_callrxCmd2()   */



/******************************************************************************
 * sap_callrxCmd1()
 *
 * Description:	Call the SAP RFC and and pass a message
 *              Receives one (1) parameters from SAP. 
 *
 * Garth Kennedy   15 Aug 1995
 ******************************************************************************/
sap_callrxCmd1( ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
   RFC_PARAMETER      exporting[32];
   RFC_PARAMETER      importing[32];
   RFC_TABLE          tables[32];
   static RFC_RC      rfc_rc;
   char 	      *exception_ptr;
   char  rfc_cmd[50];
   char   rfc_mess[250];
   char               e_status[300];       /* error and status return */
   int                i;
   int   error;
       

    /* did the right number of arguments come over ? */
    /* should be <command> rfc_abap message_string  */
    if (argc != 3)
    {
        interp->result = "Usage:Sap_callrx1 rfc_abap message_string";
        return TCL_ERROR;
    }

/**********************************************************   
    error = Tcl_GetInt(interp, argv[1], &rfc_cmd);
    if (error != TCL_OK)
        return error;
       
    error = Tcl_GetInt(interp, argv[2], &rfc_mess);
    if (error != TCL_OK)
        return error;
********************************************************/
    for (i = 0; i < 250; i++)
        rfc_mess[i] = ' ';

    strcpy(rfc_cmd, argv[1]);   /* copy the RFC name */
    strcpy(rfc_mess, argv[2]);  /* copy the message to pass */
         
     
     for (i = 0; i < 250; i++)
     {    /* make sure that the string is space filled */
         if (rfc_mess[i] < 0x20)
             rfc_mess[i] = 0x20;
         e_status[i] = 0x20;
     }
    

       /* argument passed to the remote R/3 ABAP function */
   exporting[0].name = "IMPORT_STRING";
   exporting[0].nlen = 13;
   exporting[0].addr = rfc_mess;
   exporting[0].leng = 250;
   exporting[0].type = TYPC;
   exporting[1].name = NULL;

       /* result that we expect from the remote R.3 ABAP function */
   importing[0].name = "EXPORT_STRING";
   importing[0].nlen = 13;
   importing[0].addr = e_status;
   importing[0].leng = 250;
   importing[0].type = TYPC;
   importing[1].name = NULL;

       /* not used */
   tables[0].name    = NULL;

            
       /* do the call */
    rfc_rc = RfcCallReceive( handle, rfc_cmd, exporting,
                             importing, tables, &exception_ptr);
                             
    if (rfc_rc != RFC_OK)
        return TCL_ERROR;

    sprintf(interp->result, "%s", e_status);
    
    return TCL_OK;

}    /* end sap_callrxCmd1()   */


