/***********************************************************************
 * Sap_Ckerr.c
 *
 * Part of tclsap - version 0.2  released 14 December 1995
 *
 * AUTHOR:
 *      Garth Kennedy (garth@comm.mot.com or garth@mcs.net)
 *      Land Mobile Products  Motorola Inc. 
 *      Schaumburg, Ill.

 * COPYRIGHT NOTICE:
 *      Copyright 1995   Motorola Inc.;
 *      Permission to use, copy modify and distribute without charge
 *      this software, documentation etc. is granted, provided that
 *      this comment and the author's name is retained. Neither the
 *      author or Motorola assume any responsibility for problems
 *     resulting from the use of this software.
 *
 ***********************************************************************/
#include "Sap_Header.h"

/*********************************************************************
 * sap_check_error (execption_ptr, e_status, RFC)
 *
 * Check for errors from the RfcReceive or RfcCallReceive functions.
 * This is a dummy in case I ever figure out what to do in a general
 * sense.
 * 
 * Garth Kennedy     15 Aug 1995
 ********************************************************************/
 int sap_check_error(char **exception_ptr, char *e_status, RFC_RC rfc_rc)
 { 
     int i;
     RFC_ERROR_INFO error_info;
     char s[250];
     time_t  tt;
     struct tm  *ts;
    
    
     for (i = 0; i < 160; i++) s[i] = '\0';   /* to be safe */
     
    /* handle errors */
        /************************************************************
         *  possible responses are: RFC_OK, RFC_FAILURE, RFC_EXCEPTION, 
         *       RFC_SYS_EXCEPTION (SYSTEM_FAILURE, COMMUNICATIONS_FAILURE)
         *       RFC_CALL
         ***********************************************************/

    if ( rfc_rc != RFC_OK ) 
    {
        RfcLastError(&error_info);   
        
            
        if ( (rfc_rc == RFC_EXCEPTION ) || (rfc_rc == RFC_SYS_EXCEPTION))
            sap_rfc_error( *exception_ptr );
        else if (rfc_rc == RFC_CLOSED)
        {

        } 
        else
        {
            sap_rfc_error( "Error in RfcReceive/RfcCallReceive" );
        }
        
    }   /* end check for RFC errors */
      
    else  /* no RFC error was encountered */
    {     /* Check for application level errors */
         
        
    }  /* end - check for application errors */


    return(TCL_OK);
}     /* end of sap_check_error()  */


