/***********************************************************************
 * Sap_Help.c
 *
 * Part of tclsap - version 0.2  released 14 December 1995
 *
 * AUTHOR:
 *      Garth Kennedy (garth@comm.mot.com or garth@mcs.net)
 *      Land Mobile Products  Motorola Inc. 
 *      Schaumburg, Ill.

 * COPYRIGHT NOTICE:
 *      Copyright 1995   Motorola Inc.;
 *      Permission to use, copy modify and distribute without charge
 *      this software, documentation etc. is granted, provided that
 *      this comment and the author's name is retained. Neither the
 *      author or Motorola assume any responsibility for problems
 *     resulting from the use of this software.
 *
 ***********************************************************************/
#include "Sap_Header.h"

/******************************************************************
 *  Sap_helpCmd()
 *
 * Description: This returns "help" on the Sap_ family of
 *              Commands aded to TCL in tclsap.
 *
 * Garth Kennedy     15 Aug 1995
 *****************************************************************/
sap_helpCmd( ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
    int i;
    char t[1200], s[100];
 
        /* how many arguments came over ? */
        /* if there was one then give a general response */
        /* if two, then try to give a response based on the */
        /*     parameter */
        /* if more than 2 - error */
        
    if (argc == 1)   /* only the command was passed */
    {   
        sprintf(t, "tclsap related commands: \n");
        strcat(t, "    Sap_Open - Open a session with SAP\n");
        strcat(t, "           Sap_Open System Client User Password Trace \n");
        strcat(t, "           Returns RFC Handle \n");
        strcat(t, "    Sap_Close - Close an SAP session \n");
        strcat(t, "    Sap_Callrx1 - Send and receive a string to/from SAP \n");
        strcat(t, "           Sap_Callrx1 rfc_abap message_string_to_send\n");
        strcat(t, "           Returns first return string\n");
        strcat(t, "    Sap_Callrx2 - Send one and receive 2 strings from SAP \n");
        strcat(t, "           Sap_Callrx1 rfc_abap message_string_to_send\n");
        strcat(t, "           Returns first return string\n");
        strcat(t, "    Sap_Help - Brief message describing the tclsap \n");
        strcat(t, "           commands - this screen\n");
        strcat(t, "    Sap_Help <tclsap command> - More detailed info about a \n");
        strcat(t, "           a specific tclsap command. \n");
        strcat(t, "    Sap_RfcPing - Send a ping to SAP \n");
        strcat(t, "    Sap_SysInfo - Return a string of system info from SAP\n");
        strcat(t, "           Returns info structure in a string\n");
        strcat(t, "    Sap_Version - Return version, contact and \n");
        strcat(t, "           copyright information \n");

        sprintf(interp->result, "%s", t);
        return TCL_OK;
    }
    
    else if  (argc == 2)
    {
        strcpy(s, argv[1]);
        for (i = 0; i < 20; i++)
            s[i] = toupper(s[i]);
            
        if (strcmp(s, "Sap_Open") == 0)
        {
            sprintf(t, "Sap_Open - Open a connection to an SAP Instance\n");
            strcat(t, "    Format: Sap_Open System Client User Password Trace \n");
            strcat(t, "            Returns RFC Handle \n");
            strcat(t, "    The Sap_Open function tries to make a connection and then \n");
            strcat(t, "    login into a SAP System. This requires that a SAP \n");
            strcat(t, "    sideinfo file be present (in the local directory or in \n");
            strcat(t, "    other normal places). \n\n");
            
            strcat(t, "    Please note that ALL SAP userids and password MUST \n");
            strcat(t, "    be in upper case.\n\n");
            
            strcat(t, "    Sap_Open returns TCL_OK if a successful connection was made.\n"); 
            strcat(t, "    There is no guarantee that the login was also successful.\n");
            strcat(t, "    To verify login, it is recommended that an Sap_RFCPing command\n");
            strcat(t, "    be attempted. \n\n");
            
            strcat(t, "    The RFC Handle is returned only so that some value is returned.\n");
            strcat(t, "    Use of this handle is strongly not recommended, because it is a\n");
            strcat(t, "    global variable within the tclsap library. Besides, there is no\n");
            strcat(t, "    way provided to change that handle :-)  \n\n");

            sprintf(interp->result, "%s", t);
            return TCL_OK;
            
        }
        else if (strcmp(s, "Sap_Close") == 0)
        {
            sprintf(t, "Sap_Close - Close the connection to an SAP Instance \n");
            strcat(t, "    This closes the single open connection ftom tclsap to an\n");
            strcat(t, "    SAP instance./n/n");
            strcat(t, "    This function result is always the string OK and the\n");
            strcat(t, "    function always returns TCL_OK\n");
            
            sprintf(interp->result, "%s", t);
            return TCL_OK;
        }
         else if (strcmp(s, "Sap_Callrx1") == 0)
        {
            sprintf(t, "Sap_Callrx1 - Send and receive message to RFC\n\n");
            strcat(t, "   Sap_Callrx1 executes a SAP RFC RfcCallReceive() command with the\n");
            strcat(t, "   ABAP passed as the target program and the message_string as the\n");
            strcat(t, "   contents to be passed. The message_string MUST be less than 248\n"); 
            strcat(t, "   characters in length. \n\n");
            
            strcat(t, "   The 248 character limit is due to a 249 character limit \n");
            strcat(t, "   within the ABAP development environment when the debugger is\n");
            strcat(t, "   in use.\n\n");
        
            strcat(t, "   The RfcCallReceive() function sends a Call to the SAP system and\n");
            strcat(t, "   waits to Receive transaction results from the SAP system. Only the\n");
            strcat(t, "   single result can be returned from a transaction.\n\n");
        
            strcat(t, "   The tables functionality of the SAP library is not implemented.\n\n"); 
        
            strcat(t, "   Sap_Callrx1 expects the return of one string from the SAP system\n");
            
            strcat(t, "   If the RfcCallReceive completed successfully, that is is the return \n");
            strcat(t, "   was RFC_OK, then Sap_Callrx1 returns TCL_OK. \n");
            
            sprintf(interp->result, "%s", t);
            return TCL_OK;
        }
         else if (strcmp(s, "Sap_Callrx2") == 0)
        {
            sprintf(t, "Sap_Callrx2 - Send and receive message to RFC\n\n");
            strcat(t, "   Sap_Callrx2 is the same as ASP_Callrx1 EXCEPT that\n");            
            strcat(t, "   Sap_Callrx2 expects the return of two (2) strings from the SAP system\n");
            strcat(t, "   The first of the two strings is returned to the calling function \n");
            strcat(t, "   in the result structure. This characteristic is included because \n");
            strcat(t, "   it is a local <feature> at the author's site.\n");
           
            strcat(t, "   If the RfcCallReceive completed successfully, that is is the return \n");
            strcat(t, "   was RFC_OK, then Sap_Callrx2 returns TCL_OK. \n");

            sprintf(interp->result, "%s", t);
            return TCL_OK;
        
        }
         else if (strcmp(s, "Sap_Help") == 0)
        {
            sprintf(t, "Sap_Help \n");
            strcat(t, "    This command provides brief, hopefully helpful descriptions \n");
            strcat(t, "    of the functions added to tcl/tk by tclsap. \n\n");
            
            strcat(t, "    Sap_Help will optionally accept a single option of a tclsap\n");
            strcat(t, "    command name. The response will be of a somewhat more detailed \n");
            strcat(t, "    description of the tclsap command.\n");
            
            sprintf(interp->result, "%s", t);
            return TCL_OK;
        }
         else if (strcmp(s, "Sap_RfcPing") == 0)
        {
            sprintf(t, "Sap_RfcPing - send a Ping to an SAP System\n");
            strcat(t, "    This command attempts to execute the RFCPING RFC on \n");
            strcat(t, "    the SAP system to which we are supposedly connected.\n");
            strcat(t, "    If the Ping is successful, Sap_RfcPing returns TCL_OK \n");
            strcat(t, "    otherwise the return is TCL_ERROR.\n\n");
            
            strcat(t, "    The primary reason for the inclusion of this command is\n");
            strcat(t, "    to provide a relatively easy way to verify that an attempted\n");
            strcat(t, "    was successful. A positive return from Sap_Open does not \n");
            strcat(t, "    make any promises about successful logins. \n");
            
            sprintf(interp->result, "%s", t);
            return TCL_OK;
        }
         else if (strcmp(s, "Sap_SysInfo") == 0)
        {
            sprintf(t, "Sap_SysInfo - Return information about the connected SAP system\n");
            strcat(t, "    This command executes the RFC_SYSTEM_INFO RFC on the SAP system.\n");
            strcat(t, "    It returns the data in a string.\n\n");
            strcat(t, "Data Description        Length  Position \n\n");
            strcat(t, "RFC Log Version          3        0 -   2\n");
            strcat(t, "Character Set (SAP)      4        3 -   6\n");
            strcat(t, "Integer Format           3        7 -   9\n");
            strcat(t, "Floating Point Format    3       10 -  12\n");
            strcat(t, "Logical SAP Destination 32       13 -  44\n");
            strcat(t, "Contacted Host           8       45 -  52\n");
            strcat(t, "SAP System ID (RFC)      8       53 -  60\n");
            strcat(t, "SAP System ID (DB)       8       61 -  68\n");
            strcat(t, "Database Host Name      32       69 - 100\n");
            strcat(t, "Database System Type    10      101 - 110\n");
            strcat(t, "SAP Basis Release        4      111 - 114\n");
            strcat(t, "SAP Machine ID           5      115 - 119\n");
            strcat(t, "Operating System        10      120 - 129\n");
            strcat(t, "Time Zone Offset (secs)  6      130 - 135\n");
            strcat(t, "Day Light Savings Flag   1      136 - 136\n");

            sprintf(interp->result, "%s", t);
            return TCL_OK;
        }
        else if (strcmp(s, "Sap_Version") == 0)
        {
            sprintf(t, "Sap_Version\n");
            strcat(t, "    Returns the version and copyright information\n");
            
            sprintf(interp->result, "%s", t);
            return TCL_OK;
        
        }
        else   /* did not match anything */
        {   
            sprintf(t, "tclsap related commands: \n");
            strcat(t, "    Sap_Open - Open a session with SAP\n");
            strcat(t, "           Sap_Open System Client User Password Trace \n");
            strcat(t, "           Returns RFC Handle \n");
            strcat(t, "    Sap_Close - Close an SAP session \n");
            strcat(t, "    Sap_Callrx1 - Send and receive a string to/from SAP \n");
            strcat(t, "           Sap_Callrx1 rfc_abap message_string_to_send\n");
            strcat(t, "           Returns first return string\n");
            strcat(t, "    Sap_Callrx2 - Send one and receive 2 strings from SAP \n");
            strcat(t, "           Sap_Callrx1 rfc_abap message_string_to_send\n");
            strcat(t, "           Returns first return string\n");
            strcat(t, "    Sap_Help - Brief message describing the tclsap \n");
            strcat(t, "           commands - this screen\n");
            strcat(t, "    Sap_Help <tclsap command> - More detailed info about a \n");
            strcat(t, "           a specific tclsap command. \n");
            strcat(t, "    Sap_RfcPing - Send a ping to SAP \n");
            strcat(t, "    Sap_SysInfo - Return a string of system info from SAP\n");
            strcat(t, "           Returns info structure in a string\n");
            strcat(t, "    Sap_Version - Return version and contact information \n");

            sprintf(interp->result, "%s", t);

            return TCL_OK;
        }
    }    /* end else if argc == 2 */
    else
    {
        interp->result = "Usage:Sap_Help <tclsap command>";

        return TCL_ERROR;
    }
    
    return TCL_OK;
}    /* end of Sap_helpCmd() */
