/***********************************************************************
 * Sap_Open.c
 *
 * Part of tclsap - version 0.2  released 14 December 1995
 *
 * AUTHOR:
 *      Garth Kennedy (garth@comm.mot.com or garth@mcs.net)
 *      Land Mobile Products  Motorola Inc. 
 *      Schaumburg, Ill.

 * COPYRIGHT NOTICE:
 *      Copyright 1995   Motorola Inc.;
 *      Permission to use, copy modify and distribute without charge
 *      this software, documentation etc. is granted, provided that
 *      this comment and the author's name is retained. Neither the
 *      author or Motorola assume any responsibility for problems
 *     resulting from the use of this software.
 *
 ***********************************************************************/
#include "Sap_Header.h"

/********************************************************************
 * sap_openCmd()
 *
 * Description:	Open/close the connection to the R/3 system 
 *
 * Garth Kennedy  15 Aug 1995
 ********************************************************************/
sap_openCmd( ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
   int ret_val;
   int error;
   RFC_OPTIONS        rfc_opt;
   RFC_ENV            new_env;
   char  sys[10];
   char  client[10];
   char  user[50];
   char  passwd[50];
   char  trace_in[10];


    sap_trace = 0;
    /* did the right number of arguments come over ? */
    /* should be <command> system client user password */
    if (argc != 6)
    {
        interp->result = "Usage: Sap_Open system client user password trace";
        return TCL_ERROR;
    }

    strcpy(sys, argv[1]);   /* copy the System name */
    strcpy(client, argv[2]);  /* copy the client name */
    strcpy(user, argv[3]);   /* copy the user login name */
    strcpy(passwd, argv[4]);  /* copy the user password */
    strcpy(trace_in,  argv[5]);   /* copy the trace parameter */
      
    if ((trace_in[0] == 'Y') || (trace_in[0] == 'y') || (trace_in[0] == 'T') || (trace_in[0] == 't'))
        sap_trace = 1;
    else
        sap_trace = 0;

       /* -----------------------------------------------
        * Install error handler
        * ---------------------------------------------*/
      
  
    new_env.allocate = NULL;
    new_env.errorhandler = sap_rfc_error;
    RfcEnvironment( &new_env );

       /* info necessary for the open, additional info must be supplied
        * in the sideinfo table
        */
    rfc_opt.client   = client;
    rfc_opt.user     = user;
    rfc_opt.language = "E";
    rfc_opt.password = passwd;
    rfc_opt.trace    = sap_trace;
    rfc_opt.mode     = RFC_MODE_R3ONLY;
    rfc_opt.destination = sys;
    rfc_opt.connopt  = 0; /* use the SIDEINFO table  */


    
       /* ------------------------------------------ *
        * open connection                            *
        * ------------------------------------------ */

    handle = RfcOpen( &rfc_opt );

    if ( handle == RFC_HANDLE_NULL )
    {
        sprintf(interp->result, "%s", "RFC Open Error");
        return TCL_ERROR;
    } 
    else
    {
        sprintf(interp->result, "%s", "Open OK" );
        return TCL_OK;
    }
        
}   /* end sap_openCmd()  */


 
/************************************************************
 * sap_closeCmd()
 *
 * Close the connection to SAP
 *
 * Garth Kennedy  15 Aug 1995
 ***********************************************************/
int sap_closeCmd( ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
       
    RfcClose( handle );
    
    sprintf(interp->result, "%s", "OK");
    
    return TCL_OK;
            
}     /* end fiamr3_close()  */


 
/************************************************************
 * sap_versionCmd()
 *
 * Return version info about tclsap
 *
 * Garth Kennedy  15 Aug 1995
 ***********************************************************/
int sap_versionCmd( ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
    char t[1000];
    
    sprintf(t, "tclsap - version 0.1  released 14 August 1995\n\n");
    strcat(t, "AUTHOR:\n");
    strcat(t, "     Garth Kennedy (garth@comm.mot.com or garth@mcs.net)\n");
    strcat(t, "     Land Mobile Products  Motorola Inc.\n");  
    strcat(t, "     Schaumburg, Ill.\n");

    strcat(t, "COPYRIGHT NOTICE:\n");
    strcat(t, "     Copyright 1995   Motorola Inc.\n");
    strcat(t, "     Permission to use, copy modify and distribute without charge\n");
    strcat(t, "     this software, documentation etc. is granted, provided that\n");
    strcat(t, "     this comment and the author's name is retained. Neither the\n");
    strcat(t, "     author or Motorola assume any responsibility for problems\n");
    strcat(t, "     resulting from the use of this software.\n");

    sprintf(interp->result, "%s", t);
    
    return TCL_OK;
            
}     /* end fiamr3_close()  */

