#!/usr/local/bin/tclsap
##################################################################
#  Sap_System_Info_Www.tcl
#
# This script executes the SAP ABAP RFC_SYSTEM_INFO
# This is intended as an example of teh use of tclsap
#
# No claims are made to the quality of the tcl/tk code.
# 
# Garth Kennedy    15 August 1995
#
#  Part of tclsap - version 0.2  released 14 December 1995
#
# AUTHOR:
#      Garth Kennedy (garth@comm.mot.com or garth@mcs.net)
#      Land Mobile Products  Motorola Inc. 
#      Schaumburg, Ill.
#
# COPYRIGHT NOTICE:
#      Copyright 1995   Motorola Inc.;
#      Permission to use, copy modify and distribute without charge
#      this software, documentation etc. is granted, provided that
#      this comment and the author's name is retained. Neither the
#      author or Motorola assume any responsibility for problems
#     resulting from the use of this software.
#
################################################################
#
set envvars {SERVER_SOFTWARE SERVER_NAME GATEWAY_INTERFACE SERVER_PROTOCOL SERVER_PORT REQUEST_METHOD PATH_INFO PATH_TRANSLATED SCRIPT_NAME QUERY_STRING REMOTE_HOST REMOTE_ADDR REMOTE_USER AUTH_TYPE CONTENT_TYPE CONTENT_LENGTH HTTP_ACCEPT HTTP_REFERER HTTP_USER_AGENT}

#
# UnCgi Translation hack, in Tcl, v1.4 5/1995 by dl@hplyot.obspm.fr
#
proc uncgi {buf} {
# looks like ncsa httpd transforms ' -> \'
regsub -all {\\'} $buf {'} buf ;
regsub -all {\\} $buf {\\\\} buf ;
regsub -all { }  $buf {\ } buf ;
regsub -all {\+} $buf {\ } buf ;
regsub -all {\$} $buf {\$} buf ;
regsub -all \n   $buf {\n} buf ;
regsub -all {;}  $buf {\;} buf ;
regsub -all {\[} $buf {\[} buf ;
regsub -all \" $buf \\\" buf ;
# the next one can probably be skipped as the first char is prolly not
# an \{, but, hey who knows... lets be safe...
regsub  ^\{ $buf \\\{ buf ;
# I think everything has been escaped, now the real work :
regsub -all -nocase {%([a-fA-F0-9][a-fA-F0-9])} $buf {[format %c 0x\1]} buf
# And now lets replace all those escaped back, along with excuting of
# the format :
eval return \"$buf\"
# now everything is in buf, but translated, nice trick no ?
}

# returns in the 'cgi' array all the parameters sent to the script
# through 'message' (each array cell is a list (ie if only one value
# is expected through 'test' variable, use [lindex $cgi(test) 0] to get it)).
proc parse_cgi_message {message} {
global cgi;
set cgi() "";
foreach pair [split $message &] {
  set plst [split $pair =];
  set name [uncgi [lindex $plst 0]];
  set val  [uncgi [lindex $plst 1]];
  lappend cgi($name) $val;
}
}


puts "Content-type: text/html\n"
puts "<HTML>"
puts "<HEAD>"
puts "<TITLE>SAP System Information</TITLE>"
puts "</HEAD>"

puts "<BODY>"
puts "<H1>SAP System Information</H1>"
puts "<P>"
puts "<HR>"


if {[string compare $env(REQUEST_METHOD) "POST"]==0} {
set message [read stdin $env(CONTENT_LENGTH)];
} else {
set message $env(QUERY_STRING)
}
parse_cgi_message $message;


set sid [lindex $cgi(sid) 0]
set client [lindex $cgi(client) 0]
set user [lindex $cgi(user) 0]
set pword  [lindex $cgi(pword) 0]
set trace "0"
set sid  [string trimright $sid]
set client  [string trimright $client]
set user  [string trimright $user]
set pword [string trimright $pword]
set sid [string toupper $sid]
set client [string toupper $client]
set user [string toupper $user]
set pword  [string toupper $pword]

 
if [catch {Sap_Open $sid $client $user $pword $trace } result] { 
    set sap_conn "No" 
} else {  
    set sap_conn "Yes" 
} 
 
if [catch {Sap_RfcPing } result] { 
    set xsap_login "No" 
} else { 
    set xsap_login "Yes" 
} 

# Was the login Successful ?
if { [string compare $sap_conn "Yes"] == 0 } {
    if { [string compare $xsap_login "Yes"] == 0 } {
        set infos [Sap_SysInfo]
        Sap_Close

        set sap_dest    [string range $infos  13  44]
        set sap_host    [string range $infos  45  52]
        set sap_system  [string range $infos  53  60]
        set sap_dbhost  [string range $infos  69 100]
        set sap_db      [string range $infos 101 110]
        set sap_release [string range $infos 111 114]
        set sap_os      [string range $infos 120 129]
        set sap_tz      [string range $infos 130 135]
        set sap_dstflag [string index $infos 136]


        set sap_dest    [string trimright $sap_dest]
        set sap_host    [string trimright $sap_host]
        set sap_system  [string trimright $sap_system]
        set sap_dbhost  [string trimright $sap_dbhost]
        set sap_db      [string trimright $sap_db]
        set sap_release [string trimright $sap_release]
        set sap_os      [string trimright $sap_os]
        set sap_tz      [string trimright $sap_tz]

        puts "<UL>"
        puts [format "<LI><B>Logical Destination</B> %s" $sap_dest]
        puts [format "<LI><B>Contacted Host</B>  %s" $sap_host]
        puts [format "<LI><B>SAP System ID</B>  %s" $sap_system]
        puts [format "<LI><B>Database Host Name</B>  %s" $sap_dbhost]
        puts [format "<LI><B>Database System Type</B>  %s" $sap_db]
        puts [format "<LI><B>SAP Basis Release</B>  %s" $sap_release]
        puts [format "<LI><B>Operating System</B>  %s" $sap_os]
        puts [format "<LI><B>Time Zone Offset</B> (sec)  %s" $sap_tz]
        if {[string compare $sap_dstflag "X"] == 0 } {
            puts "<LI><B>This system uses Daylight Savings Time</B>" 
        } else { 
            puts "<LI><B>This system does NOT use Daylight Savings Time</B>"
        }
        
    } else {      ;# connect successful but login not
        puts "<UL>"
        puts "<P>"
        puts "The connect to SAP was successful, but the login was not.<P>"
        puts "Did you use the right User ID, Password and Client ?"
        puts "<P>"
    }
} else {
    puts "<UL>"
    puts "<P>"
    puts "The connect to SAP was NOT successful.<P>"
    puts "Did you use the right System ID ?"
    puts "<P>"
}
puts "</UL>"
puts "<HR>"
puts "<P>"
puts "This report was brought you courtesy of tclsap"
puts "<HR>"
puts "</BODY>"
puts "</HTML>"

Sap_Close

exit
