/* tkCustomMain.c */
/***********************************************************************
 * tkCustomMain.c
 *
 * Part of tclsap - version 0.2  released 14 December 1995
 *
 * AUTHOR:
 *      Garth Kennedy (garth@comm.mot.com or garth@mcs.net)
 *      Land Mobile Products  Motorola Inc. 
 *      Schaumburg, Ill.

 * COPYRIGHT NOTICE:
 *      Copyright 1995   Motorola Inc.;
 *      Permission to use, copy modify and distribute without charge
 *      this software, documentation etc. is granted, provided that
 *      this comment and the author's name is retained. Neither the
 *      author or Motorola assume any responsibility for problems
 *     resulting from the use of this software.
 *
 ***********************************************************************/
#define MAIN

#include "Sap_Header.h"
#include <tk.h>

/*
 * Declarations for application-specific command procedures
 */
int sap_openCmd(ClientData clientData,
				Tcl_Interp *interp,
				int argc, char *argv[]);
int sap_closeCmd(ClientData clientData,
				Tcl_Interp *interp,
				int argc, char *argv[]);
int sap_callrxCmd1(ClientData clientData,
				Tcl_Interp *interp,
				int argc, char *argv[]);
int sap_callrxCmd2(ClientData clientData,
				Tcl_Interp *interp,
				int argc, char *argv[]);
int sap_RfcPingCmd(ClientData clientData,
				Tcl_Interp *interp,
				int argc, char *argv[]);
int sap_sysinfoCmd(ClientData clientData,
				Tcl_Interp *interp,
				int argc, char *argv[]);
int sap_helpCmd(ClientData clientData,
				Tcl_Interp *interp,
				int argc, char *argv[]);
int sap_versionCmd(ClientData clientData,
				Tcl_Interp *interp,
				int argc, char *argv[]);

/*
 * XErrorProc --
 *		Toe-hold for debugging X Protocol botches.
 */
static int
XErrorProc(data, errEventPtr)
	ClientData data;
	XErrorEvent *errEventPtr;
{
	Tk_Window w = (Tk_Window)data;
	fprintf(stderr, "X protocol error: ");
	fprintf(stderr, "error=%d request=%d minor=%d\n",
		errEventPtr->error_code, errEventPtr->request_code,
		errEventPtr->minor_code);
	/*
	 * Claim to have handled the error.
	 */
	return 0;
}

Tk_Window mainWindow;

/*
 * A table for command line arguments.
 */
static char *display = NULL;
static int debug = 0;
static char *geometry = NULL;

Tk_ArgvInfo argTable[] = {
	{"-display", TK_ARGV_STRING, (char *) NULL,
	(char *) &display, "Display to use"},
	{"-debug", TK_ARGV_CONSTANT, (char *) 1, (char *) &debug,
		"Set things up for gdb-type debugging"},
	{"", TK_ARGV_END, },
};
/*
 * This program takes one argument, which is the
 * name of a script to interpret.
 */
main(int argc, char *argv[])
{
	Tcl_Interp *interp;
	int error; char *trace;

	interp = Tcl_CreateInterp();
	if (Tk_ParseArgv(interp, (Tk_Window) NULL, &argc, argv,
		argTable, 0) != TCL_OK) {
		fprintf(stderr, "%s\n", interp->result);
		exit(1);
	}
	if (argc < 2) {
		fprintf(stderr, "Usage: %s filename\n", argv[0]);
		exit(1);
	}

	/*
	 * Create the main window. The name of the application
	 * for use with the send command is "wishsap". The
	 * class of the application for X resources is "WishSap".
	 */
	mainWindow = Tk_CreateMainWindow(interp, display,
		"wishsap", "WishSap");
	if (mainWindow == NULL) {
		fprintf(stderr, "%s\n", interp->result);
		exit(1);
	}
	/*
	 * Register the X protocol error handler, and ask for
	 * a synchronous protocol to help debugging.
	 */
	Tk_CreateErrorHandler(Tk_Display(mainWindow), -1, -1, -1,
		XErrorProc, (ClientData)mainWindow);
	if (debug) {
		XSynchronize(Tk_Display(mainWindow), True);
	}
	/*
	 * Grab an initial size and background.
	 */
	Tk_GeometryRequest(mainWindow, 200, 200);
	Tk_SetWindowBackground(mainWindow,
		WhitePixelOfScreen(Tk_Screen(mainWindow)));

	/*
	 * This is where Tcl_AppInit would be called.
	 * In this case, we do the work right here.
	 */
	if (Tcl_Init(interp) != TCL_OK) {
		fprintf(stderr, "Tcl_Init failed: %s\n",
			 interp->result);
	}
	if (Tk_Init(interp) != TCL_OK) {
		fprintf(stderr, "Tk_Init failed: %s\n",
			 interp->result);
	}
	
	/*
	 * Register application-specific commands.
	 */
	Tcl_CreateCommand(interp, "Sap_Open", sap_openCmd,
			(ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
			
        Tcl_CreateCommand(interp, "Sap_Close", sap_closeCmd,
			(ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
 			
        Tcl_CreateCommand(interp, "Sap_Callrx1", sap_callrxCmd1,
			(ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
  			
        Tcl_CreateCommand(interp, "Sap_Callrx2", sap_callrxCmd2,
			(ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
   			
        Tcl_CreateCommand(interp, "Sap_RfcPing", sap_RfcPingCmd,
			(ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
    			
        Tcl_CreateCommand(interp, "Sap_SysInfo", sap_sysinfoCmd,
			(ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
     			
        Tcl_CreateCommand(interp, "Sap_Help", sap_helpCmd,
			(ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
      			
        Tcl_CreateCommand(interp, "Sap_Version", sap_versionCmd,
			(ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
   
        
	
	error = Tcl_EvalFile(interp, argv[1]);
	if (error != TCL_OK) {
		fprintf(stderr, "%s: %s\n", argv[1],
				interp->result);
		trace = Tcl_GetVar(interp, "errorInfo",
			 	TCL_GLOBAL_ONLY);
		if (trace != NULL) {
			fprintf(stderr, "*** TCL TRACE ***\n");
			fprintf(stderr, "%s\n", trace);
		}
	}
	/*
	 * Enter the custom event loop.
	 */
	while (WishSapExists()) {
		Tk_DoOneEvent(TK_ALL_EVENTS);
		WishSapStuff();
	}
	/*
	 * Call the Tcl exit to ensure that everything is
	 * cleaned up properly.
	 */
	Tcl_Eval(interp, "exit");
	return 0;
}

int
WishSapExists()
{
	return 1;
}
int
WishSapStuff()
{
	return 0;
}
