#!/usr/local/bin/wish -f
#
# This macro checks the "send" command and executes xauth
#
global env

wm withdraw .

proc ClearXhost { } {
   set s ""
   catch {set s [exec xhost 2>/dev/null]}
   set s [lrange [split $s "\n"] 1 end]
   if {$s == ""} {return 1}
   set erg [tk_dialog .err "update message:" \
"NOTE: the following hosts are included\n \
in your xhosts:\n \
$s \n \
should they be removed now ?" \
      warning -1 NO YES]
   if {$erg} {
      foreach i $s {
         catch {eval exec xhost -$i}
      }
   }
   set erg [tk_dialog .err "update message:" \
"Now enabling access control ?" \
      warning -1 NO YES]
   if {$erg} {
      catch {eval "exec xhost -"}
   }
   Add_Xauthority_to_X
   return 0
}

proc Add_Xauthority_to_X { } {
   if {[exec whoami] != "root"} {return}
   if {[exec uname] != "Linux"} {return}
   if {[file exists "/usr/X11/bin/startx"]} {
      set erg [tk_dialog .err "update message:" \
"adding -auth \$HOME/.Xauthority" \
      warning -1 NO YES]
      if {$erg} {
         set cwd [pwd]
         cd "/usr/X11/bin"
         set flg 0
         set fi [open "startx" r]
         set fo [open "startx.new" w]
         while {![eof $fi]} {
            set x [gets $fi]
            puts $fo $x
            if {(!$flg) && ([string first "serverargs=" $x] != -1)} {
               set flg 1
               puts $fo "# code added by tkedit"
               puts $fo "if \[ -f \$HOME/.Xauthority \] \; then"
               puts $fo "   serverargs=\"\$serverargs -auth \$HOME/.Xauthority\""
               puts $fo "fi"
               puts $fo "# end of code from tkedit"
            }
         }
         close $fo
         close $fi
         exec mv startx startx.orig
         exec mv startx.new startx
         exec chmod a+x startx
         cd $cwd
      }
   }
}

if {[catch {send "tkedit" "NoAction"}]} {
   set erg [tk_dialog .err "update message:" \
"NOTE: The send command did not work\n \
The following is an attempt to fix this.\n \
If this is not a stand-alone system, you\n \
should consider understanding the xauth\n \
mechanism and do everything by hand" \
      warning -1 "Go on" "skip"]
   if {$erg} {exit}
   if {![file exists ~/.Xauthority]} {
       set erg [tk_dialog .err "update message:" \
"You do not have a .Xauthority file yet!\n \
Do you want me to call xauth add ?" \
      warning -1 NO YES]
      if {$erg} {
         scan [exec id] "uid=%d %s gid=%d" uid dummy gid
         set x [format "%010x%010x%012x" $uid $gid [pid]]
         catch {eval "exec xauth add $env(DISPLAY) . $x"}
         ClearXhost
      }
   } else {
      if {[eval exec xauth list $env(DISPLAY)] == ""} {
         set erg [tk_dialog .err "update message:" \
"You do have a .Xauthority file,\n \
but this Display is not in the file.\n \
Do you want me to add this Display ?" \
         warning -1 NO YES]
         if {$erg} {
            scan [exec xauth list] "%s %s %s" disp prot key
            catch {eval "exec xauth add $env(DISPLAY) $prot $key"}
            ClearXhost
         }
      } else {
         if {[ClearXhost]} {
            tk_dialog .err "update message:" \
"You do have a .Xauthority file\n \
and your Display is in the file.\n \
and xhost is empty, access control enabled.\n \
Make shure your XServer is reading\n \
your .Xdefault file (-auth option)\n \
Please read the xauth man pages." \
            warning -1 "I'll have a look"
         }
      }
   }
} else {
   tk_dialog .err "update message:" \
"NOTE: The send command works" \
      warning -1 "So what ?"
}

exit
