;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:TCLTK; Base:10 -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                      Usage & Distribution Agreement                      ;;
;;                            Tk/Lisp Interface                             ;;
;;                                                                          ;;
;; This file is part of the Tk/Lisp Interface (TLI) developed by the        ;;
;; Lockheed Artificial Intelligence Center.  Use, duplication,              ;;
;; distribution, and disclosure of the TLI is subject to the following      ;;
;; restrictions and limitations.                                            ;;
;;                                                                          ;;
;; 1. Lockheed makes no warranty regarding the merchantability or fitness   ;;
;;    of the TLI for any particular purpose.                                ;;
;;                                                                          ;;
;; 2. Lockheed assumes no responsibility for the TLI and assumes no         ;;
;;    obligation to support or maintain the TLI.                            ;;
;;                                                                          ;;
;; 3. The TLI can be duplicated and redistributed without restriction,      ;;
;;    provided that this Usage & Distribution Agreement header is left      ;;
;;    intact and unaltered in the source code.                              ;;
;;                                                                          ;;
;; 4. The TLI can be modified and/or extended without restriction, provided ;;
;;    that all modifications and their authors are clearly noted in a       ;;
;;    header preceding this header in the source code files.                ;;
;;                                                                          ;;
;;    Lockheed asks that the authors of any such modifications or           ;;
;;    extensions to the TLI share them with the Lockheed AI Center in the   ;;
;;    same open manner as the Lockheed AI Center is sharing the TLI.        ;;
;;                                                                          ;;
;; Please send comments about or enhancements to the TLI to Dan Kuokka      ;;
;; (kuokka@aic.lockheed.com)  or Larry Harada (harada@aic.lockheed.com).    ;;
;;                                                                          ;;
;; For more information about the Lockheed AI Center, see our               ;;
;; World-Wide Web page @ http://www.rdd.lmsc.lockheed.com.                  ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;-----------------------------------------------------------------------------
;;; tk.cl
;;;
;;; Foreign function interface to Tk/Tcl.
;;;-----------------------------------------------------------------------------
(eval-when (:load-toplevel :compile-toplevel :execute)
  (unless (find-package :tcltk)
    (defpackage :tcltk))

  (in-package :tcltk)

  (import 'user::*tk-foreign-file-directory*)
  (import 'user::*tk-foreign-library-directory*)

  (require :foreign)
  (use-package :foreign-functions))

;;; Name conflicts between foreign entry points and Lisp internal entry
;;; points need to be removed at load time.
(eval-when (:load-toplevel :execute)
  (mapc #'(lambda (name) 
	    (when (ff:get-entry-point name)
	      (ff:remove-entry-point name)))

	;; Apparently these are in every Allegro image. I'm sure there are
	;; more that will appear as we use more of the Tk/Tcl libraries.
	'("_getpwuid"
	  "_getpwnam"
	  "_endpwent"
	  "_getpwent"
	  "_setpwent"
	  "_setpwfile"
	  "__unpack_quadruple"
	  "__prod_b10000"
	  "__carry_out_b10000"
	  "__prod_65536_b10000"
	  "__unpacked_to_decimal"))
 
  (load ""
	:foreign-files `(,(make-pathname 
			   :directory *tk-foreign-library-directory*
			   :name      "libtk.a")
			 ,(make-pathname
			   :directory *tk-foreign-library-directory*
			   :name      "libtcl.a"))

	:system-libraries '("X11" "m")

	:unreferenced-lib-names '("_Tcl_CreateCommand"
				  "_Tcl_CreateInterp"
				  "_Tcl_DeleteInterp"
				  "_Tcl_Eval"
				  "_Tcl_EvalFile"
				  "_Tk_CreateMainWindow"
				  "_Tk_DoOneEvent"
				  "_Tk_MainLoop"
				  "_Tk_MapWindow")))


;;;-----------------------------------------------------------------------------
;;; Exported symbols
;;;-----------------------------------------------------------------------------
(eval-when (:load-toplevel :execute)
  (export '(*tcl-ok* 
	    *tcl-error*
	    *tcl-return*
	    *tcl-break*
	    *tcl-continue*
	    tcl-eval
	    tcl-evalfile
	    tcl-createcommand
	    tcl-createinterp
	    tcl-deleteinterp)))

(eval-when (:load-toplevel :execute)
  (export '(*tk-readable*
	    *tk-writeable*
	    *tk-exception*
	    *tk-dont-wait*
	    *tk-x-events*
	    *tk-file-events*
	    *tk-timer-events*
	    *tk-idle-events*
	    *tk-all-events*
	    tk-createmainwindow
	    tk-mapwindow
	    tk-dooneevent
	    tk-mainloop)))

;;;-----------------------------------------------------------------------------
;;; Tcl constants (see tcl.h) - (note: convert to bit vectors)
;;;-----------------------------------------------------------------------------
(defconstant *tcl-ok*       0)
(defconstant *tcl-error*    1)
(defconstant *tcl-return*   2)
(defconstant *tcl-break*    3)
(defconstant *tcl-continue* 4)

;;;-----------------------------------------------------------------------------
;;; Tk constants (see tk.h)
;;;-----------------------------------------------------------------------------
(defconstant *tk-readable*      1)
(defconstant *tk-writable*      2)
(defconstant *tk-exception*     4)

(defconstant *tk-dont-wait*     1)
(defconstant *tk-x-events*      2)
(defconstant *tk-file-events*   4)
(defconstant *tk-timer-events*  8)
(defconstant *tk-idle-events*  16)
(defconstant *tk-all-events*   30)


;;;-----------------------------------------------------------------------------
;;; Tcl foreign function definitions
;;;-----------------------------------------------------------------------------
(defforeign 'tcl-eval			;args: interp cmd 
    :entry-point (convert-to-lang "Tcl_Eval" :language :c)
    :arguments '(integer string)
    :return-type :fixnum)

(defforeign 'tcl-evalfile		;args: interp filename
    :entry-point (convert-to-lang "Tcl_EvalFile" :language :c)
    :arguments '(integer string)
    :return-type :fixnum)


(defforeign 'tcl-createinterp		;args: void
    :entry-point (convert-to-lang "Tcl_CreateInterp" :language :c)
    :return-type :fixnum)


(defforeign 'tcl-deleteinterp		;args: interp
    :entry-point (convert-to-lang "Tcl_DeleteInterp" :language :c)
    :arguments '(integer)
    :return-type :void)

(defforeign 'tcl-createcommand	;args interp cmdname proc clientdata deleteproc
    :entry-point (convert-to-lang "Tcl_CreateCommand" :language :c)
    :arguments '(integer string integer integer integer)
    :return-type :void)


;;;-----------------------------------------------------------------------------
;;; Tk foreign function definitions
;;;-----------------------------------------------------------------------------
(defforeign 'tk-createmainwindow	;args: interp screenname basename class
    :entry-point (convert-to-lang "Tk_CreateMainWindow" :language :c)
    :arguments '(integer string string string)
    :return-type :fixnum)

(defforeign 'tk-mapwindow		;args: window
    :entry-point (convert-to-lang "Tk_MapWindow" :language :c)
    :arguments '(integer) 
    :return-type :fixnum)

(defforeign 'tk-dooneevent		;args: flags
    :entry-point (convert-to-lang "Tk_DoOneEvent" :language :c)
    :arguments '(integer)
    :return-type :fixnum)

(defforeign 'tk-mainloop		;args: void
    :entry-point (convert-to-lang "Tk_MainLoop" :language :c)
    :return-type :void)

;;; End of file.