/******************************************************************************/
/**                      Usage & Distribution Agreement                      **/
/**                            Tk/Lisp Interface                             **/
/**                                                                          **/
/** This file is part of the Tk/Lisp Interface (TLI) developed by the        **/
/** Lockheed Artificial Intelligence Center.  Use, duplication,              **/
/** distribution, and disclosure of the TLI is subject to the following      **/
/** restrictions and limitations.                                            **/
/**                                                                          **/
/** 1. Lockheed makes no warranty regarding the merchantability or fitness   **/
/**    of the TLI for any particular purpose.                                **/
/**                                                                          **/
/** 2. Lockheed assumes no responsibility for the TLI and assumes no         **/
/**    obligation to support or maintain the TLI.                            **/
/**                                                                          **/
/** 3. The TLI can be duplicated and redistributed without restriction,      **/
/**    provided that this Usage & Distribution Agreement header is left      **/
/**    intact and unaltered in the source code.                              **/
/**                                                                          **/
/** 4. The TLI can be modified and/or extended without restriction, provided **/
/**    that all modifications and their authors are clearly noted in a       **/
/**    header preceding this header in the source code files.                **/
/**                                                                          **/
/**    Lockheed asks that the authors of any such modifications or           **/
/**    extensions to the TLI share them with the Lockheed AI Center in the   **/
/**    same open manner as the Lockheed AI Center is sharing the TLI.        **/
/**                                                                          **/
/** Please send comments about or enhancements to the TLI to Dan Kuokka      **/
/** (kuokka@aic.lockheed.com)  or Larry Harada (harada@aic.lockheed.com).    **/
/**                                                                          **/
/** For more information about the Lockheed AI Center, see our               **/
/** World-Wide Web page @ http://www.rdd.lmsc.lockheed.com.                  **/
/******************************************************************************/

/*------------------------------------------------------------------------------
 * tkutils.c
 *
 * Miscellaneous utility functions to support Tcl/Tk Lisp foreign function 
 * interface.
 *------------------------------------------------------------------------------
 */
#include <tcl.h>
#include <tk.h>

/*------------------------------------------------------------------------------
 * unpack_argv() returns a char ptr to the entry in the array of strings.
 *------------------------------------------------------------------------------
 */
char *unpack_argv( base, index )
     char **base;
     int    index;
{
    return( base[ index ] );
}


/*------------------------------------------------------------------------------
 * set_interp_result() copies the string to the interp->result field. 
 * The res string must be static across lisp gc's; this must be guaranteed by
 * the calling Lisp functions.
 *------------------------------------------------------------------------------
 */
void set_interp_result( interp, res )
     Tcl_Interp *interp;
     char       *res;
{
    interp->result = res;
}


/*------------------------------------------------------------------------------
 * get_interp_result() returns the string from the interp->result field. 
 *------------------------------------------------------------------------------
 */
char *get_interp_result( interp )
     Tcl_Interp *interp;
{
    return( interp->result );
}

