;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:TCLTK; Base:10 -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                      Usage & Distribution Agreement                      ;;
;;                            Tk/Lisp Interface                             ;;
;;                                                                          ;;
;; This file is part of the Tk/Lisp Interface (TLI) developed by the        ;;
;; Lockheed Artificial Intelligence Center.  Use, duplication,              ;;
;; distribution, and disclosure of the TLI is subject to the following      ;;
;; restrictions and limitations.                                            ;;
;;                                                                          ;;
;; 1. Lockheed makes no warranty regarding the merchantability or fitness   ;;
;;    of the TLI for any particular purpose.                                ;;
;;                                                                          ;;
;; 2. Lockheed assumes no responsibility for the TLI and assumes no         ;;
;;    obligation to support or maintain the TLI.                            ;;
;;                                                                          ;;
;; 3. The TLI can be duplicated and redistributed without restriction,      ;;
;;    provided that this Usage & Distribution Agreement header is left      ;;
;;    intact and unaltered in the source code.                              ;;
;;                                                                          ;;
;; 4. The TLI can be modified and/or extended without restriction, provided ;;
;;    that all modifications and their authors are clearly noted in a       ;;
;;    header preceding this header in the source code files.                ;;
;;                                                                          ;;
;;    Lockheed asks that the authors of any such modifications or           ;;
;;    extensions to the TLI share them with the Lockheed AI Center in the   ;;
;;    same open manner as the Lockheed AI Center is sharing the TLI.        ;;
;;                                                                          ;;
;; Please send comments about or enhancements to the TLI to Dan Kuokka      ;;
;; (kuokka@aic.lockheed.com)  or Larry Harada (harada@aic.lockheed.com).    ;;
;;                                                                          ;;
;; For more information about the Lockheed AI Center, see our               ;;
;; World-Wide Web page @ http://www.rdd.lmsc.lockheed.com.                  ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;-----------------------------------------------------------------------------
;;; Tk Tree Extension
;;;
;;; The Tk tree extension is written in C++ and compiled with the g++ compiler.
;;;
;;; - The file tktreecmd.c also has to be compiled with the g++ compiler in 
;;;   order for the linkage specifications for treeCmd() to match and the 
;;;   Lisp loader to resolve the symbols correctly.
;;;
;;; - libg++.a and libgcc.a are required to support the tree extension libs.
;;;-----------------------------------------------------------------------------
(eval-when (:load-toplevel :compile-toplevel :execute)
  (unless (find-package :tcltk)
    (defpackage :tcltk))

  (in-package :tcltk)
					
  (import 'user::*tk-foreign-file-directory*)
  (import 'user::*tktree-foreign-library-directory*)
  (import 'user::*gcc-foreign-library-directory*)

  (require :foreign)			;Foreign function definitions.
  (use-package :foreign-functions))

(eval-when (:load-toplevel :execute)
  (load ""
	:foreign-files `(,(make-pathname
			   :directory *tk-foreign-file-directory*
			   :name      "tktreecmd.o")
			 ,(make-pathname
			   :directory *tktree-foreign-library-directory*
			   :name      "libtktree.a")
			 ,(make-pathname
			   :directory *tktree-foreign-library-directory*
			   :name      "libOS.a")
			 ,(make-pathname
			   :directory *gcc-foreign-library-directory*
			   :name      "lib/libg++.a")
			 ,(make-pathname
			   :directory *gcc-foreign-library-directory*
			   :name      "libgcc.a"))))


;;;-----------------------------------------------------------------------------
;;; Exported symbols
;;;-----------------------------------------------------------------------------
(eval-when (:load-toplevel :execute)
  (export '(register-tk-tree-cmd)))

;;;-----------------------------------------------------------------------------
;;; Invokes the procedure to define the Tk "tree".
;;;-----------------------------------------------------------------------------
(defforeign 'register-tk-tree-cmd ;args: interp window
    :entry-point (convert-to-lang "register_tk_tree_cmd" :language :c)
    :arguments '(integer integer)
    :return-type :void)

;;; End of file.