/*
 * tkpict.h --
 *
 * A header file for Pict images 
 *
 * Copyright (c) 1995 The Regents of the University of California.
 * 
 * Author: Pierre-Louis Bossart
 * Date: November 17, 1995
 *
 * Derived from tkImgPhoto.c in the tk4.0b2 distribution 
 * copyrighted as follows:
 *
 *    Copyright (c) 1994 The Australian National University.
 *    Copyright (c) 1994-1995 Sun Microsystems, Inc.
 *
 *    Author: Paul Mackerras (paulus@cs.anu.edu.au),
 *	      Department of Computer Science,
 *	      Australian National University.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */


#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <ctype.h>
#include <fcntl.h>
#include <unistd.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <tcl.h>
#include <tk.h>


#define UCHAR(c) ((unsigned char) (c))

extern Tk_ImageType                tkPictImageType;

typedef void *Tk_PictHandle;

extern _XInitImageFuncPtrs _ANSI_ARGS_((XImage *image));

/*
 * An unsigned 32-bit integral type, used for pixel values.
 * We use int rather than long here to accommodate those systems
 * where longs are 64 bits.
 */

typedef unsigned int pixel;

/*
 * The maximum number of pixels to transmit to the server in a
 * single XPutImage call.
 */

#define MAX_PIXELS 65536

/*
 * Definition of the data associated with each Pict image master.
 */

typedef struct PictMaster {
    Tk_ImageMaster tkMaster;	/* Tk's token for image master.  NULL means
				 * the image is being deleted. */
    Tcl_Interp *interp;		/* Interpreter associated with the
				 * application using this image. */
    Tcl_Command imageCmd;	/* Token for image command (used to delete
				 * it when the image goes away).  NULL means
				 * the image command has already been
				 * deleted. */
    int	flags;			/* Sundry flags, defined below. */
    int	width, height;		/* Dimensions of image. */
    int userWidth, userHeight;	/* User-declared image dimensions. */
    char *fileString;		/* Name of file to read into image. */
    char *dataString;		/* String value to use as contents of image. */
    char *format;		/* User-specified format of data in image
				 * file or string value. */
    char *data;                 /* original data read from file */
    int datatype;               /* datatype */
    int datasize;               /* datasize */
    int skip;                   /* size of header file in bytes */
    double user_dispmax;        /* max of data set by user */
    double user_dispmin;        /* min of data set by user */
    double dispmax;             /* max of data */
    double dispmin;             /* min of data */
    unsigned char *bytedata;	/* Local storage for 24-bit image. */
    Region validRegion;		/* X region indicating which parts of
				 * the image have valid image data. */
    struct PictInstance *instancePtr;
				/* First in the list of instances
				 * associated with this master. */
} PictMaster;

/*
 * Bit definitions for the flags field of a PictMaster.
 * COLOR_IMAGE:			1 means that the image has different color
 *				components.
 * IMAGE_CHANGED:		1 means that the instances of this image
 *				need to be redithered.
 */

#define COLOR_IMAGE		1
#define IMAGE_CHANGED		2

/*
 * The following data structure represents all of the instances of
 * a Pict image in windows on a given screen that are using the
 * same colormap.
 */

typedef struct PictInstance {
    PictMaster *masterPtr;	/* Pointer to master for image. */
    Display *display;		/* Display for windows using this instance. */
    Colormap colormap;		/* The image may only be used in windows with
				 * this particular colormap. */
    char colormap_level;        /* indicates what type of colormap is used */
    char has_overlay;           /* indicates whether instances has overlays */
    int ncolors;
    int lut_start;
    char atom;
    struct PictInstance *nextPtr;
				/* Pointer to the next instance in the list
				 * of instances associated with this master. */
    int refCount;		/* Number of instances using this structure. */
    Pixmap pixels;		/* X pixmap containing dithered image. */
    int width, height;		/* Dimensions of the pixmap. */
    XImage *imagePtr;		/* Image structure for converted pixels. */
    XVisualInfo visualInfo;	/* Information about the visual that these
				 * windows are using. */
    GC gc;			/* Graphics context for writing images
				 * to the pixmap. */
    GC overlay_gc;              /* Graphics context for writing overlays
				 * to the pixmap. */
    int setgc;                  /* GXcopy,GXand,GXor,GXXor */
    pixel redValues[256];	/* Maps 8-bit values of red intensity
				 * to a pixel value or index in pixelMap. */
} PictInstance;

/*
 * The following data structure is used to return information
 * from ParseSubcommandOptions:
 */

struct SubcommandOptions {
    int options;		/* Individual bits indicate which
				 * options were specified - see below. */
    char *name;			/* Name specified without an option. */
    int fromX, fromY;		/* Values specified for -from option. */
    int fromX2, fromY2;		/* Second coordinate pair for -from option. */
    int toX, toY;		/* Values specified for -to option. */
    int toX2, toY2;		/* Second coordinate pair for -to option. */
    int zoomX, zoomY;		/* Values specified for -zoom option. */
    int subsampleX, subsampleY;	/* Values specified for -subsample option. */
    char *format;		/* Value specified for -format option. */
};

/*
 * Bit definitions for use with ParseSubcommandOptions:
 * Each bit is set in the allowedOptions parameter on a call to
 * ParseSubcommandOptions if that option is allowed for the current
 * Pict image subcommand.  On return, the bit is set in the options
 * field of the SubcommandOptions structure if that option was specified.
 *
 * OPT_FORMAT:			Set if -format option allowed/specified.
 * OPT_FROM:			Set if -from option allowed/specified.
 * OPT_SHRINK:			Set if -shrink option allowed/specified.
 * OPT_SUBSAMPLE:		Set if -subsample option allowed/spec'd.
 * OPT_TO:			Set if -to option allowed/specified.
 * OPT_ZOOM:			Set if -zoom option allowed/specified.
 */

#define OPT_FORMAT	1
#define OPT_FROM	2
#define OPT_SHRINK	4
#define OPT_SUBSAMPLE	8
#define OPT_TO		0x10
#define OPT_ZOOM	0x20

/*
 * Default configuration
 */
#define DEF_Pict_HEIGHT	"0"
#define DEF_Pict_PALETTE	""
#define DEF_Pict_WIDTH		"0"

#undef MIN
#define MIN(a, b)	((a) < (b)? (a): (b))
#undef MAX
#define MAX(a, b)	((a) > (b)? (a): (b))

/*
 * The following structure describes a block of pixels in memory:
 */

typedef struct Tk_PictImageBlock {
    unsigned char *pixelPtr;	/* Pointer to the first pixel. */
    int		width;		/* Width of block, in pixels. */
    int		height;		/* Height of block, in pixels. */
    int		pitch;		/* Address difference between corresponding
				 * pixels in successive lines. */
    int		pixelSize;	/* Address difference between successive
				 * pixels in the same line. */
    char        datatype;
    char        datasize;
    char        copy;            /* flag requiring copy or not */
    int         skip;            /* number of bytes to skip from header */
} Tk_PictImageBlock;


#define NO_COPY 0
#define COPY 1

struct Tk_PictImageFormat {
    char *name;			/* Name of image file format */
    Tk_ImageFileMatchProc *fileMatchProc;
				/* Procedure to call to determine whether
				 * an image file matches this format. */
    Tk_ImageStringMatchProc *stringMatchProc;
				/* Procedure to call to determine whether
				 * the data in a string matches this format. */
    Tk_ImageFileReadProc *fileReadProc;
				/* Procedure to call to read data from
				 * an image file into a Pict image. */
    Tk_ImageStringReadProc *stringReadProc;
				/* Procedure to call to read data from
				 * a string into a Pict image. */
    Tk_ImageFileWriteProc *fileWriteProc;
				/* Procedure to call to write data from
				 * a Pict image to a file. */
    Tk_ImageStringWriteProc *stringWriteProc;
				/* Procedure to call to obtain a string
				 * representation of the data in a Pict
				 * image.*/
    struct Tk_PictImageFormat *nextPtr;
				/* Next in list of all Pict image formats
				 * currently known.  Filled in by Tk, not
				 * by image format handler. */
};

typedef struct Tk_PictImageFormat Tk_PictImageFormat;
extern Tk_PictImageFormat tkImgFmtVIEW;
extern Tk_PictImageFormat tkImgFmtVIFF;
extern Tk_PictImageFormat tkImgFmtGIF;
extern Tk_PictImageFormat tkImgFmtPPM;

extern void Tk_CreatePictImageFormat( Tk_PictImageFormat *formatPtr);
extern Tk_PictHandle Tk_FindPict(char *imageName);

extern void Tk_PictPutBlock( Tk_PictHandle handle, 
			    register Tk_PictImageBlock *block, 
			    int x, int y, int width, int height);
extern void Tk_PictPutZoomedBlock( Tk_PictHandle handle,
				  register Tk_PictImageBlock *blockPtr,
				  int x, int y, int width, int height,
				  int zoomX, int zoomY,
				  int subsampleX, int subsampleY);
extern void Tk_PictExpand(Tk_PictHandle handle,int width,int height);
extern void Tk_PictBlank( Tk_PictHandle handle);
extern void Tk_PictGetSize(Tk_PictHandle handle,int *width,int *height);
extern void Tk_PictSetSize(Tk_PictHandle handle,int width,int height);
extern int  Tk_PictGetImage(Tk_PictHandle handle,Tk_PictImageBlock *blockPtr);


extern int FileReadRAW(Tcl_Interp *interp, FILE *f,char *filename,
		       Tk_PictHandle imageHandle,int width,int height,
		       int type,int datasize,int skip);

extern void		DisposeInstance _ANSI_ARGS_((ClientData clientData));
extern void		Dither _ANSI_ARGS_((PictMaster *masterPtr,
			    int x, int y, int width, int height));
extern void		DitherInstance _ANSI_ARGS_((PictInstance *instancePtr,
			    int x, int y, int width, int height));



/* forward definitions */
#define BYTE 0
#define WORD 1
#define LWORD 2
#define REAL 3

#define MAXTABLES 16
#define MAXPLANES 8
#define MAX_COLORS 256
#define MAXWINDOWS 50
#define MAXLUTVALUE 255
#define S1 2.
#define S2 7.

#define READ_SHARED_COLORMAP 0
#define DEFAULT_SCREEN_COLORMAP 1
#define DEFAULT_PRIVATE_COLORMAP 2
#define NEW_PRIVATE_COLORMAP 3

extern int has_nde_segment;
extern int Private_Colormap;
extern int slice_nb;
extern int nb_slices;
extern XColor	 lut_colorcell_defs[MAX_COLORS];
extern XColor	 chColor[MAX_COLORS];
extern int n1;
extern int fn1;
extern int n2;
extern int fn2;

extern void non_linear_lut(Display *disp,Colormap cmap,XColor *chColor,
	      int ncolors,int lut_start,char overlay);
extern void gray(Display *disp,Colormap cmap,XColor *chColor,
		 int ncolors,int lut_start,char overlay);
extern void ct(Display *disp,Colormap cmap,XColor *chColor,
	       int ncolors,int lut_start,char overlay);
extern void hot(Display *disp,Colormap cmap,XColor *chColor,
		int ncolors,int lut_start,char overlay);
extern void cold(Display *disp,Colormap cmap,XColor *chColor,
		 int ncolors,int lut_start,char overlay);
extern void hls(Display *disp,Colormap cmap,XColor *chColor,
		int ncolors,int lut_start,char overlay);
extern void rgb(Display *disp,Colormap cmap,XColor *chColor,
		int ncolors,int lut_start,char overlay);
extern void spectrum(Display *disp,Colormap cmap,XColor *chColor,
		     int ncolors,int lut_start,char overlay);
extern void invert(Display *disp,Colormap cmap,XColor *chColor,
		   int ncolors,int lut_start,char overlay);
extern void randwalk_spectrum(Display *disp,Colormap cmap,XColor *chColor,
			      int ncolors,int lut_start,char overlay);
extern void bowlerhat(Display *disp,Colormap cmap,XColor *chColor,
		      int ncolors,int lut_start,char overlay);
extern void tophat(Display *disp,Colormap cmap,XColor *chColor,
		   int ncolors,int lut_start,char overlay);
extern void hatgray(Display *disp,Colormap cmap,XColor *chColor,
		    int ncolors,int lut_start,char overlay);
extern void hatct(Display *disp,Colormap cmap,XColor *chColor,
		  int ncolors,int lut_start,char overlay);
extern void lut_thres(Display *disp,Colormap cmap,XColor *chColor,
		      int ncolors,int lut_start,char overlay,
		      int loval,int hival);

extern void lut_ramp(int *lut,int begin,float beginv,int end,float endv);
extern void set_hls(int *red,int *green,int *blue);
extern void convert_HLS_rgb(float H,float L,float S,int *r,int *g,int *b);

extern int init_colors(Display *disp,Colormap *colormap,Visual *visual,
		       char *colormap_level,
		       int *numcolors,int *start_lut,char *atom);

extern void deinit_disp(Display *disp);
extern XVisualInfo *get_visual(Display *disp);

extern void get_lut(XColor *chColor,
		    int ncolors,int lut_start,
		    int *red,int *green,int *blue);

extern void put_lut(Display *disp,Colormap cmap,XColor *chColor,
		    int ncolors,int lut_start,char overlay,
		    int *red,int *green,int *blue);

extern void PutOverlayMask(PictInstance *instancePtr,int xStart,int yStart,
			   int width,int height,unsigned char *mask);

extern int GetOverlayMask(PictInstance *instancePtr,
			  Tk_PictImageBlock *blockPtr);

extern void DisableOverlays(PictInstance *instancePtr);
extern void EnableOverlays(PictInstance *instancePtr);






