source $env(VISU_ENV)/library/visu/coledit.tcl
source $env(VISU_ENV)/library/visu/overlay.tcl

set nb 0
set win_nb 0
set wid 0
set len 0
set curr_nb_slices 0
set curr_filename {}
set nb_slices 0
set scale_slice 0
set slice_nb 0
set img_nb 0
set dest 0
set palette_button 0
set cmap gray
set curr_min 0
set curr_max 255
set thres_incr 1
set thres_res 1
set DispMax 0
set DispMin 0
set userDispMax 0
set userDispMin 0
set Private_Colormap 1
set def_font "-*-helvetica-bold-r-normal-*-14-*-*-*-*-*-*-*"



proc quit {} { exit }

proc destroywin win {
    global img_array win_array curr_img title_array dest color_bar_img


    if { [info exists img_array($win.c)] } {
	unset title_array($win)
	if { $curr_img == $img_array($win.c) } {
	    unset win_array($img_array($win.c))
	    unset img_array($win.c)
	    set new_img [lindex [array names win_array] 0]
	    if { $new_img != {} } {
		set curr_img $new_img
		set_curr_defaults $curr_img
		set_curr_event_loop [winfo toplevel $win_array($curr_img)]
		set_active_title [winfo toplevel $win_array($curr_img)]
	    } else {
		if { [info exists color_bar_img] } {
		    set curr_img $color_bar_img
		}   
	    }
	} else {
	    unset win_array($img_array($win.c))
	    unset img_array($win.c)
	}
	destroy $win
	update idletasks
    }
}

proc delete img {
    upvar $img img1
    global win_array img_array filename_array nb_slices_array 
   
    if { [info exists win_array($img1)] } {
	unset img_array($win_array($img1).c)
	destroy $win_array($img1)
	unset win_array($img1)
    }
    image delete $img1
  
    unset filename_array($img1)
    unset nb_slices_array($img1)
    unset img1

    set new_img [lindex [array names win_array] 0]
    if { $new_img != {} } {
	set curr_img $new_img
	set_curr_defaults $curr_img
	set_curr_event_loop [winfo toplevel $win_array($curr_img)]
	set_active_title [winfo toplevel $win_array($curr_img)]
    } else {
	if { [info exists color_bar_img] } {
	    set curr_img $color_bar_img
	}   
    }
}

proc topConfig { win w h } {
	global wid len sbwidth

    if { [lsearch [pack slaves $win] "$win.xscroll"] == -1 } {
	set hasX 0
    } else  {
	set hasX 1
    }
    if { [lsearch [pack slaves $win] "$win.yscroll"] == -1 } {
	set hasY 0
    } else  {
	set hasY 1
    }
    if {$w >= $wid} {
	if {$hasX} {
	    pack forget $win.xscroll
	    set hasX 0
	}
    } else {
	if {!$hasX} {
	    pack $win.xscroll -before $win.c -side bottom -expand 1 -fill x
	    set hasX 1
	}
    }
    if {$h >= $len+$hasX*$sbwidth} {
	if {$hasY} {
	    pack forget $win.yscroll
	    set hasY 0
	}
    } else {
	if {!$hasY} {
	    pack $win.yscroll -before $win.c -side right -expand 1 -fill y
	    set hasY 1
	}
    }
    #
    # Check again since we now might need the vertical scrollbar
    # after all.
    #
    if {$w >= $wid+$hasY*$sbwidth} {
	if {$hasX} {
	    pack forget $win.xscroll
	    set hasX 0
	}
    } else {
	if {!$hasX} {
	    pack $win.xscroll -before $win.c -side bottom -expand 1 -fill x
	    set hasX 1
	}
    }
}
proc disp_priv img {
    upvar $img img1
    global Private_Colormap 

    if { [info exists img1] } {
	set Private_Colormap 3
	disp img1
    }
}

proc disp img {
    upvar $img img1
    global win_array win_nb filename_array title_array wid len sbwidth img_array curr_img 
   
    if { ![ info exists win_array($img1)] } {
	set win_nb [expr $win_nb+1]
	set win ".win$win_nb"
	toplevel $win
	set title_array($win) "<$win_nb>: "
	
	set wid [image width $img1]
	set len [image height $img1]
	
	wm maxsize $win $wid $len
	canvas $win.c -width $wid -height $len -borderwidth 0 -highlightthickness 0
	$win.c create image 0 0 -anchor nw -image $img1
	pack $win.c -side top -expand 0 -fill none -in $win

	scrollbar $win.yscroll -orient vertical \
		-command [list $win.c yview] -width 12
	scrollbar $win.xscroll -orient horizontal \
		-command [list $win.c xview] -width 12

	set sbwidth [winfo reqwidth $win.yscroll]

	pack $win.yscroll -side right -fill y -expand 0 -after $win.c
	pack $win.xscroll -side bottom -fill x -expand 0 -after $win.c

	$win.c configure -yscrollcommand "$win.yscroll set" \
		-xscrollcommand "$win.xscroll set" 
	$win.c config -scrollregion "0 0 $wid $len" -confine 1
	bind $win <Configure> "topConfig [winfo toplevel $win] %w %h"

	set img_array($win.c) $img1
	set win_array($img1) $win
	
    }
    set_curr_defaults $img1
    set_curr_event_loop $win_array($img1)
    set_active_title $win_array($img1)
    
}



proc set_active_title win {
    global title_array img_array filename_array seq_array curr_slice_array 

    foreach l [array names img_array] {
	set w [winfo toplevel $l]
	if { $seq_array($img_array($w.c)) == 1 } {
	    wm title $w "$title_array($w) [file tail $filename_array($img_array($w.c))]$curr_slice_array($img_array($w.c)).sdt"
	} else {
	    wm title $w "$title_array($w) [file tail $filename_array($img_array($w.c))]:$curr_slice_array($img_array($w.c))"
	}
    }
    if { $seq_array($img_array($win.c)) == 1 } {
	wm title $win "$title_array($win) [file tail $filename_array($img_array($win.c))]$curr_slice_array($img_array($win.c)).sdt ACTIVE"
    } else {
	wm title $win "$title_array($win) [file tail $filename_array($img_array($win.c))]:$curr_slice_array($img_array($win.c)) ACTIVE"
    }    
}

proc update_active_title win {
    global title_array img_array filename_array seq_array curr_slice_array 

    if { $seq_array($img_array($win.c)) == 1 } {
	wm title $win "$title_array($win) [file tail $filename_array($img_array($win.c))]$curr_slice_array($img_array($win.c)).sdt ACTIVE"
    } else {
	wm title $win "$title_array($win) [file tail $filename_array($img_array($win.c))]:$curr_slice_array($img_array($win.c)) ACTIVE"
    }    
}


proc set_curr_defaults img {
    global curr_img img_array curr_filename filename_array curr_nb_slices \
	    nb_slices_array scale_slice curr_slice_array wid len dest DispMin DispMax

    set curr_img $img
    set curr_filename $filename_array($curr_img)
    set curr_nb_slices $nb_slices_array($curr_img)
    set scale_slice $curr_slice_array($curr_img) 
    if { $scale_slice > $curr_nb_slices } {
	set scale_slice $curr_nb_slices
    }
    set len [image height $curr_img]
    set wid [image width $curr_img]
    .slice configure -to [expr $nb_slices_array($curr_img)-1]
    set DispMin [$curr_img getmin]
    set DispMax [$curr_img getmax]
    update_scale
}

proc set_curr_event_loop win {
    global curr_img wid len x y pix dest img_array

    bind $win <Destroy> {
	set win [winfo toplevel %W]
	puts "destroying"
	bind $win <Destroy> {}
	#if { $dest != 1 } {
	    destroywin $win
	#    set dest 1
	#}
    }

    bind $win.c <Destroy> {
	set win [winfo toplevel %W]
	bind $win <Destroy> {}
	#if { $dest != 1 } {
	    destroywin $win
	  #  set dest 1
	#}
    }

    bind $win <Enter> {
	set dest 0
	set win [winfo toplevel %W]
	if { ![info exists curr_img] } {
	    set dest 0
	    set_curr_defaults $img_array($win.c)
	    set_active_title $win
	}
    }

    bind $win.c <Enter> {
	set dest 0
	set win [winfo toplevel %W]
	if { ![info exists curr_img] } {
	    set dest 0
	    set_curr_defaults $img_array($win.c)
	    set_active_title $win
	}
    }

    bind $win.c <Button-1> {
	set can %W
	set win [winfo toplevel %W]
	set_curr_defaults $img_array($win.c)
	set_active_title [winfo toplevel %W]
	set x [expr int([$can canvasx %x])]
	set y [expr int([$can canvasy %y])]
	#$can create line 0 0 $wid 0 -tags horlin -fill yellow
	#$can create line 0 0 0 $len -tags verlin -fill yellow
	#$can coords horlin 0 $y $wid $y 
	#update idletasks
	#$can coords verlin $x 0 $x $len
	#update idletasks
	if {  ($x>0) && ($x<$wid) && ($y>0) && ($y<$len) } {
	    set pix [$curr_img get $x $y]
	}
    }

    bind $win.c <B1-Motion> {
	set can %W
	set x [expr int([$can canvasx %x])]
        set y [expr int([$can canvasy %y])]
        #$can coords horlin 0 $y $wid $y 
        #update idletasks
        #$can coords verlin $x 0 $x $len
        #update idletasks
        if { ($x>0) && ($x<$wid) && ($y>0) && ($y<$len) } {
           set pix [$curr_img get $x $y] 
        }
    }
    bind $win.c <ButtonRelease-1> {
        #%W delete horlin
        #%W delete verlin
    }            
    bind $win.c <Motion> {
        set y [expr int([%W canvasy %y])]
        set x [expr int([%W canvasx %x])]
        update idletasks
        if { ($x>0) && ($x<$wid) && ($y>0) && ($y<$len) } {
           set pix [$curr_img get $x $y] 
        }
    }
}

proc profile1 value {
    global curr_img
    global dline	
    global xoffset
    global yoffset
    global dx
    global dy
    global gheight

    puts "dx $dx dy $dy"
    set  l [$curr_img getline $value $xoffset [expr $gheight+$yoffset] $dx $dy]
    #puts $l
    eval {set dline [.n.c create line} $l {]}
    update idletasks
}

proc disp1d {} {
    
    toplevel .n
    #set win_width [winfo width .n]
    #set win_height [winfo height .n]

    set win_width 800
    set win_height 500
    set nb_pts 250
    set gwidth [expr $win_width*90/100]
    set gheight [expr $win_height*90/100]
    set xoffset [expr ($win_width-$gwidth)/2+10]
    set yoffset [expr ($win_height-$gheight)/2]
    set dx [expr $gwidth/$nb_pts.0]
    set dy [expr $gheight/255.0]
    set xmtm_inc [expr 10*$gwidth/$nb_pts]
    set ymtm_inc [expr 10*$gheight/255]
    set ixmtm [expr $gwidth/$xmtm_inc]
    set iymtm [expr $gheight/$ymtm_inc]
    set xmtm_size 10
    set ymtm_size 10
    
    puts "gwidth $gwidth gheight $gheight xmtm_inc $xmtm_inc ymtm_inc $ymtm_inc ixmtm $ixmtm iymtm $iymtm"

    canvas .n.c -width $win_width -height $win_height
    pack .n.c

    .n.c create line $xoffset [expr $gheight+$yoffset] [expr $xoffset+$gwidth]  [expr $gheight+$yoffset]
    for {set i 0} {$i<$ixmtm} {incr i} {
	.n.c create line [expr $xoffset+($i*$xmtm_inc)] [expr $gheight+$yoffset] [expr $xoffset+($i*$xmtm_inc)]  [expr $gheight+$yoffset+$xmtm_size]
	.n.c create text [expr $xoffset+($i*$xmtm_inc)-10] [expr $gheight+$yoffset+3*$xmtm_size] -text [expr $i*10] -anchor sw
    }

    .n.c create line $xoffset [expr $gheight+$yoffset] $xoffset $yoffset
    for {set i 0} {$i<$iymtm} {incr i} {
	.n.c create line [expr $xoffset-$ymtm_size] [expr $yoffset+$gheight-$i*$ymtm_inc] $xoffset [expr $yoffset+$gheight-$i*$ymtm_inc]
	.n.c create text [expr $xoffset-4*$ymtm_size] [expr $gheight+$yoffset-($i+0.5)*$ymtm_inc] -text [expr $i*10] -anchor nw
    }
}

proc profile2 value {
    global curr_img
    global dline
    global cxscale
    global cyscale
    global xoffset
    global yoffset
    global dx
    global dy
    global gheight

    set  l [$curr_img getline $value $xoffset [expr $gheight+$yoffset] $dx $dy]
    eval {.n.c coords $dline} $l
    update idletasks
}

proc rdfile { file img {args {}} } {
    upvar $img img1
   
    global scale_slice wid len win_array filename_array slice_nb \
	    nb_slices_array nb_slices curr_nb_slices curr_slice_array seq_array sbwidth
  
    if { $file == {} } {
	return
    }
    if { ![info exists img1] } {
	set new 1
    } else { set new 0 }
    
    set seqbase [string range $file 0 [string last _ $file]]
    set seqend [string range $file [string last _ $file] end]
    
    if {$new == 1} { 
	set img1 [image create pict]
	if { $args != {} } {
	    eval { $img1 read $file } $args
	} else {
	    $img1 read $file
	}
	if { [scan $seqend "_%d.sdt" seqnum]==1 } {
	    set slice_nb 0
	    set scale_slice $seqnum
	    set filename_array($img1) $seqbase
	    set nb_slices_array($img1) [llength [glob [format "%s*.sdt" $seqbase]]]
	    set seq_array($img1) 1
	    set curr_slice_array($img1) $seqnum
	} else {
	    set slice_nb 0
	    set scale_slice 0
	    set filename_array($img1) $file
	    set nb_slices_array($img1) $nb_slices
	    set seq_array($img1) 0
	    set curr_slice_array($img1) 0
	}
    } else {

	if { [scan $seqend "_%d.sdt" seqnum]==1 } {
	    set slice_nb 0
	    set scale_slice $seqnum
	    
	    if { $args != {} } {
		eval {$img1 read $file} $args
	    } else {
		$img1 read $file
	    }
	    set filename_array($img1) $seqbase
	    set nb_slices_array($img1) [llength [glob [format "%s*.sdt" $seqbase]]]
	    set seq_array($img1) 1
	    set curr_slice_array($img1) $seqnum
	} else {
	    set slice_nb 0
	    set scale_slice 0
	    
	    if { $args != {} } {
		eval { $img1 read $file } $args
	    } else {
		$img1 read $file
	    }
	    set filename_array($img1) $file
	    set nb_slices_array($img1) $nb_slices
	    set seq_array($img1) 0
	    set curr_slice_array($img1) 0
	}
	if { [ info exists win_array($img1)] } {
	    set wid [image width $img1]
	    set len [image height $img1]
	    $win_array($img1).c configure -width $wid -height $len 
	    $win_array($img1).c configure -scrollregion "0 0 $wid $len" -confine 1
	    wm maxsize $win_array($img1) $wid $len
	    wm geometry $win_array($img1) [format "%dx%d" $wid $len]
	    set sbwidth [winfo reqwidth $win_array($img1).yscroll]
	    topConfig $win_array($img1) $wid $len
	}
    }
    set_curr_defaults $img1
}

proc rdbinary { file img {args {}} } {
    upvar $img img1
   
    global scale_slice wid len win_array filename_array slice_nb \
	    nb_slices_array nb_slices curr_nb_slices curr_slice_array seq_array sbwidth
  
    if { $file == {} } {
	return
    }
    if { ![info exists img1] } {
	set new 1
    } else { set new 0 }
    
    set seqbase [string range $file 0 [string last _ $file]]
    set seqend [string range $file [string last _ $file] end]
    
    if {$new == 1} { 
	set img1 [image create pict]
	if { $args != {} } {
	    eval { $img1 rdbinary -file $file } $args
	} else {
	    $img1 rdbinary -file $file
	}
	if { [scan $seqend "_%d.sdt" seqnum]==1 } {
	    set slice_nb 0
	    set scale_slice $seqnum
	    set filename_array($img1) $seqbase
	    set nb_slices_array($img1) [llength [glob [format "%s*.sdt" $seqbase]]]
	    set seq_array($img1) 1
	    set curr_slice_array($img1) $seqnum
	} else {
	    set slice_nb 0
	    set scale_slice 0
	    set filename_array($img1) $file
	    set nb_slices_array($img1) $nb_slices
	    set seq_array($img1) 0
	    set curr_slice_array($img1) 0
	}
    } else {

	if { [scan $seqend "_%d.sdt" seqnum]==1 } {
	    set slice_nb 0
	    set scale_slice $seqnum
	    
	    if { $args != {} } {
		eval {$img1 rdbinary -file $file} $args
	    } else {
		$img1 rdbinary -file $file
	    }
	    set filename_array($img1) $seqbase
	    set nb_slices_array($img1) [llength [glob [format "%s*.sdt" $seqbase]]]
	    set seq_array($img1) 1
	    set curr_slice_array($img1) $seqnum
	} else {
	    set slice_nb 0
	    set scale_slice 0
	    
	    if { $args != {} } {
		eval { $img1 rdbinary -file $file } $args
	    } else {
		$img1 rdbinary -file $file
	    }
	    set filename_array($img1) $file
	    set nb_slices_array($img1) $nb_slices
	    set seq_array($img1) 0
	    set curr_slice_array($img1) 0
	}
	if { [ info exists win_array($img1)] } {
	    set wid [image width $img1]
	    set len [image height $img1]
	    $win_array($img1).c configure -width $wid -height $len 
	    $win_array($img1).c configure -scrollregion "0 0 $wid $len" -confine 1
	    wm maxsize $win_array($img1) $wid $len
	    wm geometry $win_array($img1) [format "%dx%d" $wid $len]
	    set sbwidth [winfo reqwidth $win_array($img1).yscroll]
	    topConfig $win_array($img1) $wid $len
	}
    }
    set_curr_defaults $img1
}

proc upslice {} {
    global curr_img scale_slice

    if { [info exists curr_img] } {
	set nb [expr $scale_slice+1]
	rdslice curr_img $nb
    }
}

proc downslice {} {
    global curr_img scale_slice

    if { [info exists curr_img] } {
	set nb [expr $scale_slice-1]
	rdslice curr_img $nb
    }
}

proc rdslice { img nb } {
    upvar $img img1

    global scale_slice slice_nb nb_slices_array wid len filename_array curr_img seq_array curr_slice_array win_array
    
    if { ![info exists img1] } { #Create variable first
	return
    }   
    if {  $nb_slices_array($img1) == 0 }  {#just one image 
	return
    }
    if { $nb<0 } {
	return
    }
    set scale_slice $nb
    set curr_slice_array($img1) $nb
    if { $seq_array($img1)== 0 } {
	# now just read image slice $scale_slice
	set slice_nb $scale_slice
	$img1 read $filename_array($img1)
    } else {
	set slice_nb 0
	$img1 read [format "%s%d.sdt" $filename_array($img1) $nb]
    }
    set_curr_defaults $img1
    if { [info exists win_array($img1)] } {
	update_active_title $win_array($img1)
    }
}

proc make_img {img {src_img {}} {name {}} } {
    upvar $img img1
   
    global filename_array nb_slices_array curr_slice_array seq_array 
  
    if { ![info exists img1] } {
	set img1 [image create pict]
	if { $src_img== {} } {
	    set nb_slices_array($img1) 0
	    set seq_array($img1) 0
	    set curr_slice_array($img1)  0
	} else {
	    set nb_slices_array($img1) $nb_slices_array($src_img)
	    set seq_array($img1) $seq_array($src_img)
	    set curr_slice_array($img1) $curr_slice_array($src_img) 
	}
	if { $name=={} } {
	    set filename_array($img1) "make_img"
	} else {
	    set filename_array($img1) $name
	}
    }
}

proc wrfile {img {name {}} {args {}} } {
     global filename_array nb_slices_array curr_slice_array seq_array 

    if { [info exists img] } {
	if { $name=={} } {
	    if { $seq_array($img) == 1 } {
		set name "$filename_array($img)$curr_slice_array($img)"
	    } else {
		set name $filename_array($img)
	    }
	}
	set text [format "Do you really want \n to save file \n %s ?" $name]
	set sure [tk_dialog .d {Save to disk} $text warning 0 {cancel} {save file as} {save file} ]
	if { $sure==0 } {
	    return
	}
	if { $sure==1 } {
	    set name [fileselect]
	    if { $name == {} } {
		return
	    }
	}

	if { $args=={} } {
	    $img write $name
	    #puts "saving: $img write $name"
	} else {
	    $img write $name $args
	    #puts "saving: $img write $name $args"
	}
    }
}  

proc zoom { img {zx 1} {zy 1} {subx 1} {suby 1} } {
    upvar $img img1
    global wid len nb_slices_array filename_array curr_img seq_array curr_slice_array
    
    if { ![info exists img1] } { #Create variable first
       return
    }   
    
    set g [image create pict]
    $g copy $img1 -zoom $zx $zy -subsample $subx $subx
    set nb_slices_array($g) $nb_slices_array($img1)
    set filename_array($g) $filename_array($img1)
    set seq_array($g) $seq_array($img1)
    set curr_slice_array($g) $curr_slice_array($img1)
    unset nb_slices_array($img1)
    unset filename_array($img1)
    unset seq_array($img1)
    unset curr_slice_array($img1)
    unset img1
    set img1 $g
    unset g
    set_curr_defaults $img1
    if { [ info exists win_array($img1)] } {
	set wid [image width $img1]
	set len [image height $img1]
	$win_array($img1).c configure -width $wid -height $len 
	$win_array($img1).c configure -scrollregion "0 0 $wid $len" -confine 1
	wm maxsize $win_array($img1) $wid $len
	wm geometry $win_array($img1) [format "%dx%d" $wid $len]
	set sbwidth [winfo reqwidth $win_array($img1).yscroll]
	topConfig $win_array($img1) $wid $len
    }
}

proc colorbar { {img {}} } {
    global color_bar_img

    if { ![info exists color_bar_img] } {
	if { $img != {} } {
	    set wid [image width $img]
	    set len 30
	} else {
	    set wid 400
	    set len 30
	}
	set color_bar_img [image create pict -width $wid -height $len]
	$color_bar_img colorbar
    }
    disp_colorbar 
}
proc disp_colorbar { } {
    global color_bar_img win_color_bar curr_img palette_button win Private_Colormap
   
    if { ![ info exists win_color_bar] } {
	set win_color_bar 1
	set win ".win_color_bar"
	toplevel $win
	
	set wid [image width $color_bar_img]
	set len [image height $color_bar_img]
	set Private_Colormap 0
	wm maxsize $win $wid $len
	wm title $win "Colorbar"
	canvas $win.c -width $wid -height $len -borderwidth 0 -highlightthickness 0
	$win.c create image 0 0 -anchor nw -image $color_bar_img
	pack $win.c -side top -expand 0 -fill none -in $win
	if { ![info exists curr_img] } {
	    set curr_img $color_bar_img
	}
	bind $win.c <Destroy> {
	    if { $win_color_bar == 1 } {
		if { $color_bar_img == $curr_img } {
		    image delete $color_bar_img
		    unset color_bar_img
		    unset win_color_bar
		    unset curr_img
		} else {
		    image delete $color_bar_img
		    unset color_bar_img
		    unset win_color_bar
		}
	    }
	}
    }
}

proc movie { img {first 0} {nb {}} } {
    upvar $img img1
    global nb_slices_array slice_nb scale_slice
    
    if { ![info exists img1] } { 
	#puts "Create variable first"
	return
    }   
    if {  $nb_slices_array($img1) == 0 } {
	#puts "just one image "
	return
    }
    
    if { $first > $nb_slices_array($img1) } {
	return
    }
    
    for {set i $first} {$i<$nb} {incr i} {
	if { $i > $nb_slices_array($img1) } {
	    set scale_slice $nb_slices_array($img1)
	    set slice_nb $nb_slices_array($img1)
	} else { 
	    set scale_slice $i
	    set slice_nb $i
	}
	#read image slice $scale_slice
	$img1 read $filename_array($img1)
	disp img1
	update idletasks
    }
}




proc control_panel {} {
    global  DispMin DispMax curr_img x y pix wid len scale_slice nb_slices_array curr_slice_array palette_button def_font Private_Colormap userDispMin userDispMax
	  

    set pixtop .
    wm geometry . 500x130+10+30
    wm title $pixtop "Control Panel"
    set f0 [frame $pixtop.f0]
  
    menubutton .new -text New -menu .new.cmap -font $def_font -relief raised
    menu .new.cmap
    .new.cmap add radiobutton -label "Shared Colormap" -variable Private_Colormap -value 0 -font $def_font
    .new.cmap add radiobutton -label "Default Colormap" -variable Private_Colormap -value 1 -font $def_font
    .new.cmap add radiobutton -label "Shared Private Cmap" -variable Private_Colormap -value 2 -font $def_font
    .new.cmap add radiobutton -label "Private Colormap" -variable Private_Colormap -value 3 -font $def_font
    .new.cmap add separator
    .new.cmap add command -label "Read data" -command "image_open 1" -font $def_font
  
    button .open -text Open -command "image_open 0" -font $def_font
    button .palette -text Palette -command "make_palette 1" -font $def_font
    button .overlay -text Overlays -command "make_overlay" -font $def_font
    button .quit -text Quit -command exit -font $def_font
    pack .new .open .palette .overlay .quit -side left -fill x -expand 1 -in $f0
    pack $f0 -side top -fill both -expand 1 
    set palette_button 1
    set f1 [frame $pixtop.f1]

    set f2 [frame $pixtop.f2 -width 4c]
    entry $f2.x -width 4 -textvariable x
    label $f2.label1 -text "x" -font $def_font
    entry $f2.y -width 4 -textvariable y
    label $f2.label2 -text " = " -font $def_font
    label $f2.pix -textvariable pix -font $def_font
    pack $f2.x $f2.label1 $f2.y $f2.label2 $f2.pix -side left -in $f2
    pack $f2 -side left -fill y -expand 0 -in $f1
   
    set f3 [frame $pixtop.f3]
    label $f3.text -text "rows" -font $def_font
    label $f3.value -textvariable len -font $def_font
    pack $f3.text $f3.value -side left -expand 0 -fill none -in $f3
   
    
    set f4 [frame $pixtop.f4]
    label $f4.text -text "cols" -font $def_font
    label $f4.value -textvariable wid -font $def_font
    pack $f4.text $f4.value -side left -expand 0 -fill none -in $f4

    set f5 [frame $pixtop.f5]
    label $f5.text -text "nb_slices" -font $def_font
    label $f5.value -textvariable curr_nb_slices -font $def_font
    pack $f5.text $f5.value -side left -expand 0 -fill none -in $f5

    pack $f5 -side right -expand 0 -fill none -anchor e -in $f1
    pack $f4 -side right -expand 0 -fill none -anchor e -in $f1
    pack $f3 -side right -expand 0 -fill none -anchor e -in $f1

    pack $f1 -side top -fill both -expand 1
    
    set f6 [frame $pixtop.f6]
    label $f6.labelumin -text "user min " -font $def_font
    entry $f6.umin -width 7 -textvariable userDispMin -font $def_font
    label $f6.labelumax -text " user max " -font $def_font
    entry $f6.umax -width 7 -textvariable userDispMax -font $def_font
    label $f6.labelmin -text " min " -font $def_font
    label $f6.min -textvariable DispMin -font $def_font
    label $f6.labelmax -text " max " -font $def_font
    label $f6.amax -textvariable DispMax -font $def_font
    pack $f6.labelumin $f6.umin $f6.labelumax $f6.umax $f6.labelmin $f6.min $f6.labelmax $f6.amax -side left -expand 0 -fill x -in $f6
    pack $f6 -side top -fill both -expand 1

    set slice [frame $pixtop.f7]
    label .slicetext -text "slice number" -font $def_font
    button .plus -text ">>" -command "upslice" -font $def_font
    button .minus -text "<<" -command "downslice" -font $def_font
    scale .slice -from 0 -to 9 -orient horizontal \
        -variable scale_slice -length 8c
    pack .slicetext .plus .minus .slice -side left -expand 1 -fill x -in $slice
    pack $slice -side top
    
    bind .slice <ButtonRelease> {
	if { ![info exists curr_img] } {
	    return
	}
	if {  $nb_slices_array($curr_img) == 0 } {
	    #just one image 
	    set scale_slice 0
	}
	if { $scale_slice > $nb_slices_array($curr_img) } {
	    set scale_slice $nb_slices_array($curr_img)
	} 
	set curr_slice_array($curr_img) $scale_slice
        rdslice curr_img $scale_slice
    }


    bind $f2.x <Leave> {
	if { ($x>0) && ($x<$wid) && ($y>0) && ($y<$len) } {
	    set pix [$curr_img get $x $y]	
	}
    }	
    bind $f2.x <Return> {
	if { ($x>0) && ($x<$wid) && ($y>0) && ($y<$len) } {
	    set pix [$curr_img get $x $y]	
	}
    }	 
    bind $f2.y <Leave> {
	if { ($x>0) && ($x<$wid) && ($y>0) && ($y<$len) } {
	    set pix [$curr_img get $x $y] 
	}
    }	
    bind $f2.y <Return> {
	if { ($x>0) && ($x<$wid) && ($y>0) && ($y<$len) } {
	    set pix [$curr_img get $x $y] 
	}
    }	
    
    bind $f6.umin <Return> {
	normalize $userDispMin $userDispMax
    }
   
    bind $f6.umax <Return> {
	normalize $userDispMin $userDispMax
    }

}


proc make_palette { {pal 0} } {
    global curr_img loval hival midthresval diffthresval coledit cwid clen cx cy p1 p2 palette_button curr_min curr_max thres_incr thres_res def_font
	   
    if { $palette_button != 0} {
	.palette configure -state disabled
    }
    if { $pal != 0 } {
	set pal [toplevel .pal]
    } else {
	set pal .
    }
    wm geometry $pal +580+30
    wm title $pal "Palette operations"
    set color [frame $pal.f1]
    set cmap "gray"
    radiobutton $color.gray -text gray -variable cmap -value gray -command colormap -font $def_font
    radiobutton $color.ct -text ct -variable cmap -value ct -command colormap -font $def_font
    radiobutton $color.hot -text hot -variable cmap -value hot -command colormap -font $def_font
    radiobutton $color.cold -text cold -variable cmap -value cold -command colormap -font $def_font
    radiobutton $color.hls -text hls -variable cmap -value hls -command colormap -font $def_font
    radiobutton $color.rgb -text rgb -variable cmap -value rgb -command colormap -font $def_font
    radiobutton $color.spectrum -text spectrum -variable cmap -value spectrum -command colormap -font $def_font
    radiobutton $color.invert -text invert -variable cmap -value invert -command colormap -font $def_font
    radiobutton $color.rand -text random -variable cmap -value random -command colormap -font $def_font
   

    pack $color.gray $color.ct $color.hot $color.cold $color.hls $color.rgb $color.spectrum $color.invert $color.rand  -side top  -anchor w -in $color
    pack $color -side right -anchor ne -in $pal
   
    set loval $curr_min
    set lothres [frame $pal.f2]
    label $lothres.lothrestext -text "low threshold" -font $def_font
    scale $lothres.lothres -from $curr_min -to $curr_max -orient horizontal \
        -variable loval -length 8c -resolution $thres_res 
    pack $lothres.lothrestext $lothres.lothres -side left -expand 1 -fill x -in $lothres
    pack $lothres -side top

    set hival $curr_max
    set hithres [frame $pal.f3]
    label $hithres.hithrestext -text "high threshold" -font $def_font
    scale $hithres.hithres -from $curr_min -to $curr_max -orient horizontal \
        -variable hival -length 8c -resolution  $thres_res 
    pack $hithres.hithrestext $hithres.hithres -side left -expand 1 -fill x -in $hithres
    pack $hithres -side top
  
    set diffthresval [expr $curr_max-$curr_min]
    set midthresval [expr $curr_min+($diffthresval/2)]

    set midthres [frame $pal.f4]
    label $midthres.midthrestext -text "mean threshold" -font $def_font
    scale $midthres.midthres -from $curr_min -to $curr_max -orient horizontal \
        -variable midthresval -length 8c -resolution $thres_res 
    pack $midthres.midthrestext $midthres.midthres -side left -expand 1 -fill x -in $midthres
    pack $midthres -side top

    set diffthres [frame $pal.f5]
    label $diffthres.diffthrestext -text "threshold range" -font $def_font
    scale $diffthres.diffthres -from 0.0 -to [expr $curr_max-$curr_min] -orient horizontal \
        -variable diffthresval -length 8c -resolution $thres_res 
    pack $diffthres.diffthrestext $diffthres.diffthres -side left -expand 1 -fill x -in $diffthres
    pack $diffthres -side top

    set bframe [frame $pal.f6]
    set cbar [button $pal.colorbar -text Colorbar -command "colorbar" -font $def_font]
    set rset [button $pal.rsetpal  -text "Reset Colortool" -command "reset_lut" -font $def_font]
    set rapply [button $pal.rapplypal  -text "Reset Threshold" -command "colormap" -font $def_font]

    set cwid 100
    set clen 100
    set sframe [frame $pal.sf -width $cwid -height $clen -relief sunken -borderwidth 4]
    set coledit [canvas $sframe.c -width $cwid -height $clen]
    pack $coledit -side left -in $sframe  -expand 1 -fill both
    pack $sframe $rset $rapply $cbar -side left -expand 1 -in $bframe
    pack $bframe -side left -fill x -expand 1 -anchor se 


    mknode p1 [expr $cwid/3] [expr $clen*2/3]
    mknode p2 [expr $cwid*2/3] [expr $clen/3]
    mkedges 

    $coledit bind node <B1-Motion> {
	set p [$coledit find withtag current]
	if { ((%x > 0) &&(%x < $cwid))
	&& ((%y > 0) && (%y < $clen )) } {
	    mvnode $p %x %y 
	}
    }

    bind $diffthres.diffthres <B1-Motion> {
	if { ![info exists curr_img] } {
	    return
	}
	set loval [expr $midthresval-$diffthresval/2]
	set hival [expr $midthresval+$diffthresval/2]
	$curr_img threshold $loval $hival
    }

    bind $midthres.midthres <B1-Motion> {
	if { ![info exists curr_img] } {
	    return
	}
	set loval [expr $midthresval-$diffthresval/2]
	set hival [expr $midthresval+$diffthresval/2]
	$curr_img threshold $loval $hival
    }

    bind $lothres.lothres <B1-Motion> {
	if { ![info exists curr_img] } {
	    return
	}
	if { $loval >= $hival } {
	    set loval [expr $hival -$thres_incr]
	}
	set midthresval [expr ($loval+$hival)/2]
	set diffthresval [expr $hival-$loval]
	$curr_img threshold $loval $hival
    }
    bind $hithres.hithres <B1-Motion> {
	if { ![info exists curr_img] } {
	    return
	}
	if { $loval >= $hival } {
	    set hival [expr $loval+$thres_incr]
	}
	set midthresval [expr ($loval+$hival)/2]
	set diffthresval [expr $hival-$loval]
	$curr_img threshold $loval $hival
    }
	
    bind $lothres.lothres <ButtonRelease-1> {
	if { ![info exists curr_img] } {
	    return
	}
	if { $loval >= $hival } {
	    set loval [expr $hival -$thres_incr]
	}
	set midthresval [expr ($loval+$hival)/2]
	set diffthresval [expr $hival-$loval]
	$curr_img threshold $loval $hival
    }
    bind $hithres.hithres <ButtonRelease-1> {
	if { ![info exists curr_img] } {
	    return
	}
	if { $loval >= $hival } {
	    set hival [expr $loval+$thres_incr]
	}
	set midthresval [expr ($loval+$hival)/2]
	set diffthresval [expr $hival-$loval]
	$curr_img threshold $loval $hival
    }
    bind $midthres.midthres <ButtonRelease-1> {
	if { ![info exists curr_img] } {
	    return
	}
	if { $loval == $curr_min } {
	    set midthresval [expr $curr_min+$diffthresval/2]
	    set hival [expr $curr_min+$diffthresval]
	} elseif { $hival == $curr_max } {
	    set midthresval [expr $curr_max-$diffthresval/2]
	    set loval [expr $curr_max-$diffthresval]
	}
	$curr_img threshold $loval $hival
    }
    bind $diffthres.diffthres <ButtonRelease-1> {
	if { ![info exists curr_img] } {
	    return
	}
	if { $loval == $curr_min } {
	    set diffthresval [expr ($midthresval-$curr_min)*2]
	    set hival [expr $curr_min+$diffthresval]
	} elseif { $hival == $curr_max } {
	    set diffthresval [expr ($curr_max-$midthresval)*2]
	    set loval [expr $curr_max-$diffthresval]
	}
	$curr_img threshold $loval $hival
    }

    bind $pal <Destroy> {
	if { $palette_button == 1 } {
	    #puts "leaving palette"
	    .palette configure -state normal
	    bind .pal <Destroy> {}
	}
    }
}

proc normalize {{a {0}} {b {0}}} {
    global curr_img DispMax DispMin userDispMin userDispMax

    if { [info exists curr_img] } {
	set userDispMin $a
	set userDispMax $b
	$curr_img range $a $b
	set DispMin [$curr_img getmin]
	set DispMax [$curr_img getmax]
    }
}

proc colormap {} {
    global curr_img p1 p2 cx cy cwid clen cmap 

    if { ![info exists curr_img] } {
	return
    }
    $curr_img cmap_stretch [expr $cx($p1)/double($cwid)] \
	    [expr ($clen-$cy($p1))/double($clen)] \
	    [expr $cx($p2)/double($cwid)] \
	    [expr ($clen-$cy($p2))/double($clen)] 
    $curr_img colormap $cmap
}

proc reset_lut {} {
    global coledit curr_img p1 p2 edge1 edge2 edge3 cx cy cwid clen 

    $coledit move $p1 [expr $cwid/3-$cx($p1)] [expr $clen*2/3 -$cy($p1)]
    set cx($p1) [expr $cwid/3]
    set cy($p1) [expr $clen*2/3]
    $coledit coords $edge1 0 $clen $cx($p1) $cy($p1)
    $coledit coords $edge2 $cx($p1) $cy($p1) $cx($p2) $cy($p2) 
    $coledit move $p2  [expr $cwid*2/3-$cx($p2)] [expr $clen/3 -$cy($p2)]
    set cx($p2) [expr $cwid*2/3]
    set cy($p2)  [expr $clen/3]
    $coledit coords $edge2 $cx($p1) $cy($p1) $cx($p2) $cy($p2) 
    $coledit coords $edge3 $cx($p2) $cy($p2) $cwid 0
    colormap 
}

proc image_open value {
    global img_nb curr_img
    
    if { $value == 1 } {
	incr img_nb
	set file [fileselect ]
	if { $file != {} } {
	    rdfile $file img$img_nb
	    disp img$img_nb
	}
    } else {
	if { ![ info exists curr_img] } {
	    return
	}
	set file [fileselect ]
	if { $file != {} } {
	    rdfile $file curr_img
	    disp curr_img
	}
    }
}

proc copy { src dest args } {
    upvar $src src1
    upvar $dest dest1
    global scale_slice wid len win_array curr_img filename_array curr_filename nb_slices_array \
nb_slices curr_nb_slices curr_slice_array seq_array sbwidth

    if { [info exists src1] } {
	if { ![info exists dest1] } {
	    set dest1 [image create pict]
	}
	eval {$dest1 copy $src1} $args
	set slice_nb 0
	set scale_slice 
	set filename_array($dest1) "copy"
	set curr_filename "copy"
	set nb_slices_array($dest1) $nb_slices
	set seq_array($dest1) 0
	set curr_slice_array($dest1) 0
	set curr_nb_slices $nb_slices
	set wid [image width $dest1]
	set len [image height $dest1]
	set curr_img $dest1
	if { [ info exists win_array($dest1)] } {
	    $win_array($dest1).c configure -width $wid -height $len 
	    $win_array($dest1).c configure -scrollregion "0 0 $wid $len" -confine 1
	    wm maxsize $win_array($dest1) $wid $len
	    wm geometry $win_array($dest1) [format "%dx%d" $wid $len]
	    set sbwidth [winfo reqwidth $win_array($dest1).yscroll]
	    topConfig $win_array($dest1) $wid $len
	}
    } else {
	puts "source image $src1 does not exist"
    }
}

proc get_min_max {} {
    global curr_img curr_min curr_max thres_res thres_incr
    
    if { [info exists curr_img] } {
	set max [$curr_img getmax]
	set min [$curr_img getmin]
	set t [format "%.1g" [expr ($max-$min)/200.0]] 
	set div [expr $max/$t]
	set h [expr ceil($div)]
	set curr_max [expr $t*$h]
	set div [expr $min/$t]
	set h [expr floor($div)]
	set curr_min [expr $t*$h]
	set thres_res $t
	set thres_incr $t
    }
}

proc update_scale {} {
    global curr_min curr_max thres_res pal_window palette_button
    
    if { ($palette_button == 1) && ([string compare [.palette cget -state] "disabled"]==0) } {
	set old_min $curr_min
	set old_max $curr_max
	
	set x [.pal.f2.lothres get]
	set x1 [lindex [.pal.f2.lothres coords $curr_min] 0]
	set x2 [lindex [.pal.f2.lothres coords $curr_max] 0]
	
	set y [.pal.f3.hithres get]
	set z [.pal.f4.midthres get]
	set t [.pal.f5.diffthres get]
	
	get_min_max
	
	set fac [expr ($curr_max-$curr_min)/($old_max-$old_min)]
	.pal.f2.lothres config -from $curr_min -to $curr_max -resolution $thres_res
	.pal.f2.lothres set [expr ($x-$old_min)*$fac+$curr_min]
	
	.pal.f3.hithres config -from $curr_min -to $curr_max -resolution $thres_res
	.pal.f3.hithres set [expr ($y-$old_min)*$fac+$curr_min]
	
	.pal.f4.midthres config -from $curr_min -to $curr_max -resolution $thres_res
	.pal.f4.midthres set [expr ($z-$old_min)*$fac+$curr_min]
	
	.pal.f5.diffthres config -from 0.0 -to [expr $curr_max-$curr_min] -resolution $thres_res
	.pal.f5.diffthres  set [expr $t*$fac]
    } else {
	get_min_max
    }
}




