/*
 * tkPictImgFmtRAW.c --
 *
 * A Pict image file handler for VIEW files. 
 * At present there is no write function. 
 *
 * Copyright (c) 1995 The Regents of the University of California.
 *
 * Author: Pierre-Louis Bossart
 * Date: November 17, 1995
 *
 * Derived from tkImgFmtPPM.c in the tk4.0b2 distribution 
 * copyrighted as follows:
 * Copyright (c) 1995 Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

#include "tkpict.h"

/*
 *----------------------------------------------------------------------
 *
 * FileReadRAW --
 *
 *	This procedure is called by the Pict image type to read
 *	RAW format data from a file and write it into a given
 *	Pict image.
 *
 * Results:
 *	A standard TCL completion code.  If TCL_ERROR is returned
 *	then an error message is left in interp->result.
 *
 * Side effects:
 *	The access position in file f is changed, and new data is
 *	added to the image given by imageHandle.
 *
 *----------------------------------------------------------------------
 */

int
FileReadRAW(Tcl_Interp *interp, FILE *f,char *filename,
		       Tk_PictHandle imageHandle,int width,int height,
		       int type,int datasize,int skip)
/*   Tcl_Interp *interp;	 Interpreter to use for reporting errors. 
     FILE *f;			 The image file, open for reading. 
     char *fileName;		 The name of the image file. 
     Tk_PictHandle imageHandle;	 The Pict image to write into. 
     int width, height;		 Dimensions of block of Pict image to
				   be written to. 
     int type, datasize;         type and datasize of the RAW file 
     int skip;                   number of bytes to skip from header */
{
    int nBytes, count;
    unsigned char *pixelPtr;
    Tk_PictImageBlock block;
    
    printf(" wid %d len %d type %d skip %d slice_nb %d\n",
	   width,height,type,skip,slice_nb);

    if ((width <= 0) || (height <= 0)) {
	return TCL_OK;
    }

    block.datatype = type;
    block.pixelSize = datasize;
    block.width = width;
    block.height = height;
    block.pitch = width;
   
    Tk_PictExpand(imageHandle,width,height);
 
    /* goto the correct slice */
    fseek(f, (long)(skip + datasize*slice_nb*width*height), SEEK_SET); 
   
    nBytes = height*block.pitch*block.pixelSize;
    
    pixelPtr = (unsigned char *) ckalloc((unsigned) nBytes);
    if(pixelPtr == NULL) {
      (void)fprintf(stderr,"FileReadRAW: Could not allocate memory\n");
      return;
    }

    block.pixelPtr = pixelPtr;
    block.copy = NO_COPY; 
    
    count = fread(pixelPtr, 1, (unsigned) nBytes, f);
    if (count != nBytes) {
      Tcl_AppendResult(interp, "error reading RAW image file \"",
		       filename, "\": ",
		       feof(f) ? "not enough data" : Tcl_PosixError(interp),
		       (char *) NULL);
      ckfree((char *) pixelPtr);
      return TCL_ERROR;
    }
    
    Tk_PictPutBlock(imageHandle, &block,0,0, width, height);
    
    /* free data if necessary */
    if( block.copy == COPY )
      free((void*)pixelPtr);
    
    return TCL_OK;
  }









