/* 
 * visu.c --
 *
 *     custom version of the Tcl_AppInit procedure for
 *	use in visu
 *
 * Copyright (c) 1995 The Regents of the University of California.
 *
 * Author: Pierre-Louis Bossart
 * Date: November 17, 1995
 *
 * derived from Tcl_AppInit.c in the  tk4.0b2 distribution copyrighted
 * as follows :
 * Copyright (c) 1993 The Regents of the University of California.
 * Copyright (c) 1994 Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

#include "tkpict.h"

/*
 * The following variable is a special hack that is needed in order for
 * Sun shared libraries to be used for Tcl.
 */

extern int matherr();
int *tclDummyMathPtr = (int *) matherr;


/* globals linked with tcl variables */
int Private_Colormap = 0;
int slice_nb = 0;
int nb_slices = 1;

/*
 *----------------------------------------------------------------------
 *
 * main --
 *
 *	This is the main program for the application.
 *
 * Results:
 *	None: Tk_Main never returns here, so this procedure never
 *	returns either.
 *
 * Side effects:
 *	Whatever the application does.
 *
 *----------------------------------------------------------------------
 */

int
main(argc, argv)
    int argc;			/* Number of command-line arguments. */
    char **argv;		/* Values of command-line arguments. */
{
  Tk_Main(argc, argv, Tcl_AppInit);
  return 0;			/* Needed only to prevent compiler warning. */
}

/*
 *----------------------------------------------------------------------
 *
 * Tcl_AppInit --
 *
 *	This procedure performs application-specific initialization.
 *	Most applications, especially those that incorporate additional
 *	packages, will have their own version of this procedure.
 *
 * Results:
 *	Returns a standard Tcl completion code, and leaves an error
 *	message in interp->result if an error occurs.
 *
 * Side effects:
 *	Depends on the startup script.
 *
 *----------------------------------------------------------------------
 */

int
Tcl_AppInit(interp)
    Tcl_Interp *interp;		/* Interpreter for application. */
{
    Tk_Window main;
    char *visu_env;
    char temp[1000];

    if (Tcl_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
    if (Tk_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }

    /*
     * Call the init procedures for included packages.  Each call should
     * look like this:
     *
     * if (Mod_Init(interp) == TCL_ERROR) {
     *     return TCL_ERROR;
     * }
     *
     * where "Mod" is the name of the module.
     */

    /*
     * Call Tcl_CreateCommand for application-specific commands, if
     * they weren't already created by the init procedures called above.
     */

    Tk_CreateImageType(&tkPictImageType);
   
    /* least current files first */
    Tk_CreatePictImageFormat(&tkImgFmtGIF);
    Tk_CreatePictImageFormat(&tkImgFmtPPM);
    Tk_CreatePictImageFormat(&tkImgFmtVIFF);
    Tk_CreatePictImageFormat(&tkImgFmtVIEW);

    Tcl_LinkVar(interp,"slice_nb",(char*)&slice_nb,TCL_LINK_INT);
    Tcl_LinkVar(interp,"nb_slices",(char*)&nb_slices,TCL_LINK_INT);
    Tcl_LinkVar(interp,"Private_Colormap",(char*)&Private_Colormap,TCL_LINK_INT);
    Tcl_LinkVar(interp,"has_nde_segment",(char*)&has_nde_segment,TCL_LINK_INT);
    
    /*
     * Specify a user-specific startup file to invoke if the application
     * is run interactively.  Typically the startup file is "~/.apprc"
     * where "app" is the name of the application.  If this line is deleted
     * then no user-specific startup file will be run under any conditions.
     */

    visu_env = (char*)getenv("VISU_ENV");
    if( visu_env == NULL )
      printf("Could not find defaults; set VISU_ENV variable\n");
    else
      {
	strcpy(temp,visu_env);
	strcat(temp,"/library/visu/visu.tcl"); 
	tcl_RcFileName = temp; 
      }
    
    return TCL_OK;
}
