'\"
'\" Copyright (c) 1989-1993 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /usr/cvs/NEOSOFT/inet_workstation/tcl7.3/tcl7.3/doc/Async.3,v 2.0 1994/12/23 20:10:35 karl Exp $ SPRITE (Berkeley)
'\" 
.\" The definitions below are for supplemental macros used in Tcl/Tk
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'\"	# Heading for Tcl/Tk man pages
.de HS
.ds ^3 \\0
.if !"\\$3"" .ds ^3 \\$3
.if '\\$2'cmds'       .TH \\$1 1 \\*(^3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\*(^3 \\$4
.if '\\$2'tcl'        .TH \\$1 n \\*(^3 Tcl "Tcl Built-In Commands"
.if '\\$2'tk'         .TH \\$1 n \\*(^3 Tk "Tk Commands"
.if '\\$2'tclc'        .TH \\$1 3 \\*(^3 Tcl "Tcl Library Procedures"
.if '\\$2'tkc'         .TH \\$1 3 \\*(^3 Tk "Tk Library Procedures"
.if '\\$2'tclcmds'         .TH \\$1 1 \\*(^3 Tk "Tcl Applications"
.if '\\$2'tkcmds'         .TH \\$1 1 \\*(^3 Tk "Tk Applications"
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS Tcl_AsyncCreate tclc 7.0
.BS
.SH NAME
Tcl_AsyncCreate, Tcl_AsyncMark, Tcl_AsyncInvoke, Tcl_AsyncDelete \- handle asynchronous events
.SH SYNOPSIS
.nf
\fB#include <tcl.h>\fR
.sp
extern int \fBtcl_AsyncReady\fR;
.sp
Tcl_AsyncHandler
\fBTcl_AsyncCreate\fR(\fIproc, clientData\fR)
.sp
\fBTcl_AsyncMark\fR(\fIasync\fR)
.sp
int
\fBTcl_AsyncInvoke\fR(\fIinterp, code\fR)
.sp
\fBTcl_AsyncDelete\fR(\fIasync\fR)
.SH ARGUMENTS
.AS Tcl_AsyncHandler clientData
.AP Tcl_AsyncProc *proc in
Procedure to invoke to handle an asynchronous event.
.AP ClientData clientData in
One-word value to pass to \fIproc\fR.
.AP Tcl_AsyncHandler async in
Token for asynchronous event handler.
.AP Tcl_Interp *interp in
Tcl interpreter in which command was being evaluated when handler was
invoked, or NULL if handler was invoked when there was no interpreter
active.
.AP int code in
Completion code from command that just completed in \fIinterp\fR,
or 0 if \fIinterp\fR is NULL.
.BE

.SH DESCRIPTION
.PP
These procedures provide a safe mechanism for dealing with
asynchronous events such as signals.
If an event such as a signal occurs while a Tcl script is being
evaluated then it isn't safe to take any substantive action to
process the event.
For example, it isn't safe to evaluate a Tcl script since the
intepreter may already be in the middle of evaluating a script;
it may not even be safe to allocate memory, since a memory
allocation could have been in progress when the event occurred.
The only safe approach is to set a flag indicating that the event
occurred, then handle the event later when the world has returned
to a clean state, such as after the current Tcl command completes.
.PP
\fBTcl_AsyncCreate\fR creates an asynchronous handler and returns
a token for it.
The asynchronous handler must be created before
any occurrences of the asynchronous event that it is intended
to handle (it is not safe to create a handler at the time of
an event).
When an asynchronous event occurs the code that detects the event
(such as a signal handler) should call \fBTcl_AsyncMark\fR with the
token for the handler.
\fBTcl_AsyncMark\fR will mark the handler as ready to execute, but it
will not invoke the handler immediately.
Tcl will call the \fIproc\fR associated with the handler later, when
the world is in a safe state, and \fIproc\fR can then carry out
the actions associated with the asynchronous event.
\fIProc\fR should have arguments and result that match the
type \fBTcl_AsyncProc\fR:
.nf
.RS
typedef int Tcl_AsyncProc(
.RS
ClientData \fIclientData\fR,
Tcl_Interp *\fIinterp\fR,
int \fIcode\fR);
.RE
.RE
.fi
The \fIclientData\fR will be the same as the \fIclientData\fR
argument passed to \fBTcl_AsyncCreate\fR when the handler was
created.
If \fIproc\fR is invoked just after a command has completed
execution in an interpreter, then \fIinterp\fR will identify
the interpreter in which the command was evaluated and
\fIcode\fR will be the completion code returned by that
command.
The command's result will be present in \fIinterp->result\fR.
When \fIproc\fR returns, whatever it leaves in \fIinterp->result\fR
will be returned as the result of the command and the integer
value returned by \fIproc\fR will be used as the new completion
code for the command.
.PP
It is also possible for \fIproc\fR to be invoked when no interpreter
is active.
This can happen, for example, if an asynchronous event occurs while
the application is waiting for interactive input or an X event.
In this case \fIinterp\fR will be NULL and \fIcode\fR will be
0, and the return value from \fIproc\fR will be ignored.
.PP
The procedure \fBTcl_AsyncInvoke\fR is called to invoke all of the
handlers that are ready.
The global variable \fBtcl_AsyncReady\fR will be non-zero whenever any
asynchronous handlers are ready;  it can be checked to avoid calls
to \fBTcl_AsyncInvoke\fR when there are no ready handlers.
Tcl checks \fBtcl_AsyncReady\fR after each command is evaluated
and calls \fBTcl_AsyncInvoke\fR if needed.
Applications may also call \fBTcl_AsyncInvoke\fR at interesting
times for that application.
For example, Tk's event handler checks \fBtcl_AsyncReady\fR
after each event and calls \fBTcl_AsyncInvoke\fR if needed.
The \fIinterp\fR and \fIcode\fR arguments to \fBTcl_AsyncInvoke\fR
have the same meaning as for \fIproc\fR:  they identify the active
intepreter, if any, and the completion code from the command
that just completed.
.PP
\fBTcl_AsyncDelete\fR removes an asynchronous handler so that
its \fIproc\fR will never be invoked again.
A handler can be deleted even when ready, and it will still
not be invoked.
.PP
If multiple handlers become active at the same time, the
handlers are invoked in the order they were created (oldest
handler first).
The \fIcode\fR and \fIinterp->result\fR for later handlers
reflect the values returned by earlier handlers, so that
the most recently created handler has last say about
the interpreter's result and completion code.
If new handlers become ready while handlers are executing,
\fBTcl_AsyncInvoke\fR will invoke them all;  at each point it
invokes the highest-priority (oldest) ready handler, repeating
this over and over until there are no longer any ready handlers.

.SH WARNING
.PP
It is almost always a bad idea for an asynchronous event
handler to modify \fIinterp->result\fR or return a code different
from its \fIcode\fR argument.
This sort of behavior can disrupt the execution of scripts in
subtle ways and result in bugs that are extremely difficult
to track down.
If an asynchronous event handler needs to evaluate Tcl scripts
then it should first save \fIinterp->result\fR plus the values
of the variables \fBerrorInfo\fR and \fBerrorCode\fR (this can
be done, for example, by storing them in dynamic strings).
When the asynchronous handler is finished it should restore
\fIinterp->result\fR, \fBerrorInfo\fR, and \fBerrorCode\fR,
and return the \fIcode\fR argument.

.SH KEYWORDS
asynchronous event, handler, signal
