/* 
 * strerror.c --
 *
 *	Source code for the "strerror" library routine.
 *
 * Copyright (c) 1991-1993 The Regents of the University of California.
 * Copyright (c) 1994 Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

#ifndef lint
static char sccsid[] = "@(#) strerror.c 1.10 94/12/17 16:26:21";
#endif /* not lint */

#include "tclInt.h"
#include "tclPort.h"

extern int sys_nerr;
extern char *sys_errlist[];
/*
 *----------------------------------------------------------------------
 *
 * strerror --
 *
 *	Map an integer error number into a printable string.
 *
 * Results:
 *	The return value is a pointer to a string describing
 *	error.  The first character of string isn't capitalized.
 *
 * Side effects:
 *	Each call to this procedure may overwrite the value returned
 *	by the previous call.
 *
 *----------------------------------------------------------------------
 */

char *
strerror(error)
    int error;			/* Integer identifying error (must be
				 * one of the officially-defined Sprite
				 * errors, as defined in errno.h). */
{
    static char msg[50];

#ifndef NO_SYS_ERRLIST
    if ((error <= sys_nerr) && (error > 0)) {
	return sys_errlist[error];
    }
#else
    switch (error) {
#ifdef E2BIG
	case E2BIG: return "Argument list too long";
#endif
#ifdef EACCES
	case EACCES: return "Permission denied";
#endif
#ifdef EADDRINUSE
	case EADDRINUSE: return "Address already in use";
#endif
#ifdef EADDRNOTAVAIL
	case EADDRNOTAVAIL: return "Can't assign requested address";
#endif
#ifdef EADV
	case EADV: return "Advertise error";
#endif
#ifdef EAFNOSUPPORT
	case EAFNOSUPPORT: return "Address family not supported by protocol family";
#endif
#ifdef EAGAIN
	case EAGAIN: return "No more processes";
#endif
#ifdef EALIGN
	case EALIGN: return "EALIGN";
#endif
#ifdef EALREADY
	case EALREADY: return "Operation already in progress";
#endif
#ifdef EBADE
	case EBADE: return "Bad exchange descriptor";
#endif
#ifdef EBADF
	case EBADF: return "Bad file number";
#endif
#ifdef EBADFD
	case EBADFD: return "File descriptor in bad state";
#endif
#ifdef EBADMSG
	case EBADMSG: return "Not a data message";
#endif
#ifdef EBADR
	case EBADR: return "Bad request descriptor";
#endif
#ifdef EBADRPC
	case EBADRPC: return "RPC structure is bad";
#endif
#ifdef EBADRQC
	case EBADRQC: return "Bad request code";
#endif
#ifdef EBADSLT
	case EBADSLT: return "Invalid slot";
#endif
#ifdef EBFONT
	case EBFONT: return "Bad font file format";
#endif
#ifdef EBUSY
	case EBUSY: return "Mount device busy";
#endif
#ifdef ECHILD
	case ECHILD: return "No children";
#endif
#ifdef ECHRNG
	case ECHRNG: return "Channel number out of range";
#endif
#ifdef ECOMM
	case ECOMM: return "Communication error on send";
#endif
#ifdef ECONNABORTED
	case ECONNABORTED: return "Software caused connection abort";
#endif
#ifdef ECONNREFUSED
	case ECONNREFUSED: return "Connection refused";
#endif
#ifdef ECONNRESET
	case ECONNRESET: return "Connection reset by peer";
#endif
#if defined(EDEADLK) && (!defined(EWOULDBLOCK) || (EDEADLK != EWOULDBLOCK))
	case EDEADLK: return "Resource deadlock avoided";
#endif
#ifdef EDEADLOCK
	case EDEADLOCK: return "Resource deadlock avoided";
#endif
#ifdef EDESTADDRREQ
	case EDESTADDRREQ: return "Destination address required";
#endif
#ifdef EDIRTY
	case EDIRTY: return "Mounting a dirty fs w/o force";
#endif
#ifdef EDOM
	case EDOM: return "Math argument out of range";
#endif
#ifdef EDOTDOT
	case EDOTDOT: return "Cross mount point";
#endif
#ifdef EDQUOT
	case EDQUOT: return "Disk quota exceeded";
#endif
#ifdef EDUPPKG
	case EDUPPKG: return "Duplicate package name";
#endif
#ifdef EEXIST
	case EEXIST: return "File already exists";
#endif
#ifdef EFAULT
	case EFAULT: return "Bad address in system call argument";
#endif
#ifdef EFBIG
	case EFBIG: return "File too large";
#endif
#ifdef EHOSTDOWN
	case EHOSTDOWN: return "Host is down";
#endif
#ifdef EHOSTUNREACH
	case EHOSTUNREACH: return "Host is unreachable";
#endif
#ifdef EIDRM
	case EIDRM: return "Identifier removed";
#endif
#ifdef EINIT
	case EINIT: return "Initialization error";
#endif
#ifdef EINPROGRESS
	case EINPROGRESS: return "Operation now in progress";
#endif
#ifdef EINTR
	case EINTR: return "Interrupted system call";
#endif
#ifdef EINVAL
	case EINVAL: return "Invalid argument";
#endif
#ifdef EIO
	case EIO: return "I/O error";
#endif
#ifdef EISCONN
	case EISCONN: return "Socket is already connected";
#endif
#ifdef EISDIR
	case EISDIR: return "Illegal operation on a directory";
#endif
#ifdef EISNAME
	case EISNAM: return "Is a name file";
#endif
#ifdef ELBIN
	case ELBIN: return "ELBIN";
#endif
#ifdef EL2HLT
	case EL2HLT: return "Level 2 halted";
#endif
#ifdef EL2NSYNC
	case EL2NSYNC: return "Level 2 not synchronized";
#endif
#ifdef EL3HLT
	case EL3HLT: return "Level 3 halted";
#endif
#ifdef EL3RST
	case EL3RST: return "Level 3 reset";
#endif
#ifdef ELIBACC
	case ELIBACC: return "Can not access a needed shared library";
#endif
#ifdef ELIBBAD
	case ELIBBAD: return "Accessing a corrupted shared library";
#endif
#ifdef ELIBEXEC
	case ELIBEXEC: return "Can not exec a shared library directly";
#endif
#ifdef ELIBMAX
	case ELIBMAX: return
		"Attempting to link in more shared libraries than system limit";
#endif
#ifdef ELIBSCN
	case ELIBSCN: return ".lib section in a.out corrupted";
#endif
#ifdef ELNRNG
	case ELNRNG: return "Link number out of range";
#endif
#ifdef ELOOP
	case ELOOP: return "Too many levels of symbolic links";
#endif
#ifdef EMFILE
	case EMFILE: return "Too many open files";
#endif
#ifdef EMLINK
	case EMLINK: return "Too many links";
#endif
#ifdef EMSGSIZE
	case EMSGSIZE: return "Message too long";
#endif
#ifdef EMULTIHOP
	case EMULTIHOP: return "Multihop attempted";
#endif
#ifdef ENAMETOOLONG
	case ENAMETOOLONG: return "File name too long";
#endif
#ifdef ENAVAIL
	case ENAVAIL: return "Not available";
#endif
#ifdef ENET
	case ENET: return "ENET";
#endif
#ifdef ENETDOWN
	case ENETDOWN: return "Network is down";
#endif
#ifdef ENETRESET
	case ENETRESET: return "Network dropped connection on reset";
#endif
#ifdef ENETUNREACH
	case ENETUNREACH: return "Network is unreachable";
#endif
#ifdef ENFILE
	case ENFILE: return "File table overflow";
#endif
#ifdef ENOANO
	case ENOANO: return "Anode table overflow";
#endif
#if defined(ENOBUFS) && (!defined(ENOSR) || (ENOBUFS != ENOSR))
	case ENOBUFS: return "No buffer space available";
#endif
#ifdef ENOCSI
	case ENOCSI: return "No CSI structure available";
#endif
#ifdef ENODATA
	case ENODATA: return "No data available";
#endif
#ifdef ENODEV
	case ENODEV: return "No such device";
#endif
#ifdef ENOENT
	case ENOENT: return "No such file or directory";
#endif
#ifdef ENOEXEC
	case ENOEXEC: return "Exec format error";
#endif
#ifdef ENOLCK
	case ENOLCK: return "No locks available";
#endif
#ifdef ENOLINK
	case ENOLINK: return "Link has be severed";
#endif
#ifdef ENOMEM
	case ENOMEM: return "Not enough memory";
#endif
#ifdef ENOMSG
	case ENOMSG: return "No message of desired type";
#endif
#ifdef ENONET
	case ENONET: return "Machine is not on the network";
#endif
#ifdef ENOPKG
	case ENOPKG: return "Package not installed";
#endif
#ifdef ENOPROTOOPT
	case ENOPROTOOPT: return "Bad proocol option";
#endif
#ifdef ENOSPC
	case ENOSPC: return "No space left on device";
#endif
#ifdef ENOSR
	case ENOSR: return "Out of stream resources";
#endif
#ifdef ENOSTR
	case ENOSTR: return "Not a stream device";
#endif
#ifdef ENOSYM
	case ENOSYM: return "Unresolved symbol name";
#endif
#ifdef ENOSYS
	case ENOSYS: return "Function not implemented";
#endif
#ifdef ENOTBLK
	case ENOTBLK: return "Block device required";
#endif
#ifdef ENOTCONN
	case ENOTCONN: return "Socket is not connected";
#endif
#ifdef ENOTDIR
	case ENOTDIR: return "Not a directory";
#endif
#ifdef ENOTEMPTY
	case ENOTEMPTY: return "Directory not empty";
#endif
#ifdef ENOTNAM
	case ENOTNAM: return "Not a name file";
#endif
#ifdef ENOTSOCK
	case ENOTSOCK: return "Socket operation on non-socket";
#endif
#ifdef ENOTTY
	case ENOTTY: return "Inappropriate device for ioctl";
#endif
#ifdef ENOTUNIQ
	case ENOTUNIQ: return "Name not unique on network";
#endif
#ifdef ENXIO
	case ENXIO: return "No such device or address";
#endif
#ifdef EOPNOTSUPP
	case EOPNOTSUPP: return "Operation not supported on socket";
#endif
#ifdef EPERM
	case EPERM: return "Not owner";
#endif
#ifdef EPFNOSUPPORT
	case EPFNOSUPPORT: return "Protocol family not supported";
#endif
#ifdef EPIPE
	case EPIPE: return "Broken pipe";
#endif
#ifdef EPROCLIM
	case EPROCLIM: return "Too many processes";
#endif
#ifdef EPROCUNAVAIL
	case EPROCUNAVAIL: return "Bad procedure for program";
#endif
#ifdef EPROGMISMATCH
	case EPROGMISMATCH: return "Program version wrong";
#endif
#ifdef EPROGUNAVAIL
	case EPROGUNAVAIL: return "RPC program not available";
#endif
#ifdef EPROTO
	case EPROTO: return "Protocol error";
#endif
#ifdef EPROTONOSUPPORT
	case EPROTONOSUPPORT: return "Protocol not suppored";
#endif
#ifdef EPROTOTYPE
	case EPROTOTYPE: return "Protocol wrong type for socket";
#endif
#ifdef ERANGE
	case ERANGE: return "Math result unrepresentable";
#endif
#if defined(EREFUSED) && (!defined(ECONNREFUSED) || (EREFUSED != ECONNREFUSED))
	case EREFUSED: return "EREFUSED";
#endif
#ifdef EREMCHG
	case EREMCHG: return "Remote address changed";
#endif
#ifdef EREMDEV
	case EREMDEV: return "Remote device";
#endif
#ifdef EREMOTE
	case EREMOTE: return "Pathname hit remote file system";
#endif
#ifdef EREMOTEIO
	case EREMOTEIO: return "Remote i/o error";
#endif
#ifdef EREMOTERELEASE
	case EREMOTERELEASE: return "EREMOTERELEASE";
#endif
#ifdef EROFS
	case EROFS: return "Read-only file system";
#endif
#ifdef ERPCMISMATCH
	case ERPCMISMATCH: return "RPC version is wrong";
#endif
#ifdef ERREMOTE
	case ERREMOTE: return "Object is remote";
#endif
#ifdef ESHUTDOWN
	case ESHUTDOWN: return "Can't send afer socket shutdown";
#endif
#ifdef ESOCKTNOSUPPORT
	case ESOCKTNOSUPPORT: return "Socket type not supported";
#endif
#ifdef ESPIPE
	case ESPIPE: return "Invalid seek";
#endif
#ifdef ESRCH
	case ESRCH: return "No such process";
#endif
#ifdef ESRMNT
	case ESRMNT: return "Srmount error";
#endif
#ifdef ESTALE
	case ESTALE: return "Stale remote file handle";
#endif
#ifdef ESUCCESS
	case ESUCCESS: return "Error 0";
#endif
#ifdef ETIME
	case ETIME: return "Timer expired";
#endif
#ifdef ETIMEDOUT
	case ETIMEDOUT: return "Connection timed out";
#endif
#ifdef ETOOMANYREFS
	case ETOOMANYREFS: return "Too many references: can't splice";
#endif
#ifdef ETXTBSY
	case ETXTBSY: return "Text file or pseudo-device busy";
#endif
#ifdef EUCLEAN
	case EUCLEAN: return "Structure needs cleaning";
#endif
#ifdef EUNATCH
	case EUNATCH: return "Protocol driver not attached";
#endif
#ifdef EUSERS
	case EUSERS: return "Too many users";
#endif
#ifdef EVERSION
	case EVERSION: return "Version mismatch";
#endif
#if defined(EWOULDBLOCK) && (!defined(EAGAIN) || (EWOULDBLOCK != EAGAIN))
	case EWOULDBLOCK: return "Operation would block";
#endif
#ifdef EXDEV
	case EXDEV: return "Cross-domain link";
#endif
#ifdef EXFULL
	case EXFULL: return "Message tables full";
#endif
    }
#endif /* ! NO_SYS_ERRLIST */
    sprintf(msg, "Unknown error (%d)", error);
    return msg;
}
