/*
 * tkAppInit.c --
 *
 *	Provides a default version of the Tcl_AppInit procedure for
 *	use in wish and similar Tk-based applications.
 *
 * Copyright (c) 1993 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * Copyright (c) 1995 The Regents of CORNELL UNIVERSITY.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice and the following
 * two paragraphs appear in all copies of this software.
 *
 * IN NO EVENT SHALL CORNELL UNIVERSITY BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF CORNELL
 * UNIVERSITY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * CORNELL UNIVERSITY SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, CORNELL UNIVERSITY HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
*/

#ifdef _WINDOWS
#  include "windows.h"
#endif
#include <tcl.h>
#include <tk.h>
#include "dpInt.h"

static int hasWindows = 1;

#ifndef _WINDOWS
/*
 * The following variable is a special hack that is needed in order for
 * Sun shared libraries to be used for Tcl.
 */

extern int matherr();
int *tclDummyMathPtr = (int *) matherr;

/*
 *----------------------------------------------------------------------
 *
 * main --
 *
 *	This is the main program for the application.
 *
 * Results:
 *	None: Tk_Main never returns here, so this procedure never
 *	returns either.
 *
 * Side effects:
 *	Whatever the application does.
 *
 *----------------------------------------------------------------------
 */
int
main(argc, argv)
    int argc;			/* Number of command-line arguments. */
    char **argv;		/* Values of command-line arguments. */
{
    char *execName;
    int i;

    /*
     * If executable is called "dptcl" assume -notk
     */
    execName = strrchr(argv[0], '/');
    if (execName != NULL) {
	execName++;
    } else {
	execName = argv[0];
    }
    if (strncmp(execName, "dptcl", 5) == 0) {
	hasWindows = 0;
    }

    for (i=1; i<argc; i++) {
	if (strcmp (argv[i], "-notk") == 0) {
	    hasWindows = 0;
	} else if (strcmp (argv[i], "-bg") == 0) {
	    hasWindows = 0;
	}
    }

#ifdef NO_X11
    Dp_Main(argc, argv, Tcl_AppInit);
#else
    if (hasWindows) {
	Tk_Main(argc, argv, Tcl_AppInit);
    } else {
	Dp_Main(argc, argv, Tcl_AppInit);
	/* Tcl_Main(argc, argv, Tcl_AppInit); */
    }
#endif
    return 0;			/* Needed only to prevent compiler warning. */
}
#else
#ifndef WIN32S
int
main(argc, argv)
    int argc;			/* Number of command-line arguments. */
    char **argv;		/* Values of command-line arguments. */
{
    common_wish(argc, argv, 1, 1, "Tcl-DP Wish", 1, Tcl_AppInit);
    return 0;			/* Needed only to prevent compiler warning. */
}
#else
int APIENTRY
WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lll, int nCmdShow)
{
    extern int __argc;
    extern char **__argv;

    common_wish(__argc, __argv, 1, 1, "Tcl-DP Wish", 0, Tcl_AppInit);
    return 0;			/* Needed only to prevent compiler warning. */
}
#endif /* ifndef WIN32 .. else .. */
#endif /* ifdef _WINDOWS .. else .. */
/*
 *----------------------------------------------------------------------
 *
 * Tcl_AppInit --
 *
 *	This procedure performs application-specific initialization.
 *	Most applications, especially those that incorporate additional
 *	packages, will have their own version of this procedure.
 *
 * Results:
 *	Returns a standard Tcl completion code, and leaves an error
 *	message in interp->result if an error occurs.
 *
 * Side effects:
 *	Depends on the startup script.
 *
 *----------------------------------------------------------------------
 */

int
Tcl_AppInit(interp)
    Tcl_Interp *interp;		/* Interpreter for application. */
{

    /*
     * Call the init procedures for included packages.  Each call should look
     * like this:
     * 
     * if (Mod_Init(interp) == TCL_ERROR) {
     *     return TCL_ERROR;
     * }
     * 
     * where "Mod" is the name of the module.
     */
    if (Tcl_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
#ifndef NO_X11
    if (hasWindows) {
	if (Tk_Init(interp) == TCL_ERROR) {
	    return TCL_ERROR;
	}
	Tcl_StaticPackage(interp, "Tk", Tk_Init, (Tcl_PackageInitProc *) NULL);
    }
#endif

    /*
     * Call Tcl_CreateCommand for application-specific commands, if they
     * weren't already created by the init procedures called above.
     */
    if (Dp_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
    Tcl_StaticPackage(interp, "Dp", Tdp_Init, (Tcl_PackageInitProc *) NULL);

    /*
     * Specify a user-specific startup file to invoke if the application is
     * run interactively.  Typically the startup file is "~/.apprc" where
     * "app" is the name of the application.  If this line is deleted then no
     * user-specific startup file will be run under any conditions.
     */
    Tcl_SetVar(interp, "tcl_rcFileName", "~/.dpwishrc", TCL_GLOBAL_ONLY);
    return TCL_OK;
}
