'\"
'\" canvasprintdialog (c) 1995 Mark L. Ulferts
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) canvasprintdialog.n 1.21 94/12/17 16:04:44
'/" 
.so man.macros
.HS canvasprintdialog iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
canvasprintdialog \- Create and manipulate a canvas print dialog widget
.SH SYNOPSIS
\fBcanvasprintdialog\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Toplevel <- Dialogshell <- Dialog <- Canvasprintdialog
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBactiveBackground\fR	\fBbackground\fR	\fBborderWidth\fR	\fBcursor\fR
\fBforeground\fR	\fBhighlightBackground\fR	\fBhighlightColor\fR	\fBhighlightThickness\fR
\fBinsertBackground\fR	\fBinsertBorderWidth\fR	\fBinsertOffTime\fR	\fBinsertOnTime\fR
\fBinsertWidth\fR	\fBrelief\fR	\fBrepeatDelay\fR	\fBrepeatInterval\fR
\fBselectBackground\fR	\fBselectBorderWidth\fR	\fBselectForeground\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "ASSOCIATED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBfilename\fR	\fBhpagecnt\fR	\fBorient\fR	\fBoutput\fR
\fBpagesize\fR	\fBposterize\fR	\fBprintcmd\fR	\fBprintregion\fR
\fBvpagecnt\fR
.fi
.LP
See the "canvasprintbox" widget manual entry for details on the above
associated options.

.SH "INHERITED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbuttonBoxPadX\fR	\fBbuttonBoxPadY\fR	\fBbuttonBoxPos\fR	\fBpadX\fR
\fBpadY\fR	\fBseparator\fR	\fBthickness\fR
.fi
.LP
See the "dialogshell" widget manual entry for details on the above
inherited options.
.LP
.nf
.ta 4c 8c 12c
\fBmaster\fR	\fBmodality\fR	\fBtitle\fR
.fi
.LP
See the "shell" widget manual entry for details on the above
inherited options.
.LP
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.BE

.SH DESCRIPTION
.PP
The \fBcanvasprintdialog\fR command creates a print dialog for printing
the contents of a canvas widget to a printer or a file. It is possible
to specify page orientation, the number of pages to print the image on
and if the output should be stretched to fit the page.

.SH "METHODS"
.PP
The \fBcanvasprintdialog\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for canvasprintdialog widgets:
.SH "ASSOCIATED METHODS"
.LP
.nf
.ta 4c 8c 12c
\fBgetoutput\fR	\fBsetcanvas\fR	\fBrefresh\fR	\fBprint\fR
.fi
.LP
See the "canvasprintbox" class manual entry for details on the 
associated methods.
.SH "INHERITED METHODS"
.LP
.nf
.ta 4c 8c 12c
\fBadd\fR	\fBbuttonconfigure\fR	\fBdefault\fR	\fBhide\fR
\fBinsert\fR	\fBinvoke\fR	\fBshow\fR	
.fi
.LP
See the "buttonbox" widget manual entry for details on the above
inherited methods.
.LP
.nf
.ta 4c 8c 12c
\fBactivate\fR	\fBdeactivate\fR
.fi
.LP
See the "dialogshell" widget manual entry for details on the above
inherited methods.

.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by 
the \fBcanvasprintdialog\fR command.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by 
the \fBcanvasprintdialog\fR
command.

.SH "COMPONENTS"
.LP
.nf
Name:	\fBcpb\fR
Class:	\fBCanvasprintbox\fR
.fi
.IP
The cpb component is the canvas print box for the canvas print dialog.
See the "canvasprintbox" widget manual entry for details on the cpb
component item.
.fi

.SH EXAMPLE
.DS
 option add *textBackground white

 canvasprintdialog .cpb 
 .cpb activate
.DE
.SH AUTHOR
Tako Schotanus
.LP
Tako.Schotanus@bouw.tno.nl
.SH KEYWORDS
canvasprintdialog, canvasprintbox, dialog, widget
