'\"
'\" Copyright (c) 1996 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) scrolledhtml.n 1.21 94/12/17 16:04:44
'/" 
.so man.macros
.HS scrolledhtml iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
scrolledhtml \- Create and manipulate a scrolled text widget with the capability
of displaying HTML formatted documents.
.SH SYNOPSIS
\fBscrolledhtml\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Widget <- Labeledwidget <- Scrolledtext <- Scrolledhtml
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBactiveBackground\fR	\fBbackground\fR	\fBborderWidth\fR	\fBcursor\fR
\fBexportSelection\fR	\fBforeground\fR	\fBhighlightColor\fR	\fBhighlightThickness\fR
\fBinsertBackground\fR	\fBinsertBorderWidth\fR	\fBinsertOffTime\fR	\fBinsertOnTime\fR
\fBinsertWidth\fR	\fBpadX\fR	\fBpadY\fR	\fBrelief\fR
\fBrepeatDelay\fR	\fBrepeatInterval\fR	\fBselectBackground\fR	\fBselectBorderWidth\fR
\fBselectForeground\fR	\fBsetGrid\fR 
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "ASSOCIATED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBactiveRelief\fR	\fBelementBorderWidth\fR	\fBjump\fR	\fBtroughColor\fR
.fi
.LP
See the "scrollbar" widget manual entry for details on the above
associated options.
.LP
.nf
.ta 4c 8c 12c
\fBspacing1\fR	\fBspacing2\fR	\fBspacing3\fR	\fBstate\fR
\fBwrap\fR
.fi
.LP
See the "text" widget manual entry for details on the above
associated options.
.SH "INHERITED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBlabelBitmap\fR	\fBlabelFont\fR	\fBlabelImage\fR	\fBlabelMargin\fR
\fBlabelPos\fR	\fBlabelText\fR	\fBlabelVariable\fR 		\fBheight\fR
\fBhscrollMode\fR	\fBsbWidth\fR	\fBscrollMargin\fR	\fBvisibleitems\fR
\fBvscrollMode\fR	\fBwidth\fR
.fi
.LP
See the "scrolledtext" class manual entry for details on the inherited options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBfeedback\fR
Class:	\fBFeedBack\fR
Command-Line Switch:	\fB-feedback\fR
.fi
.IP
Specifies the callback command to use to give feedback on current
status. The command is executed in the form \fIcommand\fR \fI<number of 
characters remaining>\fR
.LP
.nf
Name:	\fBfixedfont\fR
Class:	\fBFixedFont\fR
Command-Line Switch:	\fB-fixedfont\fR
.fi
.IP
Specifies the name of the font to be used for fixed-width character
text (such as <pre>...</pre> or <tt>...</tt>.) The size, style, and 
other font attributes are determined by the format tags in the 
document. The default is courier.
.LP
.nf
Name:	\fBfontname\fR
Class:	\fBFontName\fR
Command-Line Switch:	\fB-fontname\fR
.fi
.IP
Specifies the name of the font to be used for normal-width character 
spaced text. The size, style, and other font attributes are 
determined by the format tags in the document. The default is times.
.LP
.nf
Name:	\fBfontsize\fR
Class:	\fBFontSize\fR
Command-Line Switch:	\fB-fontsize\fR
.fi
.IP
Specifies the general size of the fonts used. One of small, medium,
large, or huge. The default is medium.
.LP
.nf
Name:	\fBforeground\fR
Class:	\fBForeground\fR
Command-Line Switch:	\fB-foreground\fR
.fi
.IP
Specifies the color of text other than hypertext links, in any 
of the forms acceptable to \fBTk_GetColor\fR. This value may
be overridden in a particular document by the \fItext\fR attribute 
of the \fBBody\fR HTML tag.
.LP
.nf
Name:	\fBlink\fR
Class:	\fBLink\fR
Command-Line Switch:	\fB-link\fR
.fi
.IP
Specifies the default color of hypertext links in any of the forms
acceptable to \fBTk_GetColor\fR. This value may be overridden in a
particular document by the \fIlink\fR attribute of the \fBBody\fR 
HTML tag. The default is blue.
.LP
.nf
Name:	\fBlinkcommand\fR
Class:	\fBLinkCommand\fR
Command-Line Switch:	\fB-linkcommand\fR
.fi
.IP
Specifies the command to execute when the user clicks on a hypertext
link. Execution is of the form \fBlinkcommand href\fR, where \fBhref\fR is
the value given in the \fIhref\fR attribute of the \fBA\fR HTML tag.
.LP
.nf
Name:	\fBlinkhighlight\fR
Class:	\fBLinkHighlight\fR
Command-Line Switch:	\fB-linkhighlight\fR
.fi
.IP
Specifies the color of hypertext links when the cursor is over the link
in any of the forms acceptable to \fBTk_GetColor\fR. The default is red.
.LP
.nf
Name:	\fBtextBackground\fR
Class:	\fBBackground\fR
Command-Line Switch:	\fB-textbackground\fR
.fi
.IP
Specifies the background color for the text area in any of 
the forms acceptable to \fBTk_GetColor\fR. This value may be 
overridden in a particular document by the \fIbgcolor\fR attribute 
of the \fBBody\fR HTML tag.
.LP
.nf
Name:	\fBunknownimage\fR
Class:	\fBUnknownImage\fR
Command-Line Switch:	\fB-unknownimage\fR
.fi
.IP
Specifies the name of the image file to display when an \fBimg\fR
specified in the html document cannot be loaded.
.LP
.BE

.SH DESCRIPTION
.PP
The \fBscrolledhtml\fR command creates 
a scrolled text widget with the additional capability to display
html formatted documents.
An import method is provided to read an html document file, and
a render method is provided to display a html formatted text string.

.SH "METHODS"
.PP
The \fBscrolledhtml\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for scrolledhtml widgets:
.SH "ASSOCIATED METHODS"
.LP
.nf
.ta 4c 8c 12c
\fBbbox\fR	\fBcompare\fR	\fBdebug\fR	\fBdelete\fR	
\fBdlineinfo\fR	\fBget\fR	\fBindex\fR	\fBinsert\fR
\fBmark\fR	\fBscan\fR	\fBsearch\fR	\fBsee\fR
\fBtag\fR	\fBwindow\fR	\fBxview\fR	\fByview\fR
.fi
.LP
See the "text" manual entry for details on the standard methods.
.SH "INHERITED METHODS"
.LP
.nf
.ta 4c 8c 12c
\fBexport\fR	\fBclear\fR
.fi
.LP
See the "scrolledhtml" manual entry for details on the inherited methods.

.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBscrolledhtml\fR
command.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBscrolledhtml\fR
command.
.TP
\fIpathName\fR \fBimport\fR ?\fIoption\fR? \fIhref\fR
Load html formatted text from a file.  \fIHref\fR must exist.
If \fIoption\fR is -link, \fIhref\fR is assumed to be relative
to the application's current working directory. Otherwise, 
\fIhref\fR is assumed to be relative to the path of the last
page loaded. \fIHref\fR is either a filename, or a reference
of the form \fIfilename\fR#\fIanchorname\fR. In the latter form,
fIFilename\fR and/or \fIanchorname\fR may be empty. 
If \fIfilename\fR is empty, the current document is assumed. 
If \fIanchorname\fR is empty, the top of the document is assumed.
.TP
\fIpathName\fR \fBpwd\fR
Print the current working directory of the widget, i.e. the directory of the
last page loaded.
.TP
\fIpathName\fR \fBrender\fR \fIhtmltext\fR ?\fIwd\fR?
Display HTML formatted text \fIhtmltext\fR. \fIWd\fR gives the base
path to use for all links and images in the document. \fIWd\fR defaults
to the application's current working directory.
.TP
\fIpathName\fR \fBtitle\fR
Return the title of the current page, as given in the <title>...</title>
field in the document.

.SH "SUPPORTED HTML TAGS"
.LP
.nf
.ta 4c 8c 12c
\fBa\fR	\fB/code\fR	\fBh5\fR	\fB/samp\fR
\fB/a\fR	\fBdir\fR	\fB/h5\fR	\fBsmall\fR
\fBaddress\fR	\fB/dir\fR	\fBh6\fR	\fB/small\fR
\fB/address\fR	\fBdl\fR	\fB/h6\fR	\fBsub\fR
\fBb\fR	\fB/dl\fR	\fBi\fR	\fB/sub\fR
\fB/b\fR	\fBdt\fR	\fB/i\fR	\fBsup\fR
\fBbase\fR	\fBdd\fR	\fBimg\fR	\fB/sup\fR
\fBbig\fR	\fBdfn\fR	\fBkbd\fR	\fBstrong\fR
\fB/big\fR	\fB/dfn\fR	\fBli\fR	\fB/strong\fR
\fBblockquote\fR	\fBem\fR	\fBlisting\fR	\fBtitle\fR
\fB/blockquote\fR	\fB/em\fR	\fB/listing\fR	\fB/title\fR
\fBbody\fR	\fBh1\fR	\fBmenu\fR	\fBtt\fR
\fB/body\fR	\fB/h1\fR	\fB/menu\fR	\fB/tt\fR
\fBbr\fR	\fBh2\fR	\fBol\fR	\fBu\fR
\fBcenter\fR	\fB/h2\fR	\fB/ol\fR	\fB/u\fR
\fB/center\fR	\fBh3\fR	\fBp\fR	\fBul\fR
\fBcite\fR	\fB/h3\fR	\fBpre\fR	\fB/ul\fR
\fB/cite\fR	\fBh4\fR	\fB/pre\fR	\fBvar\fR
\fBcode\fR	\fB/h4\fR	\fBsamp\fR	\fB/var\fR
.fi
.SH "TAGS WITH ATTRIBUTES"
.TP
\fBa\fR
.RS
.TP
\fIhref\fR
reference to html document, of the form filename#anchorname
.TP
\fIname\fR
name of this anchor, to be used in an href
.TP
\fIid\fR
same as name
.RE
.TP
\fBbody\fR
.RS
.TP
\fIbgcolor\fR
background color
.TP
\fIlink\fR
color of hypertext links
.TP
\fItext\fR
color of text
.RE
.TP
\fBh\fIn\fR
.RS
.TP
\fIalign\fR
text alignment, one of \fBleft\fR, \fBright\fR, or \fBcenter\fR
.TP
\fIsrc\fR
path to image to precede text
.RE
.TP
\fBhr\fR
.RS
.TP
\fInoshade\fR
if present, indicates the rule should be a plain black line
.TP
\fIsize\fR
height of the rule, in pixels
.RE
.TP
\fBimg\fR
.RS
.TP
\fIalt\fR
text to display in place of image if image is not found
.TP
\fIheight\fR
height of area to reserve if image is not found
.TP
\fIsrc\fR
filename of image
.TP
\fIwidth\fR
width of area to reserve if image is not found
.RE
.TP
\fBp\fR
.RS
.TP
\fIalign\fR
alignment of following paragraph, one of \fBleft\fR, \fBright\fR,
or \fBcenter\fR. Defaults to alignment of previous paragraph, 
or \fBleft\fR for first paragraph
.TP
\fIid\fR
ID for use as anchorname in a link to this document
.RE
.TP
\fBul\fR
.RS
.TP
\fIplain\fR
if present list will not use bullets
.TP
\fIsrc\fR
image to use as bullet
.TP
\fIdingbat\fR
same as src
.RE
.SH EXAMPLE
.DS
 option add *textBackground white

 scrolledhtml .sh -fontname helvetica -linkcommand "this import -link"

 pack .sh -padx 10 -pady 10 -fill both -expand yes

 .sh import ~/public_html/index.html
.DE
.SH ACKNOWLEDGEMENTS
Sam Shen
.IP
This code is based largely on his tkhtml.tcl code from tk inspect. Tkhtml
is copyright 1995 Lawrence Berkeley Laboratory.
.LP
.SH AUTHOR
Kris Raney
.SH KEYWORDS
scrolledhtml, html, text, widget
