#@package: neowindow center_window

package require Tk

#
# Copyright (C) 1992-1996 NeoSoft.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies.  NeoSoft makes no 
# representations about the suitability of this software for any purpose.
# It is provided "as is" without express or implied warranty.

#
# $Id: neowindow.tcl,v 1.2 1996/09/28 20:54:22 kunkee Exp $
#

#
# Miscellaneous window goodies
#
#

#
# Center a window on the screen
#
proc center_window {w} {
    # Center the window on the screen.

    wm withdraw $w
    update idletasks
    set x [expr [winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \
	    - [winfo vrootx $w]]
    set y [expr [winfo screenheight $w]/2 - [winfo reqheight $w]/2 \
	    - [winfo vrooty $w]]
    wm geom $w +$x+$y
    wm deiconify $w
}

