#@package: timedate-utility next_month_year days_in_month calculate_ratio_of_month_left day_month_calculations

#
# Copyright (C) 1992-1996 NeoSoft.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies.  NeoSoft makes no 
# representations about the suitability of this software for any purpose.
# It is provided "as is" without express or implied warranty.

#
# Time/Date utility functions
#
# $Id: timedate.tcl,v 1.2 1996/09/28 20:54:27 kunkee Exp $
#
#


#
# given the current month and year and the names of two variables,
# put in the first the numeric month following this one and in the
# second, the year of that month.
#
proc next_month_year {currentMonth currentYear nextMonthVar nextMonthYearVar} {
    upvar $nextMonthVar nextMonth
    upvar $nextMonthYearVar nextMonthYear

    set nextMonthYear $currentYear
    set nextMonth $currentMonth

    if {$nextMonth < 12} {
	incr nextMonth
    } else {
	set nextMonth 1
	incr nextMonthYear
    }
}

#
# How many days are in the specified month, in the specified year?
#
proc days_in_month {month year} {
    switch $month {
	1 {return 31}
	2 {
	    if {$year % 4 == 0} {
		return 29
	    } else {
		return 28
	    }
	}
	3 {return 31}
	4 {return 30}
	5 {return 31}
	6 {return 30}
	7 {return 31}
	8 {return 31}
	9 {return 30}
       10 {return 31}
       11 {return 30}
       12 {return 31}
    }
    error "month out of range ($month)"
}

#
# What is the floating point ratio of days left from the specified
# day, in the specified month, of the specified year?
#
proc calculate_ratio_of_month_left {month day year} {
    set daysInThisMonth [days_in_month $month $year]

    set daysLeftInThisMonth [expr $daysInThisMonth - $day + 1]
    return [expr $daysLeftInThisMonth.0/$daysInThisMonth]
}

#
# Given a integer-seconds-since-1970 and the names of some variables,
# return in those variables the month number (1-12), the year number,
# the days in the current month (28-31), the days left in this month,
# the ratio of days left in the month, the month number (1-12) of
# the month following this date's month, and the year number of the month
# following this date's month.
#
proc day_month_calculations {clock thisMonthVar thisYearVar daysInThisMonthVar 
                             daysLeftInThisMonthVar ratioLeftVar 
			     nextMonthMonthVar nextMonthYearVar} \
{
    upvar $thisMonthVar thismonth
    upvar $thisYearVar thisyear
    upvar $daysInThisMonthVar daysInThisMonth
    upvar $daysLeftInThisMonthVar daysLeftInThisMonth
    upvar $ratioLeftVar ratioLeft
    upvar $nextMonthMonthVar nextmonth
    upvar $nextMonthYearVar nextyear

    lassign [fmtclock $clock "%m %d %Y"] thismonth thisday thisyear
    scan $thismonth %d thismonth
    scan $thisday %d thisday

    next_month_year $thismonth $thisyear nextmonth nextyear
    set monthStartSeconds [convertclock $nextmonth/1/$nextyear]

    set daysInThisMonth [days_in_month $thismonth $thisyear]

    set daysLeftInThisMonth [expr $daysInThisMonth - $thisday + 1]
    set ratioLeft [expr $daysLeftInThisMonth.0/$daysInThisMonth]
}

