'\"
'\" Copyright (c) 1995 AT&T Bell Laboratories
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" $Id: import.n,v 1.1.1.1 1996/09/10 06:54:36 karl Exp $
'\" 
.so man.macros
.TH import n "" Tcl "Tcl With Namespaces"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
import \- change the "import" list for a namespace
.SH SYNOPSIS
\fBimport \fIoption\fR ?\fIarg arg ...\fR?
.BE

.SH DESCRIPTION
.PP
The \fBimport\fR command is used to query or modify the import
list for the current namespace context.  Command, variable and
namespace names are sought first in the current namespace context,
then in all imported namespaces.  This means that commands/variables
can be referenced in an imported namespace without the usual
namespace qualifiers.  When a namespace is added to the import
list, it acts as if it were a part of the namespace that imports
it.
.PP
By default, each namespace imports its parent.  This allows commands
and variables at the global scope to be accessed transparently in
child namespaces.  Frequently-used libraries can also be added to
the import list, but it is a good idea to import namespaces sparingly.
If each namespace imported all of the others, there would be very
little advantage to using namespaces.
.PP
By default, namespaces are imported in a "public" mode.  This means
that public commands/variables can be accessed transparently, but
protected and private elements remain hidden.  Namespaces can also
be imported in a "protected" mode.  This means that public \fIand\fR
protected commands/variables can be accessed transparently, but
private elements remain hidden.  There is no way to import in a
"private" mode, so private elements always remain hidden from
other namespaces.
.PP
The \fIoption\fR argument determines what action is carried out
by the command.  The legal \fIoptions\fR (which may be abbreviated)
are:
.TP
\fBimport add \fIname\fR ?\fIname...\fR? ?\fB-\fIwhere \fIpos...\fR?
Adds one or more namespace \fIname\fR references to the import
list in the current namespace context.  Each \fIname\fR reference
may be a namespace name, or a list with two elements:  the first
element is the namespace name, and the second is the import
protection level, either "public" or "protected".
.sp
.RS
The \fB-\fIwhere\fR flag can be used to specify where the list
of \fIname\fR's should be added in the existing import list:
.TP
\fB-after \fIpos\fR ?\fIpos...\fR?
Namespace \fIname\fR's are inserted after the position of namespace
\fIpos\fR on the list.  If more than one \fIpos\fR namespace is
specified, the \fIname\fR's are inserted after the \fIpos\fR
nearest the end of the list.
.TP
\fB-before \fIpos\fR ?\fIpos...\fR?
Namespace \fIname\fR's are inserted before the position of namespace
\fIpos\fR on the list.  If more than one \fIpos\fR namespace is
specified, the \fIname\fR's are inserted before the \fIpos\fR
nearest the start of the list.
.RE
.TP
\fBimport all \fR?\fIname\fR?
Returns the namespace search path used for command/variable resolution
in namespace \fIname\fR, or in the current namespace context if
\fIname\fR is not specified.  This is the list of namespaces found by
starting at the target namespace, and following its tree of import
references.  Each element on the return list is itself a list containing
a namespace name and its import protection level (public or protected).
.TP
\fBimport list \fR?\fIimportList\fR?
Returns the import list in the current namespace context.  Each
element on the return list is itself a list containing a namespace
name and its import protection level (public or protected).
If a new \fIimportList\fR is specified, then the import list is set
to this.  The elements of \fIimportList\fR can be simple namespace
names or two-element lists with a namespace name and its import
protection level.
.TP
\fBimport remove \fIname\fR ?\fIname...\fR?
Removes one or more namespace \fIname\fR's from the import list
in the current namespace context.  Each \fIname\fR reference
can be simple namespace name or a two-element list with a
namespace name and its import protection level.

.SH KEYWORDS
namespace, import, private, protected, public
