'\"
'\" Copyright (c) 1995 AT&T Bell Laboratories
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" $Id: protected.n,v 1.1.1.1 1996/09/10 06:54:36 karl Exp $
'\" 
.so man.macros
'\"	# CS - begin display of code example
.de CS
.in +0.4i
.nf
\fC
..
'\"	# CE - end display of code example
.de CE
\fP
.fi
.in -0.4i
..
.TH protected n "" Tcl "Tcl With Namespaces"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
protected \- create commands/variables with "protected" access
.SH SYNOPSIS
\fBprotected \fIcommand \fR?\fIarg arg ...\fR?
.BE

.SH DESCRIPTION
.PP
Sets the protection level for new commands/variables to "protected"
and then evaluates the remaining arguments.  Note that the default
protection level for commands/variables is "public".  Commands and
variables can also be "private".
.PP
The \fIcommand\fR argument may be a command name like \fBproc\fR
or \fBvariable\fR, or a script full of command/variable declarations.
Any command that creates another command or variable can be used
in conjunction with the \fBprotected\fR command.  For example, if widget
commands are executed via "protected", the widget access commands will
be protected.
.PP
Protected commands/variables are accessible in the namespace where
they are defined, and in any other namespace that imports the
defining namespace in a "protected" mode.  See the \fBimport\fR
command for details concerning the import list.

.SH EXAMPLE
.CS
namespace foo {
    protected {
        variable x 0
        variable y 1
    }
    protected proc check {} {
        global x y
        return "$x $y"
    }
}
import add {foo protected}
foo::check
.CE

.SH KEYWORDS
import, namespace, private, protected, public, variable, proc
