"proc bgerror err {\n\
    global errorInfo\n\
    set info $errorInfo\n\
\n\
    set err [split $err \\n]\n\
    if {[llength $err] > 5} {\n\
        set err [lrange $err 0 4]\n\
        lappend err \"...\"\n\
    }\n\
    set err [join $err \\n]\n\
\n\
    set button [tk_dialog .bgerrorDialog \"Error in Tcl Script\" \\\n\
	    \"Error: $err\" error 0 OK \"Skip Messages\" \"Stack Trace\"]\n\
    if {$button == 0} {\n\
	return\n\
    } elseif {$button == 1} {\n\
	return -code break\n\
    }\n\
\n\
    set w .bgerrorTrace\n\
    catch {destroy $w}\n\
    toplevel $w -class ErrorTrace\n\
    wm minsize $w 1 1\n\
    wm title $w \"Stack Trace for Error\"\n\
    wm iconname $w \"Stack Trace\"\n\
    button $w.ok -text OK -command \"destroy $w\"\n\
    text $w.text -relief sunken -bd 2 -yscrollcommand \"$w.scroll set\" \\\n\
	    -setgrid true -width 60 -height 20\n\
    scrollbar $w.scroll -relief sunken -command \"$w.text yview\"\n\
    pack $w.ok -side bottom -padx 3m -pady 2m\n\
    pack $w.scroll -side right -fill y\n\
    pack $w.text -side left -expand yes -fill both\n\
    $w.text insert 0.0 $info\n\
    $w.text mark set insert 0.0\n\
\n\
    # Center the window on the screen.\n\
\n\
    wm withdraw $w\n\
    update idletasks\n\
    set x [expr [winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \\\n\
	    - [winfo vrootx [winfo parent $w]]]\n\
    set y [expr [winfo screenheight $w]/2 - [winfo reqheight $w]/2 \\\n\
	    - [winfo vrooty [winfo parent $w]]]\n\
    wm geom $w +$x+$y\n\
    wm deiconify $w\n\
\n\
    # Be sure to release any grabs that might be present on the\n\
    # screen, since they could make it impossible for the user\n\
    # to interact with the stack trace.\n\
\n\
    if {[grab current .] != \"\"} {\n\
	grab release [grab current .]\n\
    }\n\
}",
