"proc tkConsoleInit {} {\n\
    global tcl_platform\n\
\n\
    if {$tcl_platform(platform) == \"macintosh\"} {\n\
	# Use the native scrollbar for the console\n\
	rename scrollbar \"\"\n\
	rename macscrollbar scrollbar\n\
    }\n\
    text .console  -yscrollcommand \".sb set\" -setgrid true\n\
    scrollbar .sb -command \".console yview\"\n\
    pack .sb -side right -fill both\n\
    pack .console -fill both -expand 1 -side left\n\
    if {$tcl_platform(platform) == \"macintosh\"} {\n\
        after idle {.console configure -font {Monaco 9 normal}}\n\
	.sb configure -bg white\n\
        .console configure -bg white -bd 0 -highlightthickness 0 \\\n\
	  -selectbackground black -selectforeground white \\\n\
	  -selectborderwidth 0 -insertwidth 1\n\
	.console tag configure sel -relief ridge\n\
	bind .console <FocusIn> {  .console tag configure sel -borderwidth 0\n\
	  .console configure -selectbackground black -selectforeground white }\n\
	bind .console <FocusOut> { .console tag configure sel -borderwidth 2\n\
	  .console configure -selectbackground white -selectforeground black }\n\
    }\n\
\n\
    tkConsoleBind .console\n\
\n\
    .console tag configure stderr -foreground red\n\
    .console tag configure stdin -foreground blue\n\
\n\
    focus .console\n\
    \n\
    wm protocol . WM_DELETE_WINDOW { wm withdraw . }\n\
    wm title . \"Console\"\n\
    flush stdout\n\
    .console mark set output [.console index \"end - 1 char\"]\n\
    tkTextSetCursor .console end\n\
    .console mark set promptEnd insert\n\
    .console mark gravity promptEnd left\n\
}",
"proc tkConsoleInvoke {args} {\n\
    set ranges [.console tag ranges input]\n\
    set cmd \"\"\n\
    if {$ranges != \"\"} {\n\
	set pos 0\n\
	while {[lindex $ranges $pos] != \"\"} {\n\
	    set start [lindex $ranges $pos]\n\
	    set end [lindex $ranges [incr pos]]\n\
	    append cmd [.console get $start $end]\n\
	    incr pos\n\
	}\n\
    }\n\
    if {$cmd == \"\"} {\n\
	tkConsolePrompt\n\
    } elseif [info complete $cmd] {\n\
	.console mark set output end\n\
	.console tag delete input\n\
	set result [interp record $cmd]\n\
	if {$result != \"\"} {\n\
	    .console insert insert \"$result\\n\"\n\
	}\n\
	tkConsoleHistory reset\n\
	tkConsolePrompt\n\
    } else {\n\
	tkConsolePrompt partial\n\
    }\n\
    .console yview -pickplace insert\n\
}",
"set histNum 1",
"proc tkConsoleHistory {cmd} {\n\
    global histNum\n\
    \n\
    switch $cmd {\n\
    	prev {\n\
	    incr histNum -1\n\
	    if {$histNum == 0} {\n\
		set cmd {history event [expr [history nextid] -1]}\n\
	    } else {\n\
		set cmd \"history event $histNum\"\n\
	    }\n\
    	    if {[catch {interp eval $cmd} cmd]} {\n\
    	    	incr histNum\n\
    	    	return\n\
    	    }\n\
	    .console delete promptEnd end\n\
    	    .console insert promptEnd $cmd {input stdin}\n\
    	}\n\
    	next {\n\
	    incr histNum\n\
	    if {$histNum == 0} {\n\
		set cmd {history event [expr [history nextid] -1]}\n\
	    } elseif {$histNum > 0} {\n\
		set cmd \"\"\n\
		set histNum 1\n\
	    } else {\n\
		set cmd \"history event $histNum\"\n\
	    }\n\
	    if {$cmd != \"\"} {\n\
		catch {interp eval $cmd} cmd\n\
	    }\n\
	    .console delete promptEnd end\n\
	    .console insert promptEnd $cmd {input stdin}\n\
    	}\n\
    	reset {\n\
    	    set histNum 1\n\
    	}\n\
    }\n\
}",
"proc tkConsolePrompt {{partial normal}} {\n\
    if {$partial == \"normal\"} {\n\
	set temp [.console index \"end - 1 char\"]\n\
	.console mark set output end\n\
    	if [interp eval \"info exists tcl_prompt1\"] {\n\
    	    interp eval \"eval \\[set tcl_prompt1\\]\"\n\
    	} else {\n\
    	    puts -nonewline \"% \"\n\
    	}\n\
    } else {\n\
	set temp [.console index output]\n\
	.console mark set output end\n\
    	if [interp eval \"info exists tcl_prompt2\"] {\n\
    	    interp eval \"eval \\[set tcl_prompt2\\]\"\n\
    	} else {\n\
	    puts -nonewline \"> \"\n\
    	}\n\
    }\n\
    flush stdout\n\
    .console mark set output $temp\n\
    tkTextSetCursor .console end\n\
    .console mark set promptEnd insert\n\
    .console mark gravity promptEnd left\n\
}",
"proc tkConsoleBind {win} {\n\
    bindtags $win \"$win Text . all\"\n\
\n\
    # Ignore all Alt, Meta, and Control keypresses unless explicitly bound.\n\
    # Otherwise, if a widget binding for one of these is defined, the\n\
    # <KeyPress> class binding will also fire and insert the character,\n\
    # which is wrong.  Ditto for <Escape>.\n\
\n\
    bind $win <Alt-KeyPress> {# nothing }\n\
    bind $win <Meta-KeyPress> {# nothing}\n\
    bind $win <Control-KeyPress> {# nothing}\n\
    bind $win <Escape> {# nothing}\n\
    bind $win <KP_Enter> {# nothing}\n\
\n\
    bind $win <Tab> {\n\
	tkConsoleInsert %W \\t\n\
	focus %W\n\
	break\n\
    }\n\
    bind $win <Return> {\n\
	%W mark set insert {end - 1c}\n\
	tkConsoleInsert %W \"\\n\"\n\
	tkConsoleInvoke\n\
	break\n\
    }\n\
    bind $win <Delete> {\n\
	if {[%W tag nextrange sel 1.0 end] != \"\"} {\n\
	    %W tag remove sel sel.first promptEnd\n\
	} else {\n\
	    if [%W compare insert < promptEnd] {\n\
		break\n\
	    }\n\
	}\n\
    }\n\
    bind $win <BackSpace> {\n\
	if {[%W tag nextrange sel 1.0 end] != \"\"} {\n\
	    %W tag remove sel sel.first promptEnd\n\
	} else {\n\
	    if [%W compare insert <= promptEnd] {\n\
		break\n\
	    }\n\
	}\n\
    }\n\
    foreach left {Control-a Home} {\n\
	bind $win <$left> {\n\
	    if [%W compare insert < promptEnd] {\n\
		tkTextSetCursor %W {insert linestart}\n\
	    } else {\n\
		tkTextSetCursor %W promptEnd\n\
            }\n\
	    break\n\
	}\n\
    }\n\
    foreach right {Control-e End} {\n\
	bind $win <$right> {\n\
	    tkTextSetCursor %W {insert lineend}\n\
	    break\n\
	}\n\
    }\n\
    bind $win <Control-d> {\n\
	if [%W compare insert < promptEnd] {\n\
	    break\n\
	}\n\
    }\n\
    bind $win <Control-k> {\n\
	if [%W compare insert < promptEnd] {\n\
	    %W mark set insert promptEnd\n\
	}\n\
    }\n\
    bind $win <Control-t> {\n\
	if [%W compare insert < promptEnd] {\n\
	    break\n\
	}\n\
    }\n\
    bind $win <Meta-d> {\n\
	if [%W compare insert < promptEnd] {\n\
	    break\n\
	}\n\
    }\n\
    bind $win <Meta-BackSpace> {\n\
	if [%W compare insert <= promptEnd] {\n\
	    break\n\
	}\n\
    }\n\
    bind $win <Control-h> {\n\
	if [%W compare insert <= promptEnd] {\n\
	    break\n\
	}\n\
    }\n\
    foreach prev {Control-p Up} {\n\
	bind $win <$prev> {\n\
	    tkConsoleHistory prev\n\
	    break\n\
	}\n\
    }\n\
    foreach prev {Control-n Down} {\n\
	bind $win <$prev> {\n\
	    tkConsoleHistory next\n\
	    break\n\
	}\n\
    }\n\
    bind $win <Control-v> {\n\
	if [%W compare insert > promptEnd] {\n\
	    catch {\n\
		%W insert insert [selection get -displayof %W] {input stdin}\n\
		%W see insert\n\
	    }\n\
	}\n\
	break\n\
    }\n\
    bind $win <Insert> {\n\
	catch {tkConsoleInsert %W [selection get -displayof %W]}\n\
	break\n\
    }\n\
    bind $win <KeyPress> {\n\
	tkConsoleInsert %W %A\n\
	break\n\
    }\n\
    foreach left {Control-b Left} {\n\
	bind $win <$left> {\n\
	    if [%W compare insert == promptEnd] {\n\
		break\n\
	    }\n\
	    tkTextSetCursor %W insert-1c\n\
	    break\n\
	}\n\
    }\n\
    foreach right {Control-f Right} {\n\
	bind $win <$right> {\n\
	    tkTextSetCursor %W insert+1c\n\
	    break\n\
	}\n\
    }\n\
    bind $win <F9> {\n\
	eval destroy [winfo child .]\n\
	source $tk_library/console.tcl\n\
    }\n\
    foreach copy {F16 Meta-w Control-i} {\n\
	bind $win <$copy> {\n\
	    if {[selection own -displayof %W] == \"%W\"} {\n\
		clipboard clear -displayof %W\n\
		catch {\n\
		    clipboard append -displayof %W [selection get -displayof %W]\n\
		}\n\
	    }\n\
	    break\n\
	}\n\
    }\n\
    foreach paste {F18 Control-y} {\n\
	bind $win <$paste> {\n\
	    catch {\n\
	        set clip [selection get -displayof %W -selection CLIPBOARD]\n\
		set list [split $clip \\n\\r]\n\
		tkConsoleInsert %W [lindex $list 0]\n\
		foreach x [lrange $list 1 end] {\n\
		    %W mark set insert {end - 1c}\n\
		    tkConsoleInsert %W \"\\n\"\n\
		    tkConsoleInvoke\n\
		    tkConsoleInsert %W $x\n\
		}\n\
	    }\n\
	    break\n\
	}\n\
    }\n\
}",
"proc tkConsoleInsert {w s} {\n\
    if {$s == \"\"} {\n\
	return\n\
    }\n\
    catch {\n\
	if {[$w compare sel.first <= insert]\n\
		&& [$w compare sel.last >= insert]} {\n\
	    $w tag remove sel sel.first promptEnd\n\
	    $w delete sel.first sel.last\n\
	}\n\
    }\n\
    if {[$w compare insert < promptEnd]} {\n\
	$w mark set insert end	\n\
    }\n\
    $w insert insert $s {input stdin}\n\
    $w see insert\n\
}",
"proc tkConsoleOutput {dest string} {\n\
    .console insert output $string $dest\n\
    .console see insert\n\
}",
"proc tkConsoleExit {} {\n\
    exit\n\
}",
"if {$tcl_platform(platform) != \"unix\"} {\n\
    tkConsoleInit\n\
}",
