"proc tk_setPalette args {\n\
    global tkPalette\n\
\n\
    # Create an array that has the complete new palette.  If some colors\n\
    # aren't specified, compute them from other colors that are specified.\n\
\n\
    if {[llength $args] == 1} {\n\
	set new(background) [lindex $args 0]\n\
    } else {\n\
	array set new $args\n\
    }\n\
    if ![info exists new(background)] {\n\
	error \"must specify a background color\"\n\
    }\n\
    if ![info exists new(foreground)] {\n\
	set new(foreground) black\n\
    }\n\
    set bg [winfo rgb . $new(background)]\n\
    set fg [winfo rgb . $new(foreground)]\n\
    set darkerBg [format #%02x%02x%02x [expr (9*[lindex $bg 0])/2560] \\\n\
	    [expr (9*[lindex $bg 1])/2560] [expr (9*[lindex $bg 2])/2560]]\n\
    foreach i {activeForeground insertBackground selectForeground \\\n\
	    highlightColor} {\n\
	if ![info exists new($i)] {\n\
	    set new($i) $new(foreground)\n\
	}\n\
    }\n\
    if ![info exists new(disabledForeground)] {\n\
	set new(disabledForeground) [format #%02x%02x%02x \\\n\
		[expr (3*[lindex $bg 0] + [lindex $fg 0])/1024] \\\n\
		[expr (3*[lindex $bg 1] + [lindex $fg 1])/1024] \\\n\
		[expr (3*[lindex $bg 2] + [lindex $fg 2])/1024]]\n\
    }\n\
    if ![info exists new(highlightBackground)] {\n\
	set new(highlightBackground) $new(background)\n\
    }\n\
    if ![info exists new(activeBackground)] {\n\
	# Pick a default active background that islighter than the\n\
	# normal background.  To do this, round each color component\n\
	# up by 15% or 1/3 of the way to full white, whichever is\n\
	# greater.\n\
\n\
	foreach i {0 1 2} {\n\
	    set light($i) [expr [lindex $bg $i]/256]\n\
	    set inc1 [expr ($light($i)*15)/100]\n\
	    set inc2 [expr (255-$light($i))/3]\n\
	    if {$inc1 > $inc2} {\n\
		incr light($i) $inc1\n\
	    } else {\n\
		incr light($i) $inc2\n\
	    }\n\
	    if {$light($i) > 255} {\n\
		set light($i) 255\n\
	    }\n\
	}\n\
	set new(activeBackground) [format #%02x%02x%02x $light(0) \\\n\
		$light(1) $light(2)]\n\
    }\n\
    if ![info exists new(selectBackground)] {\n\
	set new(selectBackground) $darkerBg\n\
    }\n\
    if ![info exists new(troughColor)] {\n\
	set new(troughColor) $darkerBg\n\
    }\n\
    if ![info exists new(selectColor)] {\n\
	set new(selectColor) #b03060\n\
    }\n\
\n\
    # Walk the widget hierarchy, recoloring all existing windows.\n\
    # Before doing this, make sure that the tkPalette variable holds\n\
    # the default values of all options, so that tkRecolorTree can\n\
    # be sure to only change options that have their default values.\n\
    # If the variable exists, then it is already correct (it was created\n\
    # the last time this procedure was invoked).  If the variable\n\
    # doesn't exist, fill it in using the defaults from a few widgets.\n\
\n\
    if ![info exists tkPalette] {\n\
	checkbutton .c14732\n\
	entry .e14732\n\
	scrollbar .s14732\n\
	set tkPalette(activeBackground) \\\n\
		[lindex [.c14732 configure -activebackground] 3]\n\
	set tkPalette(activeForeground) \\\n\
		[lindex [.c14732 configure -activeforeground] 3]\n\
	set tkPalette(background) \\\n\
		[lindex [.c14732 configure -background] 3]\n\
	set tkPalette(disabledForeground) \\\n\
		[lindex [.c14732 configure -disabledforeground] 3]\n\
	set tkPalette(foreground) \\\n\
		[lindex [.c14732 configure -foreground] 3]\n\
	set tkPalette(highlightBackground) \\\n\
		[lindex [.c14732 configure -highlightbackground] 3]\n\
	set tkPalette(highlightColor) \\\n\
		[lindex [.c14732 configure -highlightcolor] 3]\n\
	set tkPalette(insertBackground) \\\n\
		[lindex [.e14732 configure -insertbackground] 3]\n\
	set tkPalette(selectColor) \\\n\
		[lindex [.c14732 configure -selectcolor] 3]\n\
	set tkPalette(selectBackground) \\\n\
		[lindex [.e14732 configure -selectbackground] 3]\n\
	set tkPalette(selectForeground) \\\n\
		[lindex [.e14732 configure -selectforeground] 3]\n\
	set tkPalette(troughColor) \\\n\
		[lindex [.s14732 configure -troughcolor] 3]\n\
	destroy .c14732 .e14732 .s14732\n\
    }\n\
    tkRecolorTree . new\n\
\n\
    # Change the option database so that future windows will get the\n\
    # same colors.\n\
\n\
    foreach option [array names new] {\n\
	option add *$option $new($option) widgetDefault\n\
    }\n\
\n\
    # Save the options in the global variable tkPalette, for use the\n\
    # next time we change the options.\n\
\n\
    array set tkPalette [array get new]\n\
}",
"proc tkRecolorTree {w colors} {\n\
    global tkPalette\n\
    upvar $colors c\n\
    set q [winfo command $w]\n\
    foreach dbOption [array names c] {\n\
	set option -[string tolower $dbOption]\n\
	if ![catch {$q cget $option} value] {\n\
	    if {$value == $tkPalette($dbOption)} {\n\
		$q configure $option $c($dbOption)\n\
	    }\n\
	}\n\
    }\n\
    foreach child [winfo children $w] {\n\
	tkRecolorTree $child c\n\
    }\n\
}",
"proc tkDarken {color percent} {\n\
    set l [winfo rgb . $color]\n\
    set red [expr [lindex $l 0]/256]\n\
    set green [expr [lindex $l 1]/256]\n\
    set blue [expr [lindex $l 2]/256]\n\
    set red [expr ($red*$percent)/100]\n\
    if {$red > 255} {\n\
	set red 255\n\
    }\n\
    set green [expr ($green*$percent)/100]\n\
    if {$green > 255} {\n\
	set green 255\n\
    }\n\
    set blue [expr ($blue*$percent)/100]\n\
    if {$blue > 255} {\n\
	set blue 255\n\
    }\n\
    format #%02x%02x%02x $red $green $blue\n\
}",
"proc tk_bisque {} {\n\
    tk_setPalette activeBackground #e6ceb1 activeForeground black \\\n\
	    background #ffe4c4 disabledForeground #b0b0b0 foreground black \\\n\
	    highlightBackground #ffe4c4 highlightColor black \\\n\
	    insertBackground black selectColor #b03060 \\\n\
	    selectBackground #e6ceb1 selectForeground black \\\n\
	    troughColor #cdb79e\n\
}",
