"package require -exact Tk 4.1",
"package require -exact Tcl 7.5",
"if {($tk_library != \"\") &&([lsearch -exact $auto_path $tk_library] < 0)} {\n\
    lappend auto_path $tk_library\n\
}",
"set tk_strictMotif 0",
"proc tkScreenChanged screen {\n\
    set disp [file rootname $screen]\n\
    uplevel #0 upvar #0 tkPriv.$disp tkPriv\n\
    global tkPriv\n\
    if [info exists tkPriv] {\n\
	set tkPriv(screen) $screen\n\
	return\n\
    }\n\
    set tkPriv(afterId) {}\n\
    set tkPriv(buttons) 0\n\
    set tkPriv(buttonWindow) {}\n\
    set tkPriv(dragging) 0\n\
    set tkPriv(focus) {}\n\
    set tkPriv(grab) {}\n\
    set tkPriv(initPos) {}\n\
    set tkPriv(inMenubutton) {}\n\
    set tkPriv(listboxPrev) {}\n\
    set tkPriv(mouseMoved) 0\n\
    set tkPriv(oldGrab) {}\n\
    set tkPriv(popup) {}\n\
    set tkPriv(postedMb) {}\n\
    set tkPriv(pressX) 0\n\
    set tkPriv(pressY) 0\n\
    set tkPriv(screen) $screen\n\
    set tkPriv(selectMode) char\n\
    set tkPriv(window) {}\n\
}",
"if [info exists auto_namespace] {\n\
\n\
\n\
set auto_namespace(clipboard)	{tk {clear append}}\n\
set auto_namespace(grab)	{tk {current release set status}}\n\
set auto_namespace(grid)	{tk {bbox columnconfigure configure forget info\n\
				 location propagate rowconfigure size slaves}}\n\
set auto_namespace(image)	{tk {create delete height names type types\n\
				 width}}\n\
set auto_namespace(tkwait)	{tk {variable visibility window}}\n\
set auto_namespace(option)	{tk {add clear get readfile}}\n\
set auto_namespace(pack)	{tk {configure forget info propagate slaves}}\n\
set auto_namespace(place)	{tk {configure forget info slaves}}\n\
set auto_namespace(selection)	{tk {clear get handle own}}\n\
set auto_namespace(winfo)	{tk {atom atomname cells children class\n\
				 colormapfull containing depth exists fpixels\n\
				 geometry height id interps ismapped manager\n\
				 name parent pathname pixels pointerx pointerxy\n\
				 pointery reqheight reqwidth rgb rootx rooty\n\
				 screen screencells screendepth screenheight\n\
				 screenmmheight screenmmwidth screenvisual\n\
				 screenwidth server toplevel viewable visual\n\
				 visualid visualsavailable vrootheight\n\
				 vrootwidth vrootx vrooty width x y}}\n\
set auto_namespace(wm)		{tk {aspect client command deiconify focusmodel\n\
				 frame geometry grid group iconbitmap iconify\n\
				 iconmask iconname iconposition iconwindow\n\
				 maxsize minsize overrideredirect positionfrom\n\
				 protocol resizable sizefrom state title\n\
				 transient withdraw}}\n\
\n\
} elseif [string compare [info commands unknown_handler] {}] {\n\
\n\
namespace itcl {\n\
    public variable purist 0\n\
\n\
    public proc tk_unknown {args} {\n\
        global purist\n\
\n\
        set win [lindex $args 0]\n\
\n\
        if {[catch {winfo command $win} cmd] == 0 &&\n\
            $cmd != \"\" && !$purist} {\n\
            return [uplevel $cmd [lrange $args 1 end]]\n\
        }\n\
        return -code continue\n\
    }\n\
    unknown_handler \"tk\" itcl::tk_unknown\n\
}\n\
\n\
}",
"tkScreenChanged [winfo screen .]",
"bind Button <FocusIn> {}",
"bind Button <Enter> {\n\
    tkButtonEnter %W\n\
}",
"bind Button <Leave> {\n\
    tkButtonLeave %W\n\
}",
"bind Button <1> {\n\
    tkButtonDown %W\n\
}",
"bind Button <ButtonRelease-1> {\n\
    tkButtonUp %W\n\
}",
"bind Button <space> {\n\
    tkButtonInvoke %W\n\
}",
"bind Checkbutton <FocusIn> {}",
"bind Checkbutton <Enter> {\n\
    tkButtonEnter %W\n\
}",
"bind Checkbutton <Leave> {\n\
    tkButtonLeave %W\n\
}",
"bind Checkbutton <1> {\n\
    tkCheckRadioInvoke %W\n\
}",
"bind Checkbutton <space> {\n\
    tkCheckRadioInvoke %W\n\
}",
"bind Checkbutton <Return> {\n\
    if !$tk_strictMotif {\n\
	tkCheckRadioInvoke %W\n\
    }\n\
}",
"bind Radiobutton <FocusIn> {}",
"bind Radiobutton <Enter> {\n\
    tkButtonEnter %W\n\
}",
"bind Radiobutton <Leave> {\n\
    tkButtonLeave %W\n\
}",
"bind Radiobutton <1> {\n\
    tkCheckRadioInvoke %W\n\
}",
"bind Radiobutton <space> {\n\
    tkCheckRadioInvoke %W\n\
}",
"bind Radiobutton <Return> {\n\
    if !$tk_strictMotif {\n\
	tkCheckRadioInvoke %W\n\
    }\n\
}",
"proc tkButtonEnter {w} {\n\
    global tkPriv\n\
    set q [winfo command $w]\n\
    if {[$q cget -state] != \"disabled\"} {\n\
	$q config -state active\n\
	if {$tkPriv(buttonWindow) == $w} {\n\
	    $q configure -state active -relief sunken\n\
	}\n\
    }\n\
    set tkPriv(window) $w\n\
}",
"proc tkButtonLeave w {\n\
    global tkPriv\n\
    set q [winfo command $w]\n\
    if {[$q cget -state] != \"disabled\"} {\n\
	$q config -state normal\n\
    }\n\
    if {$w == $tkPriv(buttonWindow)} {\n\
	$q configure -relief $tkPriv(relief)\n\
    }\n\
    set tkPriv(window) \"\"\n\
}",
"proc tkButtonDown w {\n\
    global tkPriv\n\
    set q [winfo command $w]\n\
    set tkPriv(relief) [lindex [$q config -relief] 4]\n\
    if {[$q cget -state] != \"disabled\"} {\n\
	set tkPriv(buttonWindow) $w\n\
	$q config -relief sunken\n\
    }\n\
}",
"proc tkButtonUp w {\n\
    global tkPriv\n\
    set q [winfo command $w]\n\
    if {$w == $tkPriv(buttonWindow)} {\n\
	set tkPriv(buttonWindow) \"\"\n\
	$q config -relief $tkPriv(relief)\n\
	if {($w == $tkPriv(window))\n\
		&& ([$q cget -state] != \"disabled\")} {\n\
	    uplevel #0 [list $q invoke]\n\
	}\n\
    }\n\
}",
"proc tkButtonInvoke w {\n\
    set q [winfo command $w]\n\
    if {[$q cget -state] != \"disabled\"} {\n\
	set oldRelief [$q cget -relief]\n\
	set oldState [$q cget -state]\n\
	$q configure -state active -relief sunken\n\
	update idletasks\n\
	after 100\n\
	$q configure -state $oldState -relief $oldRelief\n\
	uplevel #0 [list $q invoke]\n\
    }\n\
}",
"proc tkCheckRadioInvoke w {\n\
    set q [winfo command $w]\n\
    if {[$q cget -state] != \"disabled\"} {\n\
	uplevel #0 [list $q invoke]\n\
    }\n\
}",
"proc tkEntryClipboardKeysyms {copy cut paste} {\n\
    bind Entry <$copy> {\n\
	if {[selection own -displayof %W] == \"%W\"} {\n\
	    clipboard clear -displayof %W\n\
	    catch {\n\
		clipboard append -displayof %W [selection get -displayof %W]\n\
	    }\n\
	}\n\
    }\n\
    bind Entry <$cut> {\n\
	if {[selection own -displayof %W] == \"%W\"} {\n\
	    clipboard clear -displayof %W\n\
	    catch {\n\
		clipboard append -displayof %W [selection get -displayof %W]\n\
		%q delete sel.first sel.last\n\
	    }\n\
	}\n\
    }\n\
    bind Entry <$paste> {\n\
	catch {\n\
	    %q insert insert [selection get -displayof %W \\\n\
		    -selection CLIPBOARD]\n\
	}\n\
    }\n\
}",
"bind Entry <1> {\n\
    tkEntryButton1 %W %x\n\
    %q selection clear\n\
}",
"bind Entry <B1-Motion> {\n\
    set tkPriv(x) %x\n\
    tkEntryMouseSelect %W %x\n\
}",
"bind Entry <Double-1> {\n\
    set tkPriv(selectMode) word\n\
    tkEntryMouseSelect %W %x\n\
    catch {%q icursor sel.first}\n\
}",
"bind Entry <Triple-1> {\n\
    set tkPriv(selectMode) line\n\
    tkEntryMouseSelect %W %x\n\
    %q icursor 0\n\
}",
"bind Entry <Shift-1> {\n\
    set tkPriv(selectMode) char\n\
    %q selection adjust @%x\n\
}",
"bind Entry <Double-Shift-1>	{\n\
    set tkPriv(selectMode) word\n\
    tkEntryMouseSelect %W %x\n\
}",
"bind Entry <Triple-Shift-1>	{\n\
    set tkPriv(selectMode) line\n\
    tkEntryMouseSelect %W %x\n\
}",
"bind Entry <B1-Leave> {\n\
    set tkPriv(x) %x\n\
    tkEntryAutoScan %W\n\
}",
"bind Entry <B1-Enter> {\n\
    tkCancelRepeat\n\
}",
"bind Entry <ButtonRelease-1> {\n\
    tkCancelRepeat\n\
}",
"bind Entry <Control-1> {\n\
    %q icursor @%x\n\
}",
"bind Entry <ButtonRelease-2> {\n\
    if {!$tkPriv(mouseMoved) || $tk_strictMotif} {\n\
	tkEntryPaste %W %x\n\
    }\n\
}",
"bind Entry <Left> {\n\
    tkEntrySetCursor %W [expr [%q index insert] - 1]\n\
}",
"bind Entry <Right> {\n\
    tkEntrySetCursor %W [expr [%q index insert] + 1]\n\
}",
"bind Entry <Shift-Left> {\n\
    tkEntryKeySelect %W [expr [%q index insert] - 1]\n\
    tkEntrySeeInsert %W\n\
}",
"bind Entry <Shift-Right> {\n\
    tkEntryKeySelect %W [expr [%q index insert] + 1]\n\
    tkEntrySeeInsert %W\n\
}",
"bind Entry <Control-Left> {\n\
    tkEntrySetCursor %W \\\n\
	    [string wordstart [%q get] [expr [%q index insert] - 1]]\n\
}",
"bind Entry <Control-Right> {\n\
    tkEntrySetCursor %W [string wordend [%q get] [%q index insert]]\n\
}",
"bind Entry <Shift-Control-Left> {\n\
    tkEntryKeySelect %W \\\n\
	    [string wordstart [%q get] [expr [%q index insert] - 1]]\n\
    tkEntrySeeInsert %W\n\
}",
"bind Entry <Shift-Control-Right> {\n\
    tkEntryKeySelect %W [string wordend [%q get] [%q index insert]]\n\
    tkEntrySeeInsert %W\n\
}",
"bind Entry <Home> {\n\
    tkEntrySetCursor %W 0\n\
}",
"bind Entry <Shift-Home> {\n\
    tkEntryKeySelect %W 0\n\
    tkEntrySeeInsert %W\n\
}",
"bind Entry <End> {\n\
    tkEntrySetCursor %W end\n\
}",
"bind Entry <Shift-End> {\n\
    tkEntryKeySelect %W end\n\
    tkEntrySeeInsert %W\n\
}",
"bind Entry <Delete> {\n\
    if [%q selection present] {\n\
	%q delete sel.first sel.last\n\
    } else {\n\
	%q delete insert\n\
    }\n\
}",
"bind Entry <BackSpace> {\n\
    tkEntryBackspace %W\n\
}",
"bind Entry <Control-space> {\n\
    %q selection from insert\n\
}",
"bind Entry <Select> {\n\
    %q selection from insert\n\
}",
"bind Entry <Control-Shift-space> {\n\
    %q selection adjust insert\n\
}",
"bind Entry <Shift-Select> {\n\
    %q selection adjust insert\n\
}",
"bind Entry <Control-slash> {\n\
    %q selection range 0 end\n\
}",
"bind Entry <Control-backslash> {\n\
    %q selection clear\n\
}",
"tkEntryClipboardKeysyms F16 F20 F18",
"bind Entry <KeyPress> {\n\
    tkEntryInsert %W %A\n\
}",
"bind Entry <Alt-KeyPress> {# nothing}",
"bind Entry <Meta-KeyPress> {# nothing}",
"bind Entry <Control-KeyPress> {# nothing}",
"bind Entry <Escape> {# nothing}",
"bind Entry <Return> {# nothing}",
"bind Entry <KP_Enter> {# nothing}",
"bind Entry <Tab> {# nothing}",
"bind Entry <Insert> {\n\
    catch {tkEntryInsert %W [selection get -displayof %W]}\n\
}",
"bind Entry <Control-a> {\n\
    if !$tk_strictMotif {\n\
	tkEntrySetCursor %W 0\n\
    }\n\
}",
"bind Entry <Control-b> {\n\
    if !$tk_strictMotif {\n\
	tkEntrySetCursor %W [expr [%q index insert] - 1]\n\
    }\n\
}",
"bind Entry <Control-d> {\n\
    if !$tk_strictMotif {\n\
	%q delete insert\n\
    }\n\
}",
"bind Entry <Control-e> {\n\
    if !$tk_strictMotif {\n\
	tkEntrySetCursor %W end\n\
    }\n\
}",
"bind Entry <Control-f> {\n\
    if !$tk_strictMotif {\n\
	tkEntrySetCursor %W [expr [%q index insert] + 1]\n\
    }\n\
}",
"bind Entry <Control-h> {\n\
    if !$tk_strictMotif {\n\
	tkEntryBackspace %W\n\
    }\n\
}",
"bind Entry <Control-k> {\n\
    if !$tk_strictMotif {\n\
	%q delete insert end\n\
    }\n\
}",
"bind Entry <Control-t> {\n\
    if !$tk_strictMotif {\n\
	tkEntryTranspose %W\n\
    }\n\
}",
"bind Entry <Meta-b> {\n\
    if !$tk_strictMotif {\n\
	tkEntrySetCursor %W \\\n\
		[string wordstart [%q get] [expr [%q index insert] - 1]]\n\
    }\n\
}",
"bind Entry <Meta-d> {\n\
    if !$tk_strictMotif {\n\
	%q delete insert [string wordend [%q get] [%q index insert]]\n\
    }\n\
}",
"bind Entry <Meta-f> {\n\
    if !$tk_strictMotif {\n\
	tkEntrySetCursor %W [string wordend [%q get] [%q index insert]]\n\
    }\n\
}",
"bind Entry <Meta-BackSpace> {\n\
    if !$tk_strictMotif {\n\
	%q delete [string wordstart [%q get] [expr [%q index insert] - 1]] \\\n\
		insert\n\
    }\n\
}",
"if !$tk_strictMotif {\n\
    tkEntryClipboardKeysyms Meta-w Control-w Control-y\n\
}",
"bind Entry <2> {\n\
    if !$tk_strictMotif {\n\
	%q scan mark %x\n\
	set tkPriv(x) %x\n\
	set tkPriv(y) %y\n\
	set tkPriv(mouseMoved) 0\n\
    }\n\
}",
"bind Entry <B2-Motion> {\n\
    if !$tk_strictMotif {\n\
	if {abs(%x-$tkPriv(x)) > 2} {\n\
	    set tkPriv(mouseMoved) 1\n\
	}\n\
	%q scan dragto %x\n\
    }\n\
}",
"proc tkEntryClosestGap {w x} {\n\
    set q [winfo command $w]\n\
    set pos [$q index @$x]\n\
    set bbox [$q bbox $pos]\n\
    if {($x - [lindex $bbox 0]) < ([lindex $bbox 2]/2)} {\n\
	return $pos\n\
    }\n\
    incr pos\n\
}",
"proc tkEntryButton1 {w x} {\n\
    global tkPriv\n\
\n\
    set tkPriv(selectMode) char\n\
    set tkPriv(mouseMoved) 0\n\
    set tkPriv(pressX) $x\n\
    set q [winfo command $w]\n\
    $q icursor [tkEntryClosestGap $w $x]\n\
    $q selection from insert\n\
    if {[lindex [$q configure -state] 4] == \"normal\"} {focus $w}\n\
}",
"proc tkEntryMouseSelect {w x} {\n\
    global tkPriv\n\
\n\
    set q [winfo command $w]\n\
    set cur [tkEntryClosestGap $w $x]\n\
    set anchor [$q index anchor]\n\
    if {($cur != $anchor) || (abs($tkPriv(pressX) - $x) >= 3)} {\n\
	set tkPriv(mouseMoved) 1\n\
    }\n\
    switch $tkPriv(selectMode) {\n\
	char {\n\
	    if $tkPriv(mouseMoved) {\n\
		if {$cur < $anchor} {\n\
		    $q selection range $cur $anchor\n\
		} elseif {$cur > $anchor} {\n\
		    $q selection range $anchor $cur\n\
		} else {\n\
		    $q selection clear\n\
		}\n\
	    }\n\
	}\n\
	word {\n\
	    if {$cur < [$q index anchor]} {\n\
		$q selection range [string wordstart [$q get] $cur] \\\n\
			[string wordend [$q get] [expr $anchor-1]]\n\
	    } else {\n\
		$q selection range [string wordstart [$q get] $anchor] \\\n\
			[string wordend [$q get] [expr $cur - 1]]\n\
	    }\n\
	}\n\
	line {\n\
	    $q selection range 0 end\n\
	}\n\
    }\n\
    update idletasks\n\
}",
"proc tkEntryPaste {w x} {\n\
    global tkPriv\n\
\n\
    set q [winfo command $w]\n\
    $q icursor [tkEntryClosestGap $w $x]\n\
    catch {$q insert insert [selection get -displayof $w]}\n\
    if {[lindex [$q configure -state] 4] == \"normal\"} {focus $w}\n\
}",
"proc tkEntryAutoScan {w} {\n\
    global tkPriv\n\
    set q [winfo command $w]\n\
    set x $tkPriv(x)\n\
    if {![winfo exists $w]} return\n\
    if {$x >= [winfo width $w]} {\n\
	$q xview scroll 2 units\n\
	tkEntryMouseSelect $w $x\n\
    } elseif {$x < 0} {\n\
	$q xview scroll -2 units\n\
	tkEntryMouseSelect $w $x\n\
    }\n\
    set tkPriv(afterId) [after 50 tkEntryAutoScan $w]\n\
}",
"proc tkEntryKeySelect {w new} {\n\
    set q [winfo command $w]\n\
    if ![$q selection present] {\n\
	$q selection from insert\n\
	$q selection to $new\n\
    } else {\n\
	$q selection adjust $new\n\
    }\n\
    $q icursor $new\n\
}",
"proc tkEntryInsert {w s} {\n\
    if {$s == \"\"} {\n\
	return\n\
    }\n\
    set q [winfo command $w]\n\
    catch {\n\
	set insert [$q index insert]\n\
	if {([$q index sel.first] <= $insert)\n\
		&& ([$q index sel.last] >= $insert)} {\n\
	    $q delete sel.first sel.last\n\
	}\n\
    }\n\
    $q insert insert $s\n\
    tkEntrySeeInsert $w\n\
}",
"proc tkEntryBackspace w {\n\
    set q [winfo command $w]\n\
    if [$q selection present] {\n\
	$q delete sel.first sel.last\n\
    } else {\n\
	set x [expr {[$q index insert] - 1}]\n\
	if {$x >= 0} {$q delete $x}\n\
	if {[$q index @0] >= [$q index insert]} {\n\
	    set range [$q xview]\n\
	    set left [lindex $range 0]\n\
	    set right [lindex $range 1]\n\
	    $q xview moveto [expr $left - ($right - $left)/2.0]\n\
	}\n\
    }\n\
}",
"proc tkEntrySeeInsert w {\n\
    set q [winfo command $w]\n\
    set c [$q index insert]\n\
    set left [$q index @0]\n\
    if {$left > $c} {\n\
	$q xview $c\n\
	return\n\
    }\n\
    set x [winfo width $w]\n\
    while {([$q index @$x] <= $c) && ($left < $c)} {\n\
	incr left\n\
	$q xview $left\n\
    }\n\
}",
"proc tkEntrySetCursor {w pos} {\n\
    set q [winfo command $w]\n\
    $q icursor $pos\n\
    $q selection clear\n\
    tkEntrySeeInsert $w\n\
}",
"proc tkEntryTranspose w {\n\
    set q [winfo command $w]\n\
    set i [$q index insert]\n\
    if {$i < [$q index end]} {\n\
	incr i\n\
    }\n\
    set first [expr $i-2]\n\
    if {$first < 0} {\n\
	return\n\
    }\n\
    set new [string index [$q get] [expr $i-1]][string index [$q get] $first]\n\
    $q delete $first $i\n\
    $q insert insert $new\n\
    tkEntrySeeInsert $w\n\
}",
"bind Listbox <1> {\n\
    if [winfo exists %W] {\n\
	tkListboxBeginSelect %W [%q index @%x,%y]\n\
    }\n\
}",
"bind Listbox <2> {\n\
    # Empty script\n\
}",
"bind Listbox <B1-Motion> {\n\
    set tkPriv(x) %x\n\
    set tkPriv(y) %y\n\
    tkListboxMotion %W [%q index @%x,%y]\n\
}",
"bind Listbox <ButtonRelease-1> {\n\
    tkCancelRepeat\n\
    %q activate @%x,%y\n\
}",
"bind Listbox <Shift-1> {\n\
    tkListboxBeginExtend %W [%q index @%x,%y]\n\
}",
"bind Listbox <Control-1> {\n\
    tkListboxBeginToggle %W [%q index @%x,%y]\n\
}",
"bind Listbox <B1-Leave> {\n\
    set tkPriv(x) %x\n\
    set tkPriv(y) %y\n\
    tkListboxAutoScan %W\n\
}",
"bind Listbox <B1-Enter> {\n\
    tkCancelRepeat\n\
}",
"bind Listbox <Up> {\n\
    tkListboxUpDown %W -1\n\
}",
"bind Listbox <Shift-Up> {\n\
    tkListboxExtendUpDown %W -1\n\
}",
"bind Listbox <Down> {\n\
    tkListboxUpDown %W 1\n\
}",
"bind Listbox <Shift-Down> {\n\
    tkListboxExtendUpDown %W 1\n\
}",
"bind Listbox <Left> {\n\
    %q xview scroll -1 units\n\
}",
"bind Listbox <Control-Left> {\n\
    %q xview scroll -1 pages\n\
}",
"bind Listbox <Right> {\n\
    %q xview scroll 1 units\n\
}",
"bind Listbox <Control-Right> {\n\
    %q xview scroll 1 pages\n\
}",
"bind Listbox <Prior> {\n\
    %q yview scroll -1 pages\n\
    %q activate @0,0\n\
}",
"bind Listbox <Next> {\n\
    %q yview scroll 1 pages\n\
    %q activate @0,0\n\
}",
"bind Listbox <Control-Prior> {\n\
    %q xview scroll -1 pages\n\
}",
"bind Listbox <Control-Next> {\n\
    %q xview scroll 1 pages\n\
}",
"bind Listbox <Home> {\n\
    %q xview moveto 0\n\
}",
"bind Listbox <End> {\n\
    %q xview moveto 1\n\
}",
"bind Listbox <Control-Home> {\n\
    %q activate 0\n\
    %q see 0\n\
    %q selection clear 0 end\n\
    %q selection set 0\n\
}",
"bind Listbox <Shift-Control-Home> {\n\
    tkListboxDataExtend %W 0\n\
}",
"bind Listbox <Control-End> {\n\
    %q activate end\n\
    %q see end\n\
    %q selection clear 0 end\n\
    %q selection set end\n\
}",
"bind Listbox <Shift-Control-End> {\n\
    tkListboxDataExtend %W end\n\
}",
"bind Listbox <F16> {\n\
    if {[selection own -displayof %W] == \"%W\"} {\n\
	clipboard clear -displayof %W\n\
	clipboard append -displayof %W [selection get -displayof %W]\n\
    }\n\
}",
"bind Listbox <space> {\n\
    tkListboxBeginSelect %W [%q index active]\n\
}",
"bind Listbox <Select> {\n\
    tkListboxBeginSelect %W [%q index active]\n\
}",
"bind Listbox <Control-Shift-space> {\n\
    tkListboxBeginExtend %W [%q index active]\n\
}",
"bind Listbox <Shift-Select> {\n\
    tkListboxBeginExtend %W [%q index active]\n\
}",
"bind Listbox <Escape> {\n\
    tkListboxCancel %W\n\
}",
"bind Listbox <Control-slash> {\n\
    tkListboxSelectAll %W\n\
}",
"bind Listbox <Control-backslash> {\n\
    if {[%q cget -selectmode] != \"browse\"} {\n\
	%q selection clear 0 end\n\
    }\n\
}",
"bind Listbox <2> {\n\
    %q scan mark %x %y\n\
}",
"bind Listbox <B2-Motion> {\n\
    %q scan dragto %x %y\n\
}",
"proc tkListboxBeginSelect {w el} {\n\
    global tkPriv\n\
    set q [winfo command $w]\n\
    if {[$q cget -selectmode]  == \"multiple\"} {\n\
	if [$q selection includes $el] {\n\
	    $q selection clear $el\n\
	} else {\n\
	    $q selection set $el\n\
	}\n\
    } else {\n\
	$q selection clear 0 end\n\
	$q selection set $el\n\
	$q selection anchor $el\n\
	set tkPriv(listboxSelection) {}\n\
	set tkPriv(listboxPrev) $el\n\
    }\n\
}",
"proc tkListboxMotion {w el} {\n\
    global tkPriv\n\
    if {$el == $tkPriv(listboxPrev)} {\n\
	return\n\
    }\n\
    set q [winfo command $w]\n\
    set anchor [$q index anchor]\n\
    switch [$q cget -selectmode] {\n\
	browse {\n\
	    $q selection clear 0 end\n\
	    $q selection set $el\n\
	    set tkPriv(listboxPrev) $el\n\
	}\n\
	extended {\n\
	    set i $tkPriv(listboxPrev)\n\
	    if [$q selection includes anchor] {\n\
		$q selection clear $i $el\n\
		$q selection set anchor $el\n\
	    } else {\n\
		$q selection clear $i $el\n\
		$q selection clear anchor $el\n\
	    }\n\
	    while {($i < $el) && ($i < $anchor)} {\n\
		if {[lsearch $tkPriv(listboxSelection) $i] >= 0} {\n\
		    $q selection set $i\n\
		}\n\
		incr i\n\
	    }\n\
	    while {($i > $el) && ($i > $anchor)} {\n\
		if {[lsearch $tkPriv(listboxSelection) $i] >= 0} {\n\
		    $q selection set $i\n\
		}\n\
		incr i -1\n\
	    }\n\
	    set tkPriv(listboxPrev) $el\n\
	}\n\
    }\n\
}",
"proc tkListboxBeginExtend {w el} {\n\
    set q [winfo command $w]\n\
    if {([$q cget -selectmode] == \"extended\")\n\
	    && [$q selection includes anchor]} {\n\
	tkListboxMotion $w $el\n\
    }\n\
}",
"proc tkListboxBeginToggle {w el} {\n\
    global tkPriv\n\
    set q [winfo command $w]\n\
    if {[$q cget -selectmode] == \"extended\"} {\n\
	set tkPriv(listboxSelection) [$q curselection]\n\
	set tkPriv(listboxPrev) $el\n\
	$q selection anchor $el\n\
	if [$q selection includes $el] {\n\
	    $q selection clear $el\n\
	} else {\n\
	    $q selection set $el\n\
	}\n\
    }\n\
}",
"proc tkListboxAutoScan {w} {\n\
    global tkPriv\n\
    if {![winfo exists $w]} return\n\
    set x $tkPriv(x)\n\
    set y $tkPriv(y)\n\
    set q [winfo command $w]\n\
    if {$y >= [winfo height $w]} {\n\
	$q yview scroll 1 units\n\
    } elseif {$y < 0} {\n\
	$q yview scroll -1 units\n\
    } elseif {$x >= [winfo width $w]} {\n\
	$q xview scroll 2 units\n\
    } elseif {$x < 0} {\n\
	$q xview scroll -2 units\n\
    } else {\n\
	return\n\
    }\n\
    tkListboxMotion $w [$q index @$x,$y]\n\
    set tkPriv(afterId) [after 50 tkListboxAutoScan $w]\n\
}",
"proc tkListboxUpDown {w amount} {\n\
    global tkPriv\n\
    set q [winfo command $w]\n\
    $q activate [expr [$q index active] + $amount]\n\
    $q see active\n\
    switch [$q cget -selectmode] {\n\
	browse {\n\
	    $q selection clear 0 end\n\
	    $q selection set active\n\
	}\n\
	extended {\n\
	    $q selection clear 0 end\n\
	    $q selection set active\n\
	    $q selection anchor active\n\
	    set tkPriv(listboxPrev) [$q index active]\n\
	    set tkPriv(listboxSelection) {}\n\
	}\n\
    }\n\
}",
"proc tkListboxExtendUpDown {w amount} {\n\
    set q [winfo command $w]\n\
    if {[$q cget -selectmode] != \"extended\"} {\n\
	return\n\
    }\n\
    $q activate [expr [$q index active] + $amount]\n\
    $q see active\n\
    tkListboxMotion $w [$q index active]\n\
}",
"proc tkListboxDataExtend {w el} {\n\
    set q [winfo command $w]\n\
    set mode [$q cget -selectmode]\n\
    if {$mode == \"extended\"} {\n\
	$q activate $el\n\
	$q see $el\n\
        if [$q selection includes anchor] {\n\
	    tkListboxMotion $w $el\n\
	}\n\
    } elseif {$mode == \"multiple\"} {\n\
	$q activate $el\n\
	$q see $el\n\
    }\n\
}",
"proc tkListboxCancel w {\n\
    global tkPriv\n\
    set q [winfo command $w]\n\
    if {[$q cget -selectmode] != \"extended\"} {\n\
	return\n\
    }\n\
    set first [$q index anchor]\n\
    set last $tkPriv(listboxPrev)\n\
    if {$first > $last} {\n\
	set tmp $first\n\
	set first $last\n\
	set last $tmp\n\
    }\n\
    $q selection clear $first $last\n\
    while {$first <= $last} {\n\
	if {[lsearch $tkPriv(listboxSelection) $first] >= 0} {\n\
	    $q selection set $first\n\
	}\n\
	incr first\n\
    }\n\
}",
"proc tkListboxSelectAll w {\n\
    set q [winfo command $w]\n\
    set mode [$q cget -selectmode]\n\
    if {($mode == \"single\") || ($mode == \"browse\")} {\n\
	$q selection clear 0 end\n\
	$q selection set active\n\
    } else {\n\
	$q selection set 0 end\n\
    }\n\
}",
"bind Menubutton <FocusIn> {}",
"bind Menubutton <Enter> {\n\
    tkMbEnter %W\n\
}",
"bind Menubutton <Leave> {\n\
    tkMbLeave %W\n\
}",
"bind Menubutton <1> {\n\
    if {$tkPriv(inMenubutton) != \"\"} {\n\
	tkMbPost $tkPriv(inMenubutton) %X %Y\n\
    }\n\
}",
"bind Menubutton <Motion> {\n\
    tkMbMotion %W up %X %Y\n\
}",
"bind Menubutton <B1-Motion> {\n\
    tkMbMotion %W down %X %Y\n\
}",
"bind Menubutton <ButtonRelease-1> {\n\
    tkMbButtonUp %W\n\
}",
"bind Menubutton <space> {\n\
    tkMbPost %W\n\
    tkMenuFirstEntry [%q cget -menu]\n\
}",
"bind Menu <FocusIn> {}",
"bind Menu <Enter> {\n\
    set tkPriv(window) %W\n\
    if {\"%m\" != \"NotifyUngrab\"} {\n\
	focus %W\n\
    }\n\
}",
"bind Menu <Leave> {\n\
    tkMenuLeave %W %X %Y %s\n\
}",
"bind Menu <Motion> {\n\
    tkMenuMotion %W %y %s\n\
}",
"bind Menu <ButtonPress> {\n\
    tkMenuButtonDown %W\n\
}",
"bind Menu <ButtonRelease> {\n\
    tkMenuInvoke %W 1\n\
}",
"bind Menu <space> {\n\
    tkMenuInvoke %W 0\n\
}",
"bind Menu <Return> {\n\
    tkMenuInvoke %W 0\n\
}",
"bind Menu <Escape> {\n\
    tkMenuEscape %W\n\
}",
"bind Menu <Left> {\n\
    tkMenuLeftRight %W left\n\
}",
"bind Menu <Right> {\n\
    tkMenuLeftRight %W right\n\
}",
"bind Menu <Up> {\n\
    tkMenuNextEntry %W -1\n\
}",
"bind Menu <Down> {\n\
    tkMenuNextEntry %W +1\n\
}",
"bind Menu <KeyPress> {\n\
    tkTraverseWithinMenu %W %A\n\
}",
"bind all <Alt-KeyPress> {\n\
    tkTraverseToMenu %W %A\n\
}",
"bind all <F10> {\n\
    tkFirstMenu %W\n\
}",
"proc tkMbEnter w {\n\
    global tkPriv\n\
    set q [winfo command $w]\n\
\n\
    if {$tkPriv(inMenubutton) != \"\"} {\n\
	tkMbLeave $tkPriv(inMenubutton)\n\
    }\n\
    set tkPriv(inMenubutton) $w\n\
    if {[$q cget -state] != \"disabled\"} {\n\
	$q configure -state active\n\
    }\n\
}",
"proc tkMbLeave w {\n\
    global tkPriv\n\
    set q [winfo command $w]\n\
\n\
    set tkPriv(inMenubutton) {}\n\
    if ![winfo exists $w] {\n\
	return\n\
    }\n\
    if {[$q cget -state] == \"active\"} {\n\
	$q configure -state normal\n\
    }\n\
}",
"proc tkMbPost {w {x {}} {y {}}} {\n\
    global tkPriv\n\
    set q [winfo command $w]\n\
\n\
    if {([$q cget -state] == \"disabled\") ||\n\
    ($w == $tkPriv(postedMb))} {\n\
	return\n\
    }\n\
    set menu [$q cget -menu]\n\
    set qmenu [winfo command $menu]\n\
    if {$menu == \"\"} {\n\
	return\n\
    }\n\
    if ![string match $w.* $menu] {\n\
	error \"can't post $menu:  it isn't a descendant of $w (this is a new requirement in Tk versions 3.0 and later)\"\n\
    }\n\
    set cur $tkPriv(postedMb)\n\
    if {$cur != \"\"} {\n\
	tkMenuUnpost {}\n\
    }\n\
    set tkPriv(cursor) [$q cget -cursor]\n\
    set tkPriv(relief) [$q cget -relief]\n\
    $q configure -cursor arrow\n\
    $q configure -relief raised\n\
    set tkPriv(postedMb) $w\n\
    set tkPriv(focus) [focus]\n\
    $qmenu activate none\n\
\n\
    # If this looks like an option menubutton then post the menu so\n\
    # that the current entry is on top of the mouse.  Otherwise post\n\
    # the menu just below the menubutton, as for a pull-down.\n\
\n\
    if [$q cget -indicatoron] {\n\
	if {$y == \"\"} {\n\
	    set x [expr [winfo rootx $w] + [winfo width $w]/2]\n\
	    set y [expr [winfo rooty $w] + [winfo height $w]/2]\n\
	}\n\
	tkPostOverPoint $menu $x $y [tkMenuFindName $menu [$q cget -text]]\n\
    } else {\n\
	$qmenu post [winfo rootx $w] [expr [winfo rooty $w]+[winfo height $w]]\n\
    }\n\
    focus $menu\n\
    tkSaveGrabInfo $w\n\
    grab -global $w\n\
}",
"proc tkMenuUnpost menu {\n\
    global tkPriv\n\
    set mb $tkPriv(postedMb)\n\
\n\
    # Restore focus right away (otherwise X will take focus away when\n\
    # the menu is unmapped and under some window managers (e.g. olvwm)\n\
    # we'll lose the focus completely).\n\
\n\
    catch {focus $tkPriv(focus)}\n\
    set tkPriv(focus) \"\"\n\
\n\
    # Unpost menu(s) and restore some stuff that's dependent on\n\
    # what was posted.\n\
\n\
    catch {\n\
	if {$mb != \"\"} {\n\
            set qmb [winfo command $mb]\n\
	    set menu [$qmb cget -menu]\n\
	    [winfo command $menu] unpost\n\
	    set tkPriv(postedMb) {}\n\
	    $qmb configure -cursor $tkPriv(cursor)\n\
	    $qmb configure -relief $tkPriv(relief)\n\
	} elseif {$tkPriv(popup) != \"\"} {\n\
	    $tkPriv(popup) unpost\n\
	    set tkPriv(popup) {}\n\
	} elseif {[wm overrideredirect $menu]} {\n\
	    # We're in a cascaded sub-menu from a torn-off menu or popup.\n\
	    # Unpost all the menus up to the toplevel one (but not\n\
	    # including the top-level torn-off one) and deactivate the\n\
	    # top-level torn off menu if there is one.\n\
\n\
	    while 1 {\n\
		set parent [winfo parent $menu]\n\
		if {([winfo class $parent] != \"Menu\")\n\
			|| ![winfo ismapped $parent]} {\n\
		    break\n\
		}\n\
		[winfo command $parent] activate none\n\
		[winfo command $parent] postcascade none\n\
		if {![wm overrideredirect $parent]} {\n\
		    break\n\
		}\n\
		set menu $parent\n\
	    }\n\
	    [winfo command $menu] unpost\n\
	}\n\
    }\n\
\n\
    # Release grab, if any, and restore the previous grab, if there\n\
    # was one.\n\
\n\
    if {$menu != \"\"} {\n\
	set grab [grab current $menu]\n\
	if {$grab != \"\"} {\n\
	    grab release $grab\n\
	}\n\
    }\n\
    if {$tkPriv(oldGrab) != \"\"} {\n\
\n\
	# Be careful restoring the old grab, since it's window may not\n\
	# be visible anymore.\n\
\n\
	catch {\n\
	    if {$tkPriv(grabStatus) == \"global\"} {\n\
		grab set -global $tkPriv(oldGrab)\n\
	    } else {\n\
		grab set $tkPriv(oldGrab)\n\
	    }\n\
	}\n\
	set tkPriv(oldGrab) \"\"\n\
    }\n\
}",
"proc tkMbMotion {w upDown rootx rooty} {\n\
    global tkPriv\n\
\n\
    if {$tkPriv(inMenubutton) == $w} {\n\
	return\n\
    }\n\
    set new [winfo containing $rootx $rooty]\n\
    if {($new != $tkPriv(inMenubutton)) && (($new == \"\")\n\
	    || ([winfo toplevel $new] == [winfo toplevel $w]))} {\n\
	if {$tkPriv(inMenubutton) != \"\"} {\n\
	    tkMbLeave $tkPriv(inMenubutton)\n\
	}\n\
	if {($new != \"\") && ([winfo class $new] == \"Menubutton\")\n\
		&& ([[winfo command $new] cget -indicatoron] == 0)\n\
		&& ([[winfo command $w] cget -indicatoron] == 0)} {\n\
	    if {$upDown == \"down\"} {\n\
		tkMbPost $new $rootx $rooty\n\
	    } else {\n\
		tkMbEnter $new\n\
	    }\n\
	}\n\
    }\n\
}",
"proc tkMbButtonUp w {\n\
    global tkPriv\n\
\n\
    if  {($tkPriv(postedMb) == $w) && ($tkPriv(inMenubutton) == $w)} {\n\
	tkMenuFirstEntry [[winfo command $tkPriv(postedMb)] cget -menu]\n\
    } else {\n\
	tkMenuUnpost {}\n\
    }\n\
}",
"proc tkMenuMotion {menu y state} {\n\
    global tkPriv\n\
    set qmenu [winfo command $menu]\n\
    if {$menu == $tkPriv(window)} {\n\
	$qmenu activate @$y\n\
    }\n\
    if {($state & 0x1f00) != 0} {\n\
	$qmenu postcascade active\n\
    }\n\
}",
"proc tkMenuButtonDown menu {\n\
    global tkPriv\n\
    [winfo command $menu] postcascade active\n\
    if {$tkPriv(postedMb) != \"\"} {\n\
	grab -global $tkPriv(postedMb)\n\
    } else {\n\
	while {[wm overrideredirect $menu]\n\
		&& ([winfo class [winfo parent $menu]] == \"Menu\")\n\
		&& [winfo ismapped [winfo parent $menu]]} {\n\
	    set menu [winfo parent $menu]\n\
	}\n\
\n\
	# Don't update grab information if the grab window isn't changing.\n\
	# Otherwise, we'll get an error when we unpost the menus and\n\
	# restore the grab, since the old grab window will not be viewable\n\
	# anymore.\n\
\n\
	if {$menu != [grab current $menu]} {\n\
	    tkSaveGrabInfo $menu\n\
	}\n\
\n\
	# Must re-grab even if the grab window hasn't changed, in order\n\
	# to release the implicit grab from the button press.\n\
\n\
	grab -global $menu\n\
    }\n\
}",
"proc tkMenuLeave {menu rootx rooty state} {\n\
    global tkPriv\n\
    set qmenu [winfo command $menu]\n\
    set tkPriv(window) {}\n\
    if {[$qmenu index active] == \"none\"} {\n\
	return\n\
    }\n\
    if {([$qmenu type active] == \"cascade\")\n\
	    && ([winfo containing $rootx $rooty]\n\
	    == [$qmenu entrycget active -menu])} {\n\
	return\n\
    }\n\
    $qmenu activate none\n\
}",
"proc tkMenuInvoke {w buttonRelease} {\n\
    global tkPriv\n\
\n\
    set q [winfo command $w]\n\
    if {$buttonRelease && ($tkPriv(window) == \"\")} {\n\
	# Mouse was pressed over a menu without a menu button, then\n\
	# dragged off the menu (possibly with a cascade posted) and\n\
	# released.  Unpost everything and quit.\n\
\n\
	$q postcascade none\n\
	$q activate none\n\
	tkMenuUnpost $w\n\
	return\n\
    }\n\
    if {[$q type active] == \"cascade\"} {\n\
	$q postcascade active\n\
	set menu [$q entrycget active -menu]\n\
	tkMenuFirstEntry $menu\n\
    } elseif {[$q type active] == \"tearoff\"} {\n\
	tkMenuUnpost $w\n\
	tkTearOffMenu $w\n\
    } else {\n\
	tkMenuUnpost $w\n\
	uplevel #0 [list $q invoke active]\n\
    }\n\
}",
"proc tkMenuEscape menu {\n\
    if {[winfo class [winfo parent $menu]] != \"Menu\"} {\n\
	tkMenuUnpost $menu\n\
    } else {\n\
	tkMenuLeftRight $menu -1\n\
    }\n\
}",
"proc tkMenuLeftRight {menu direction} {\n\
    global tkPriv\n\
    set qmenu [winfo command $menu]\n\
\n\
    # First handle traversals into and out of cascaded menus.\n\
\n\
    if {$direction == \"right\"} {\n\
	set count 1\n\
	if {[$qmenu type active] == \"cascade\"} {\n\
	    $qmenu postcascade active\n\
	    set m2 [$qmenu entrycget active -menu]\n\
	    if {$m2 != \"\"} {\n\
		tkMenuFirstEntry $m2\n\
	    }\n\
	    return\n\
	}\n\
    } else {\n\
	set count -1\n\
	set m2 [winfo parent $menu]\n\
	if {[winfo class $m2] == \"Menu\"} {\n\
	    $qmenu activate none\n\
	    focus $m2\n\
\n\
	    # This code unposts any posted submenu in the parent.\n\
\n\
	    set qm2 [winfo command $m2]\n\
	    set tmp [$qm2 index active]\n\
	    $qm2 activate none\n\
	    $qm2 activate $tmp\n\
	    return\n\
	}\n\
    }\n\
\n\
    # Can't traverse into or out of a cascaded menu.  Go to the next\n\
    # or previous menubutton, if that makes sense.\n\
\n\
    set w $tkPriv(postedMb)\n\
    if {$w == \"\"} {\n\
	return\n\
    }\n\
    set buttons [winfo children [winfo parent $w]]\n\
    set length [llength $buttons]\n\
    set i [expr [lsearch -exact $buttons $w] + $count]\n\
    while 1 {\n\
	while {$i < 0} {\n\
	    incr i $length\n\
	}\n\
	while {$i >= $length} {\n\
	    incr i -$length\n\
	}\n\
	set mb [lindex $buttons $i]\n\
	set qmb [winfo command $mb]\n\
	if {([winfo class $mb] == \"Menubutton\")\n\
		&& ([$qmb cget -state] != \"disabled\")\n\
		&& ([$qmb cget -menu] != \"\")\n\
		&& ([[$qmb cget -menu] index last] != \"none\")} {\n\
	    break\n\
	}\n\
	if {$mb == $w} {\n\
	    return\n\
	}\n\
	incr i $count\n\
    }\n\
    tkMbPost $mb\n\
    tkMenuFirstEntry [$qmb cget -menu]\n\
}",
"proc tkMenuNextEntry {menu count} {\n\
    global tkPriv\n\
    set qmenu [winfo command $menu]\n\
    if {[$qmenu index last] == \"none\"} {\n\
	return\n\
    }\n\
    set length [expr [$qmenu index last]+1]\n\
    set quitAfter $length\n\
    set active [$qmenu index active]\n\
    if {$active == \"none\"} {\n\
	set i 0\n\
    } else {\n\
	set i [expr $active + $count]\n\
    }\n\
    while 1 {\n\
	if {$quitAfter <= 0} {\n\
	    # We've tried every entry in the menu.  Either there are\n\
	    # none, or they're all disabled.  Just give up.\n\
\n\
	    return\n\
	}\n\
	while {$i < 0} {\n\
	    incr i $length\n\
	}\n\
	while {$i >= $length} {\n\
	    incr i -$length\n\
	}\n\
	if {[catch {$qmenu entrycget $i -state} state] == 0} {\n\
	    if {$state != \"disabled\"} {\n\
		break\n\
	    }\n\
	}\n\
	if {$i == $active} {\n\
	    return\n\
	}\n\
	incr i $count\n\
	incr quitAfter -1\n\
    }\n\
    $qmenu activate $i\n\
    $qmenu postcascade $i\n\
}",
"proc tkMenuFind {w char} {\n\
    global tkPriv\n\
    set char [string tolower $char]\n\
\n\
    foreach child [winfo child $w] {\n\
	switch [winfo class $child] {\n\
	    Menubutton {\n\
		set qchild [winfo command $child]\n\
		set char2 [string index [$qchild cget -text] \\\n\
			[$qchild cget -underline]]\n\
		if {([string compare $char [string tolower $char2]] == 0)\n\
			|| ($char == \"\")} {\n\
		    if {[$qchild cget -state] != \"disabled\"} {\n\
			return $child\n\
		    }\n\
		}\n\
	    }\n\
	    Frame {\n\
		set match [tkMenuFind $child $char]\n\
		if {$match != \"\"} {\n\
		    return $match\n\
		}\n\
	    }\n\
	}\n\
    }\n\
    return {}\n\
}",
"proc tkTraverseToMenu {w char} {\n\
    global tkPriv\n\
    if {$char == \"\"} {\n\
	return\n\
    }\n\
    while {[winfo class $w] == \"Menu\"} {\n\
	if {$tkPriv(postedMb) == \"\"} {\n\
	    return\n\
	}\n\
	set w [winfo parent $w]\n\
    }\n\
    set w [tkMenuFind [winfo toplevel $w] $char]\n\
    if {$w != \"\"} {\n\
	tkMbPost $w\n\
	tkMenuFirstEntry [[winfo command $w] cget -menu]\n\
    }\n\
}",
"proc tkFirstMenu w {\n\
    set w [tkMenuFind [winfo toplevel $w] \"\"]\n\
    if {$w != \"\"} {\n\
	tkMbPost $w\n\
	tkMenuFirstEntry [[winfo command $w] cget -menu]\n\
    }\n\
}",
"proc tkTraverseWithinMenu {w char} {\n\
    set q [winfo command $w]\n\
    if {$char == \"\"} {\n\
	return\n\
    }\n\
    set char [string tolower $char]\n\
    set last [$q index last]\n\
    if {$last == \"none\"} {\n\
	return\n\
    }\n\
    for {set i 0} {$i <= $last} {incr i} {\n\
	if [catch {set char2 [string index \\\n\
		[$q entrycget $i -label] \\\n\
		[$q entrycget $i -underline]]}] {\n\
	    continue\n\
	}\n\
	if {[string compare $char [string tolower $char2]] == 0} {\n\
	    if {[$q type $i] == \"cascade\"} {\n\
		$q postcascade $i\n\
		$q activate $i\n\
		set m2 [$q entrycget $i -menu]\n\
		if {$m2 != \"\"} {\n\
		    tkMenuFirstEntry $m2\n\
		}\n\
	    } else {\n\
		tkMenuUnpost $w\n\
		uplevel #0 [list $q invoke $i]\n\
	    }\n\
	    return\n\
	}\n\
    }\n\
}",
"proc tkMenuFirstEntry menu {\n\
    set qmenu [winfo command $menu]\n\
    if {$menu == \"\"} {\n\
	return\n\
    }\n\
    focus $menu\n\
    if {[$qmenu index active] != \"none\"} {\n\
	return\n\
    }\n\
    set last [$qmenu index last]\n\
    if {$last == \"none\"} {\n\
	return\n\
    }\n\
    for {set i 0} {$i <= $last} {incr i} {\n\
	if {([catch {set state [$qmenu entrycget $i -state]}] == 0)\n\
		&& ($state != \"disabled\") && ([$qmenu type $i] != \"tearoff\")} {\n\
	    $qmenu activate $i\n\
	    return\n\
	}\n\
    }\n\
}",
"proc tkMenuFindName {menu s} {\n\
    set qmenu [winfo command $menu]\n\
    set i \"\"\n\
    if {![regexp {^active$|^last$|^none$|^[0-9]|^@} $s]} {\n\
	catch {set i [$qmenu index $s]}\n\
	return $i\n\
    }\n\
    set last [$qmenu index last]\n\
    if {$last == \"none\"} {\n\
	return\n\
    }\n\
    for {set i 0} {$i <= $last} {incr i} {\n\
	if ![catch {$qmenu entrycget $i -label} label] {\n\
	    if {$label == $s} {\n\
		return $i\n\
	    }\n\
	}\n\
    }\n\
    return \"\"\n\
}",
"proc tkPostOverPoint {menu x y {entry {}}}  {\n\
    set qmenu [winfo command $menu]\n\
    if {$entry != {}} {\n\
	if {$entry == [$qmenu index last]} {\n\
	    incr y [expr -([$qmenu yposition $entry] \\\n\
		    + [winfo reqheight $menu])/2]\n\
	} else {\n\
	    incr y [expr -([$qmenu yposition $entry] \\\n\
		    + [$qmenu yposition [expr $entry+1]])/2]\n\
	}\n\
	incr x [expr -[winfo reqwidth $menu]/2]\n\
    }\n\
    $qmenu post $x $y\n\
    if {($entry != {}) && ([$qmenu entrycget $entry -state] != \"disabled\")} {\n\
	$qmenu activate $entry\n\
    }\n\
}",
"proc tkSaveGrabInfo w {\n\
    global tkPriv\n\
    set tkPriv(oldGrab) [grab current $w]\n\
    if {$tkPriv(oldGrab) != \"\"} {\n\
	set tkPriv(grabStatus) [grab status $tkPriv(oldGrab)]\n\
    }\n\
}",
"proc tk_popup {menu x y {entry {}}} {\n\
    global tkPriv\n\
    if {($tkPriv(popup) != \"\") || ($tkPriv(postedMb) != \"\")} {\n\
	tkMenuUnpost {}\n\
    }\n\
    tkPostOverPoint $menu $x $y $entry\n\
    tkSaveGrabInfo $menu\n\
    grab -global $menu\n\
    set tkPriv(popup) $menu\n\
    set tkPriv(focus) [focus]\n\
    focus $menu\n\
}",
"bind Scale <Enter> {\n\
    if $tk_strictMotif {\n\
	set tkPriv(activeBg) [%q cget -activebackground]\n\
	%q config -activebackground [%q cget -background]\n\
    }\n\
    tkScaleActivate %W %x %y\n\
}",
"bind Scale <Motion> {\n\
    tkScaleActivate %W %x %y\n\
}",
"bind Scale <Leave> {\n\
    if $tk_strictMotif {\n\
	%q config -activebackground $tkPriv(activeBg)\n\
    }\n\
    if {[%q cget -state] == \"active\"} {\n\
	%q configure -state normal\n\
    }\n\
}",
"bind Scale <1> {\n\
    tkScaleButtonDown %W %x %y\n\
}",
"bind Scale <B1-Motion> {\n\
    tkScaleDrag %W %x %y\n\
}",
"bind Scale <B1-Leave> { }",
"bind Scale <B1-Enter> { }",
"bind Scale <ButtonRelease-1> {\n\
    tkCancelRepeat\n\
    tkScaleEndDrag %W\n\
    tkScaleActivate %W %x %y\n\
}",
"bind Scale <2> {\n\
    tkScaleButton2Down %W %x %y\n\
}",
"bind Scale <B2-Motion> {\n\
    tkScaleDrag %W %x %y\n\
}",
"bind Scale <B2-Leave> { }",
"bind Scale <B2-Enter> { }",
"bind Scale <ButtonRelease-2> {\n\
    tkCancelRepeat\n\
    tkScaleEndDrag %W\n\
    tkScaleActivate %W %x %y\n\
}",
"bind Scale <Control-1> {\n\
    tkScaleControlPress %W %x %y\n\
}",
"bind Scale <Up> {\n\
    tkScaleIncrement %W up little noRepeat\n\
}",
"bind Scale <Down> {\n\
    tkScaleIncrement %W down little noRepeat\n\
}",
"bind Scale <Left> {\n\
    tkScaleIncrement %W up little noRepeat\n\
}",
"bind Scale <Right> {\n\
    tkScaleIncrement %W down little noRepeat\n\
}",
"bind Scale <Control-Up> {\n\
    tkScaleIncrement %W up big noRepeat\n\
}",
"bind Scale <Control-Down> {\n\
    tkScaleIncrement %W down big noRepeat\n\
}",
"bind Scale <Control-Left> {\n\
    tkScaleIncrement %W up big noRepeat\n\
}",
"bind Scale <Control-Right> {\n\
    tkScaleIncrement %W down big noRepeat\n\
}",
"bind Scale <Home> {\n\
    %q set [%q cget -from]\n\
}",
"bind Scale <End> {\n\
    %q set [%q cget -to]\n\
}",
"proc tkScaleActivate {w x y} {\n\
    global tkPriv\n\
    set q [winfo command $w]\n\
    if {[$q cget -state] == \"disabled\"} {\n\
	return;\n\
    }\n\
    if {[$q identify $x $y] == \"slider\"} {\n\
	$q configure -state active\n\
    } else {\n\
	$q configure -state normal\n\
    }\n\
}",
"proc tkScaleButtonDown {w x y} {\n\
    global tkPriv\n\
    set q [winfo command $w]\n\
    set tkPriv(dragging) 0\n\
    set el [$q identify $x $y]\n\
    if {$el == \"trough1\"} {\n\
	tkScaleIncrement $w up little initial\n\
    } elseif {$el == \"trough2\"} {\n\
	tkScaleIncrement $w down little initial\n\
    } elseif {$el == \"slider\"} {\n\
	set tkPriv(dragging) 1\n\
	set tkPriv(initValue) [$q get]\n\
	set coords [$q coords]\n\
	set tkPriv(deltaX) [expr $x - [lindex $coords 0]]\n\
	set tkPriv(deltaY) [expr $y - [lindex $coords 1]]\n\
	$q configure -sliderrelief sunken\n\
    }\n\
}",
"proc tkScaleDrag {w x y} {\n\
    global tkPriv\n\
    set q [winfo command $w]\n\
    if !$tkPriv(dragging) {\n\
	return\n\
    }\n\
    $q set [$q get [expr $x - $tkPriv(deltaX)] \\\n\
	    [expr $y - $tkPriv(deltaY)]]\n\
}",
"proc tkScaleEndDrag {w} {\n\
    global tkPriv\n\
    set tkPriv(dragging) 0\n\
    [winfo command $w] configure -sliderrelief raised\n\
}",
"proc tkScaleIncrement {w dir big repeat} {\n\
    global tkPriv\n\
    if {![winfo exists $w]} return\n\
    set q [winfo command $w]\n\
    if {$big == \"big\"} {\n\
	set inc [$q cget -bigincrement]\n\
	if {$inc == 0} {\n\
	    set inc [expr abs([$q cget -to] - [$q cget -from])/10.0]\n\
	}\n\
	if {$inc < [$q cget -resolution]} {\n\
	    set inc [$q cget -resolution]\n\
	}\n\
    } else {\n\
	set inc [$q cget -resolution]\n\
    }\n\
    if {([$q cget -from] > [$q cget -to]) ^ ($dir == \"up\")} {\n\
	set inc [expr -$inc]\n\
    }\n\
    $q set [expr [$q get] + $inc]\n\
\n\
    if {$repeat == \"again\"} {\n\
	set tkPriv(afterId) [after [$q cget -repeatinterval] \\\n\
		tkScaleIncrement $w $dir $big again]\n\
    } elseif {$repeat == \"initial\"} {\n\
	set delay [$q cget -repeatdelay]\n\
	if {$delay > 0} {\n\
	    set tkPriv(afterId) [after $delay \\\n\
		    tkScaleIncrement $w $dir $big again]\n\
	}\n\
    }\n\
}",
"proc tkScaleControlPress {w x y} {\n\
    set q [winfo command $w]\n\
    set el [$q identify $x $y]\n\
    if {$el == \"trough1\"} {\n\
	$q set [$q cget -from]\n\
    } elseif {$el == \"trough2\"} {\n\
	$q set [$q cget -to]\n\
    }\n\
}",
"proc tkScaleButton2Down {w x y} {\n\
    global tkPriv\n\
\n\
    set q [winfo command $w]\n\
    if {[$q cget -state] == \"disabled\"} {\n\
	return;\n\
    }\n\
    $q configure -state active\n\
    $q set [$q get $x $y]\n\
    set tkPriv(dragging) 1\n\
    set tkPriv(initValue) [$q get]\n\
    set coords \"$x $y\"\n\
    set tkPriv(deltaX) 0\n\
    set tkPriv(deltaY) 0\n\
}",
"bind Scrollbar <Enter> {\n\
    if $tk_strictMotif {\n\
	set tkPriv(activeBg) [%q cget -activebackground]\n\
	%q config -activebackground [%q cget -background]\n\
    }\n\
    %q activate [%q identify %x %y]\n\
}",
"bind Scrollbar <Motion> {\n\
    %q activate [%q identify %x %y]\n\
}",
"bind Scrollbar <Leave> {\n\
    if $tk_strictMotif {\n\
	%q config -activebackground $tkPriv(activeBg)\n\
    }\n\
    %q activate {}\n\
}",
"bind Scrollbar <1> {\n\
    tkScrollButtonDown %W %x %y\n\
}",
"bind Scrollbar <B1-Motion> {\n\
    tkScrollDrag %W %x %y\n\
}",
"bind Scrollbar <B1-B2-Motion> {\n\
    tkScrollDrag %W %x %y\n\
}",
"bind Scrollbar <ButtonRelease-1> {\n\
    tkScrollButtonUp %W %x %y\n\
}",
"bind Scrollbar <B1-Leave> {\n\
    # Prevents <Leave> binding from being invoked.\n\
}",
"bind Scrollbar <B1-Enter> {\n\
    # Prevents <Enter> binding from being invoked.\n\
}",
"bind Scrollbar <2> {\n\
    tkScrollButton2Down %W %x %y\n\
}",
"bind Scrollbar <B1-2> {\n\
    # Do nothing, since button 1 is already down.\n\
}",
"bind Scrollbar <B2-1> {\n\
    # Do nothing, since button 2 is already down.\n\
}",
"bind Scrollbar <B2-Motion> {\n\
    tkScrollDrag %W %x %y\n\
}",
"bind Scrollbar <ButtonRelease-2> {\n\
    tkScrollButtonUp %W %x %y\n\
}",
"bind Scrollbar <B1-ButtonRelease-2> {\n\
    # Do nothing:  B1 release will handle it.\n\
}",
"bind Scrollbar <B2-ButtonRelease-1> {\n\
    # Do nothing:  B2 release will handle it.\n\
}",
"bind Scrollbar <B2-Leave> {\n\
    # Prevents <Leave> binding from being invoked.\n\
}",
"bind Scrollbar <B2-Enter> {\n\
    # Prevents <Enter> binding from being invoked.\n\
}",
"bind Scrollbar <Control-1> {\n\
    tkScrollTopBottom %W %x %y\n\
}",
"bind Scrollbar <Control-2> {\n\
    tkScrollTopBottom %W %x %y\n\
}",
"bind Scrollbar <Up> {\n\
    tkScrollByUnits %W v -1\n\
}",
"bind Scrollbar <Down> {\n\
    tkScrollByUnits %W v 1\n\
}",
"bind Scrollbar <Control-Up> {\n\
    tkScrollByPages %W v -1\n\
}",
"bind Scrollbar <Control-Down> {\n\
    tkScrollByPages %W v 1\n\
}",
"bind Scrollbar <Left> {\n\
    tkScrollByUnits %W h -1\n\
}",
"bind Scrollbar <Right> {\n\
    tkScrollByUnits %W h 1\n\
}",
"bind Scrollbar <Control-Left> {\n\
    tkScrollByPages %W h -1\n\
}",
"bind Scrollbar <Control-Right> {\n\
    tkScrollByPages %W h 1\n\
}",
"bind Scrollbar <Prior> {\n\
    tkScrollByPages %W hv -1\n\
}",
"bind Scrollbar <Next> {\n\
    tkScrollByPages %W hv 1\n\
}",
"bind Scrollbar <Home> {\n\
    tkScrollToPos %W 0\n\
}",
"bind Scrollbar <End> {\n\
    tkScrollToPos %W 1\n\
}",
"proc tkScrollButtonDown {w x y} {\n\
    global tkPriv\n\
    set q [winfo command $w]\n\
    set tkPriv(relief) [$q cget -activerelief]\n\
    $q configure -activerelief sunken\n\
    set element [$q identify $x $y]\n\
    if {$element == \"slider\"} {\n\
	tkScrollStartDrag $w $x $y\n\
    } else {\n\
	tkScrollSelect $w $element initial\n\
    }\n\
}",
"proc tkScrollButtonUp {w x y} {\n\
    global tkPriv\n\
    set q [winfo command $w]\n\
    tkCancelRepeat\n\
    $q configure -activerelief $tkPriv(relief)\n\
    tkScrollEndDrag $w $x $y\n\
    $q activate [$q identify $x $y]\n\
}",
"proc tkScrollSelect {w element repeat} {\n\
    global tkPriv\n\
    if {![winfo exists $w]} return\n\
    set q [winfo command $w]\n\
    if {$element == \"arrow1\"} {\n\
	tkScrollByUnits $w hv -1\n\
    } elseif {$element == \"trough1\"} {\n\
	tkScrollByPages $w hv -1\n\
    } elseif {$element == \"trough2\"} {\n\
	tkScrollByPages $w hv 1\n\
    } elseif {$element == \"arrow2\"} {\n\
	tkScrollByUnits $w hv 1\n\
    } else {\n\
	return\n\
    }\n\
    if {$repeat == \"again\"} {\n\
	set tkPriv(afterId) [after [$q cget -repeatinterval] \\\n\
		tkScrollSelect $w $element again]\n\
    } elseif {$repeat == \"initial\"} {\n\
	set delay [$q cget -repeatdelay]\n\
	if {$delay > 0} {\n\
	    set tkPriv(afterId) [after $delay tkScrollSelect $w $element again]\n\
	}\n\
    }\n\
}",
"proc tkScrollStartDrag {w x y} {\n\
    global tkPriv\n\
\n\
    set q [winfo command $w]\n\
    if {[$q cget -command] == \"\"} {\n\
	return\n\
    }\n\
    set tkPriv(pressX) $x\n\
    set tkPriv(pressY) $y\n\
    set tkPriv(initValues) [$q get]\n\
    set iv0 [lindex $tkPriv(initValues) 0]\n\
    if {[llength $tkPriv(initValues)] == 2} {\n\
	set tkPriv(initPos) $iv0\n\
    } else {\n\
	if {$iv0 == 0} {\n\
	    set tkPriv(initPos) 0.0\n\
	} else {\n\
	    set tkPriv(initPos) [expr (double([lindex $tkPriv(initValues) 2])) \\\n\
		    / [lindex $tkPriv(initValues) 0]]\n\
	}\n\
    }\n\
}",
"proc tkScrollDrag {w x y} {\n\
    global tkPriv\n\
\n\
    set q [winfo command $w]\n\
    if {$tkPriv(initPos) == \"\"} {\n\
	return\n\
    }\n\
    set delta [$q delta [expr $x - $tkPriv(pressX)] [expr $y - $tkPriv(pressY)]]\n\
    if [$q cget -jump] {\n\
	if {[llength $tkPriv(initValues)] == 2} {\n\
	    $q set [expr [lindex $tkPriv(initValues) 0] + $delta] \\\n\
		    [expr [lindex $tkPriv(initValues) 1] + $delta]\n\
	} else {\n\
	    set delta [expr round($delta * [lindex $tkPriv(initValues) 0])]\n\
	    eval $q set [lreplace $tkPriv(initValues) 2 3 \\\n\
		    [expr [lindex $tkPriv(initValues) 2] + $delta] \\\n\
		    [expr [lindex $tkPriv(initValues) 3] + $delta]]\n\
	}\n\
    } else {\n\
	tkScrollToPos $w [expr $tkPriv(initPos) + $delta]\n\
    }\n\
}",
"proc tkScrollEndDrag {w x y} {\n\
    global tkPriv\n\
\n\
    set q [winfo command $w]\n\
    if {$tkPriv(initPos) == \"\"} {\n\
	return\n\
    }\n\
    if [$q cget -jump] {\n\
	set delta [$q delta [expr $x - $tkPriv(pressX)] \\\n\
		[expr $y - $tkPriv(pressY)]]\n\
	tkScrollToPos $w [expr $tkPriv(initPos) + $delta]\n\
    }\n\
    set tkPriv(initPos) \"\"\n\
}",
"proc tkScrollByUnits {w orient amount} {\n\
    set q [winfo command $w]\n\
    set cmd [$q cget -command]\n\
    if {($cmd == \"\") || ([string first \\\n\
	    [string index [$q cget -orient] 0] $orient] < 0)} {\n\
	return\n\
    }\n\
    set info [$q get]\n\
    if {[llength $info] == 2} {\n\
	uplevel #0 $cmd scroll $amount units\n\
    } else {\n\
	uplevel #0 $cmd [expr [lindex $info 2] + $amount]\n\
    }\n\
}",
"proc tkScrollByPages {w orient amount} {\n\
    set q [winfo command $w]\n\
    set cmd [$q cget -command]\n\
    if {($cmd == \"\") || ([string first \\\n\
	    [string index [$q cget -orient] 0] $orient] < 0)} {\n\
	return\n\
    }\n\
    set info [$q get]\n\
    if {[llength $info] == 2} {\n\
	uplevel #0 $cmd scroll $amount pages\n\
    } else {\n\
	uplevel #0 $cmd [expr [lindex $info 2] + $amount*([lindex $info 1] - 1)]\n\
    }\n\
}",
"proc tkScrollToPos {w pos} {\n\
    set q [winfo command $w]\n\
    set cmd [$q cget -command]\n\
    if {($cmd == \"\")} {\n\
	return\n\
    }\n\
    set info [$q get]\n\
    if {[llength $info] == 2} {\n\
	uplevel #0 $cmd moveto $pos\n\
    } else {\n\
	uplevel #0 $cmd [expr round([lindex $info 0]*$pos)]\n\
    }\n\
}",
"proc tkScrollTopBottom {w x y} {\n\
    global tkPriv\n\
    set q [winfo command $w]\n\
    set element [$q identify $x $y]\n\
    if [string match *1 $element] {\n\
	tkScrollToPos $w 0\n\
    } elseif [string match *2 $element] {\n\
	tkScrollToPos $w 1\n\
    }\n\
\n\
    # Set tkPriv(relief), since it's needed by tkScrollButtonUp.\n\
\n\
    set tkPriv(relief) [$q cget -activerelief]\n\
}",
"proc tkScrollButton2Down {w x y} {\n\
    global tkPriv\n\
    set q [winfo command $w]\n\
    set element [$q identify $x $y]\n\
    if {($element == \"arrow1\") || ($element == \"arrow2\")} {\n\
	tkScrollButtonDown $w $x $y\n\
	return\n\
    }\n\
    tkScrollToPos $w [$q fraction $x $y]\n\
    set tkPriv(relief) [$q cget -activerelief]\n\
\n\
    # Need the \"update idletasks\" below so that the widget calls us\n\
    # back to reset the actual scrollbar position before we start the\n\
    # slider drag.\n\
\n\
    update idletasks\n\
    $q configure -activerelief sunken\n\
    $q activate slider\n\
    tkScrollStartDrag $w $x $y\n\
}",
"proc tkTextClipboardKeysyms {copy cut paste} {\n\
    bind Text <$copy> {tk_textCopy %W}\n\
    bind Text <$cut> {tk_textCut %W}\n\
    bind Text <$paste> {tk_textPaste %W}\n\
}",
"bind Text <1> {\n\
    tkTextButton1 %W %x %y\n\
    %q tag remove sel 0.0 end\n\
}",
"bind Text <B1-Motion> {\n\
    set tkPriv(x) %x\n\
    set tkPriv(y) %y\n\
    tkTextSelectTo %W %x %y\n\
}",
"bind Text <Double-1> {\n\
    set tkPriv(selectMode) word\n\
    tkTextSelectTo %W %x %y\n\
    catch {%q mark set insert sel.first}\n\
}",
"bind Text <Triple-1> {\n\
    set tkPriv(selectMode) line\n\
    tkTextSelectTo %W %x %y\n\
    catch {%q mark set insert sel.first}\n\
}",
"bind Text <Shift-1> {\n\
    tkTextResetAnchor %W @%x,%y\n\
    set tkPriv(selectMode) char\n\
    tkTextSelectTo %W %x %y\n\
}",
"bind Text <Double-Shift-1>	{\n\
    set tkPriv(selectMode) word\n\
    tkTextSelectTo %W %x %y\n\
}",
"bind Text <Triple-Shift-1>	{\n\
    set tkPriv(selectMode) line\n\
    tkTextSelectTo %W %x %y\n\
}",
"bind Text <B1-Leave> {\n\
    set tkPriv(x) %x\n\
    set tkPriv(y) %y\n\
    tkTextAutoScan %W\n\
}",
"bind Text <B1-Enter> {\n\
    tkCancelRepeat\n\
}",
"bind Text <ButtonRelease-1> {\n\
    tkCancelRepeat\n\
}",
"bind Text <Control-1> {\n\
    %q mark set insert @%x,%y\n\
}",
"bind Text <ButtonRelease-2> {\n\
    if {!$tkPriv(mouseMoved) || $tk_strictMotif} {\n\
	tkTextPaste %W %x %y\n\
    }\n\
}",
"bind Text <Left> {\n\
    tkTextSetCursor %W insert-1c\n\
}",
"bind Text <Right> {\n\
    tkTextSetCursor %W insert+1c\n\
}",
"bind Text <Up> {\n\
    tkTextSetCursor %W [tkTextUpDownLine %W -1]\n\
}",
"bind Text <Down> {\n\
    tkTextSetCursor %W [tkTextUpDownLine %W 1]\n\
}",
"bind Text <Shift-Left> {\n\
    tkTextKeySelect %W [%q index {insert - 1c}]\n\
}",
"bind Text <Shift-Right> {\n\
    tkTextKeySelect %W [%q index {insert + 1c}]\n\
}",
"bind Text <Shift-Up> {\n\
    tkTextKeySelect %W [tkTextUpDownLine %W -1]\n\
}",
"bind Text <Shift-Down> {\n\
    tkTextKeySelect %W [tkTextUpDownLine %W 1]\n\
}",
"bind Text <Control-Left> {\n\
    tkTextSetCursor %W [%q index {insert - 1c wordstart}]\n\
}",
"bind Text <Control-Right> {\n\
    tkTextSetCursor %W [%q index {insert wordend}]\n\
}",
"bind Text <Control-Up> {\n\
    tkTextSetCursor %W [tkTextPrevPara %W insert]\n\
}",
"bind Text <Control-Down> {\n\
    tkTextSetCursor %W [tkTextNextPara %W insert]\n\
}",
"bind Text <Shift-Control-Left> {\n\
    tkTextKeySelect %W [%q index {insert - 1c wordstart}]\n\
}",
"bind Text <Shift-Control-Right> {\n\
    tkTextKeySelect %W [%q index {insert wordend}]\n\
}",
"bind Text <Shift-Control-Up> {\n\
    tkTextKeySelect %W [tkTextPrevPara %W insert]\n\
}",
"bind Text <Shift-Control-Down> {\n\
    tkTextKeySelect %W [tkTextNextPara %W insert]\n\
}",
"bind Text <Prior> {\n\
    tkTextSetCursor %W [tkTextScrollPages %W -1]\n\
}",
"bind Text <Shift-Prior> {\n\
    tkTextKeySelect %W [tkTextScrollPages %W -1]\n\
}",
"bind Text <Next> {\n\
    tkTextSetCursor %W [tkTextScrollPages %W 1]\n\
}",
"bind Text <Shift-Next> {\n\
    tkTextKeySelect %W [tkTextScrollPages %W 1]\n\
}",
"bind Text <Control-Prior> {\n\
    %q xview scroll -1 page\n\
}",
"bind Text <Control-Next> {\n\
    %q xview scroll 1 page\n\
}",
"bind Text <Home> {\n\
    tkTextSetCursor %W {insert linestart}\n\
}",
"bind Text <Shift-Home> {\n\
    tkTextKeySelect %W {insert linestart}\n\
}",
"bind Text <End> {\n\
    tkTextSetCursor %W {insert lineend}\n\
}",
"bind Text <Shift-End> {\n\
    tkTextKeySelect %W {insert lineend}\n\
}",
"bind Text <Control-Home> {\n\
    tkTextSetCursor %W 1.0\n\
}",
"bind Text <Control-Shift-Home> {\n\
    tkTextKeySelect %W 1.0\n\
}",
"bind Text <Control-End> {\n\
    tkTextSetCursor %W {end - 1 char}\n\
}",
"bind Text <Control-Shift-End> {\n\
    tkTextKeySelect %W {end - 1 char}\n\
}",
"bind Text <Tab> {\n\
    tkTextInsert %W \\t\n\
    focus %W\n\
    break\n\
}",
"bind Text <Shift-Tab> {\n\
    # Needed only to keep <Tab> binding from triggering;  doesn't\n\
    # have to actually do anything.\n\
}",
"bind Text <Control-Tab> {\n\
    focus [tk_focusNext %W]\n\
}",
"bind Text <Control-Shift-Tab> {\n\
    focus [tk_focusPrev %W]\n\
}",
"bind Text <Control-i> {\n\
    tkTextInsert %W \\t\n\
}",
"bind Text <Return> {\n\
    tkTextInsert %W \\n\n\
}",
"bind Text <Delete> {\n\
    if {[%q tag nextrange sel 1.0 end] != \"\"} {\n\
	%q delete sel.first sel.last\n\
    } else {\n\
	%q delete insert\n\
	%q see insert\n\
    }\n\
}",
"bind Text <BackSpace> {\n\
    if {[%q tag nextrange sel 1.0 end] != \"\"} {\n\
	%q delete sel.first sel.last\n\
    } elseif [%q compare insert != 1.0] {\n\
	%q delete insert-1c\n\
	%q see insert\n\
    }\n\
}",
"bind Text <Control-space> {\n\
    %q mark set anchor insert\n\
}",
"bind Text <Select> {\n\
    %q mark set anchor insert\n\
}",
"bind Text <Control-Shift-space> {\n\
    set tkPriv(selectMode) char\n\
    tkTextKeyExtend %W insert\n\
}",
"bind Text <Shift-Select> {\n\
    set tkPriv(selectMode) char\n\
    tkTextKeyExtend %W insert\n\
}",
"bind Text <Control-slash> {\n\
    %q tag add sel 1.0 end\n\
}",
"bind Text <Control-backslash> {\n\
    %q tag remove sel 1.0 end\n\
}",
"tkTextClipboardKeysyms F16 F20 F18",
"bind Text <Insert> {\n\
    catch {tkTextInsert %W [selection get -displayof %W]}\n\
}",
"bind Text <KeyPress> {\n\
    tkTextInsert %W %A\n\
}",
"bind Text <Alt-KeyPress> {# nothing }",
"bind Text <Meta-KeyPress> {# nothing}",
"bind Text <Control-KeyPress> {# nothing}",
"bind Text <Escape> {# nothing}",
"bind Text <KP_Enter> {# nothing}",
"bind Text <Control-a> {\n\
    if !$tk_strictMotif {\n\
	tkTextSetCursor %W {insert linestart}\n\
    }\n\
}",
"bind Text <Control-b> {\n\
    if !$tk_strictMotif {\n\
	tkTextSetCursor %W insert-1c\n\
    }\n\
}",
"bind Text <Control-d> {\n\
    if !$tk_strictMotif {\n\
	%q delete insert\n\
    }\n\
}",
"bind Text <Control-e> {\n\
    if !$tk_strictMotif {\n\
	tkTextSetCursor %W {insert lineend}\n\
    }\n\
}",
"bind Text <Control-f> {\n\
    if !$tk_strictMotif {\n\
	tkTextSetCursor %W insert+1c\n\
    }\n\
}",
"bind Text <Control-k> {\n\
    if !$tk_strictMotif {\n\
	if [%q compare insert == {insert lineend}] {\n\
	    %q delete insert\n\
	} else {\n\
	    %q delete insert {insert lineend}\n\
	}\n\
    }\n\
}",
"bind Text <Control-n> {\n\
    if !$tk_strictMotif {\n\
	tkTextSetCursor %W [tkTextUpDownLine %W 1]\n\
    }\n\
}",
"bind Text <Control-o> {\n\
    if !$tk_strictMotif {\n\
	%q insert insert \\n\n\
	%q mark set insert insert-1c\n\
    }\n\
}",
"bind Text <Control-p> {\n\
    if !$tk_strictMotif {\n\
	tkTextSetCursor %W [tkTextUpDownLine %W -1]\n\
    }\n\
}",
"bind Text <Control-t> {\n\
    if !$tk_strictMotif {\n\
	tkTextTranspose %W\n\
    }\n\
}",
"bind Text <Control-v> {\n\
    if !$tk_strictMotif {\n\
	tkTextScrollPages %W 1\n\
    }\n\
}",
"bind Text <Meta-b> {\n\
    if !$tk_strictMotif {\n\
	tkTextSetCursor %W {insert - 1c wordstart}\n\
    }\n\
}",
"bind Text <Meta-d> {\n\
    if !$tk_strictMotif {\n\
	%q delete insert {insert wordend}\n\
    }\n\
}",
"bind Text <Meta-f> {\n\
    if !$tk_strictMotif {\n\
	tkTextSetCursor %W {insert wordend}\n\
    }\n\
}",
"bind Text <Meta-less> {\n\
    if !$tk_strictMotif {\n\
	tkTextSetCursor %W 1.0\n\
    }\n\
}",
"bind Text <Meta-greater> {\n\
    if !$tk_strictMotif {\n\
	tkTextSetCursor %W end-1c\n\
    }\n\
}",
"bind Text <Meta-BackSpace> {\n\
    if !$tk_strictMotif {\n\
	%q delete {insert -1c wordstart} insert\n\
    }\n\
}",
"bind Text <Meta-Delete> {\n\
    if !$tk_strictMotif {\n\
	%q delete {insert -1c wordstart} insert\n\
    }\n\
}",
"if !$tk_strictMotif {\n\
    tkTextClipboardKeysyms Meta-w Control-w Control-y\n\
}",
"bind Text <Control-h> {\n\
    if !$tk_strictMotif {\n\
	if [%q compare insert != 1.0] {\n\
	    %q delete insert-1c\n\
	    %q see insert\n\
	}\n\
    }\n\
}",
"bind Text <2> {\n\
    if !$tk_strictMotif {\n\
	%q scan mark %x %y\n\
	set tkPriv(x) %x\n\
	set tkPriv(y) %y\n\
	set tkPriv(mouseMoved) 0\n\
    }\n\
}",
"bind Text <B2-Motion> {\n\
    if !$tk_strictMotif {\n\
	if {(%x != $tkPriv(x)) || (%y != $tkPriv(y))} {\n\
	    set tkPriv(mouseMoved) 1\n\
	}\n\
	if $tkPriv(mouseMoved) {\n\
	    %q scan dragto %x %y\n\
	}\n\
    }\n\
}",
"set tkPriv(prevPos) {}",
"proc tkTextClosestGap {w x y} {\n\
    set q [winfo command $w]\n\
    set pos [$q index @$x,$y]\n\
    set bbox [$q bbox $pos]\n\
    if ![string compare $bbox \"\"] {\n\
	return $pos\n\
    }\n\
    if {($x - [lindex $bbox 0]) < ([lindex $bbox 2]/2)} {\n\
	return $pos\n\
    }\n\
    $q index \"$pos + 1 char\"\n\
}",
"proc tkTextButton1 {w x y} {\n\
    global tkPriv\n\
\n\
    set q [winfo command $w]\n\
    set tkPriv(selectMode) char\n\
    set tkPriv(mouseMoved) 0\n\
    set tkPriv(pressX) $x\n\
    $q mark set insert [tkTextClosestGap $w $x $y]\n\
    $q mark set anchor insert\n\
    if {[$q cget -state] == \"normal\"} {focus $w}\n\
}",
"proc tkTextSelectTo {w x y} {\n\
    global tkPriv\n\
\n\
    set q [winfo command $w]\n\
    set cur [tkTextClosestGap $w $x $y]\n\
    if [catch {$q index anchor}] {\n\
	$q mark set anchor $cur\n\
    }\n\
    set anchor [$q index anchor]\n\
    if {[$q compare $cur != $anchor] || (abs($tkPriv(pressX) - $x) >= 3)} {\n\
	set tkPriv(mouseMoved) 1\n\
    }\n\
    switch $tkPriv(selectMode) {\n\
	char {\n\
	    if [$q compare $cur < anchor] {\n\
		set first $cur\n\
		set last anchor\n\
	    } else {\n\
		set first anchor\n\
		set last $cur\n\
	    }\n\
	}\n\
	word {\n\
	    if [$q compare $cur < anchor] {\n\
		set first [$q index \"$cur wordstart\"]\n\
		set last [$q index \"anchor - 1c wordend\"]\n\
	    } else {\n\
		set first [$q index \"anchor wordstart\"]\n\
		set last [$q index \"$cur -1c wordend\"]\n\
	    }\n\
	}\n\
	line {\n\
	    if [$q compare $cur < anchor] {\n\
		set first [$q index \"$cur linestart\"]\n\
		set last [$q index \"anchor - 1c lineend + 1c\"]\n\
	    } else {\n\
		set first [$q index \"anchor linestart\"]\n\
		set last [$q index \"$cur lineend + 1c\"]\n\
	    }\n\
	}\n\
    }\n\
    if {$tkPriv(mouseMoved) || ($tkPriv(selectMode) != \"char\")} {\n\
	$q tag remove sel 0.0 $first\n\
	$q tag add sel $first $last\n\
	$q tag remove sel $last end\n\
	update idletasks\n\
    }\n\
}",
"proc tkTextKeyExtend {w index} {\n\
    global tkPriv\n\
\n\
    set q [winfo command $w]\n\
    set cur [$q index $index]\n\
    if [catch {$q index anchor}] {\n\
	$q mark set anchor $cur\n\
    }\n\
    set anchor [$q index anchor]\n\
    if [$q compare $cur < anchor] {\n\
	set first $cur\n\
	set last anchor\n\
    } else {\n\
	set first anchor\n\
	set last $cur\n\
    }\n\
    $q tag remove sel 0.0 $first\n\
    $q tag add sel $first $last\n\
    $q tag remove sel $last end\n\
}",
"proc tkTextPaste {w x y} {\n\
    set q [winfo command $w]\n\
    $q mark set insert [tkTextClosestGap $w $x $y]\n\
    catch {$q insert insert [selection get -displayof $w]}\n\
    if {[$q cget -state] == \"normal\"} {focus $w}\n\
}",
"proc tkTextAutoScan {w} {\n\
    global tkPriv\n\
    if {![winfo exists $w]} return\n\
    set q [winfo command $w]\n\
    if {$tkPriv(y) >= [winfo height $w]} {\n\
	$q yview scroll 2 units\n\
    } elseif {$tkPriv(y) < 0} {\n\
	$q yview scroll -2 units\n\
    } elseif {$tkPriv(x) >= [winfo width $w]} {\n\
	$q xview scroll 2 units\n\
    } elseif {$tkPriv(x) < 0} {\n\
	$q xview scroll -2 units\n\
    } else {\n\
	return\n\
    }\n\
    tkTextSelectTo $w $tkPriv(x) $tkPriv(y)\n\
    set tkPriv(afterId) [after 50 tkTextAutoScan $w]\n\
}",
"proc tkTextSetCursor {w pos} {\n\
    global tkPriv\n\
\n\
    set q [winfo command $w]\n\
    if [$q compare $pos == end] {\n\
	set pos {end - 1 chars}\n\
    }\n\
    $q mark set insert $pos\n\
    $q tag remove sel 1.0 end\n\
    $q see insert\n\
}",
"proc tkTextKeySelect {w new} {\n\
    global tkPriv\n\
\n\
    set q [winfo command $w]\n\
    if {[$q tag nextrange sel 1.0 end] == \"\"} {\n\
	if [$q compare $new < insert] {\n\
	    $q tag add sel $new insert\n\
	} else {\n\
	    $q tag add sel insert $new\n\
	}\n\
	$q mark set anchor insert\n\
    } else {\n\
	if [$q compare $new < anchor] {\n\
	    set first $new\n\
	    set last anchor\n\
	} else {\n\
	    set first anchor\n\
	    set last $new\n\
	}\n\
	$q tag remove sel 1.0 $first\n\
	$q tag add sel $first $last\n\
	$q tag remove sel $last end\n\
    }\n\
    $q mark set insert $new\n\
    $q see insert\n\
    update idletasks\n\
}",
"proc tkTextResetAnchor {w index} {\n\
    global tkPriv\n\
\n\
    set q [winfo command $w]\n\
    if {[$q tag ranges sel] == \"\"} {\n\
	$q mark set anchor $index\n\
	return\n\
    }\n\
    set a [$q index $index]\n\
    set b [$q index sel.first]\n\
    set c [$q index sel.last]\n\
    if [$q compare $a < $b] {\n\
	$q mark set anchor sel.last\n\
	return\n\
    }\n\
    if [$q compare $a > $c] {\n\
	$q mark set anchor sel.first\n\
	return\n\
    }\n\
    scan $a \"%d.%d\" lineA chA\n\
    scan $b \"%d.%d\" lineB chB\n\
    scan $c \"%d.%d\" lineC chC\n\
    if {$lineB < $lineC+2} {\n\
	set total [string length [$q get $b $c]]\n\
	if {$total <= 2} {\n\
	    return\n\
	}\n\
	if {[string length [$q get $b $a]] < ($total/2)} {\n\
	    $q mark set anchor sel.last\n\
	} else {\n\
	    $q mark set anchor sel.first\n\
	}\n\
	return\n\
    }\n\
    if {($lineA-$lineB) < ($lineC-$lineA)} {\n\
	$q mark set anchor sel.last\n\
    } else {\n\
	$q mark set anchor sel.first\n\
    }\n\
}",
"proc tkTextInsert {w s} {\n\
    set q [winfo command $w]\n\
    if {($s == \"\") || ([$q cget -state] == \"disabled\")} {\n\
	return\n\
    }\n\
    catch {\n\
	if {[$q compare sel.first <= insert]\n\
		&& [$q compare sel.last >= insert]} {\n\
	    $q delete sel.first sel.last\n\
	}\n\
    }\n\
    $q insert insert $s\n\
    $q see insert\n\
}",
"proc tkTextUpDownLine {w n} {\n\
    global tkPriv\n\
\n\
    set q [winfo command $w]\n\
    set i [$q index insert]\n\
    scan $i \"%d.%d\" line char\n\
    if {[string compare $tkPriv(prevPos) $i] != 0} {\n\
	set tkPriv(char) $char\n\
    }\n\
    set new [$q index [expr $line + $n].$tkPriv(char)]\n\
    if {[$q compare $new == end] || [$q compare $new == \"insert linestart\"]} {\n\
	set new $i\n\
    }\n\
    set tkPriv(prevPos) $new\n\
    return $new\n\
}",
"proc tkTextPrevPara {w pos} {\n\
    set q [winfo command $w]\n\
    set pos [$q index \"$pos linestart\"]\n\
    while 1 {\n\
	if {(([$q get \"$pos - 1 line\"] == \"\\n\") && ([$q get $pos] != \"\\n\"))\n\
		|| ($pos == \"1.0\")} {\n\
	    if [regexp -indices {^[ 	]+(.)} [$q get $pos \"$pos lineend\"] \\\n\
		    dummy index] {\n\
		set pos [$q index \"$pos + [lindex $index 0] chars\"]\n\
	    }\n\
	    if {[$q compare $pos != insert] || ($pos == \"1.0\")} {\n\
		return $pos\n\
	    }\n\
	}\n\
	set pos [$q index \"$pos - 1 line\"]\n\
    }\n\
}",
"proc tkTextNextPara {w start} {\n\
    set q [winfo command $w]\n\
    set pos [$q index \"$start linestart + 1 line\"]\n\
    while {[$q get $pos] != \"\\n\"} {\n\
	if [$q compare $pos == end] {\n\
	    return [$q index \"end - 1c\"]\n\
	}\n\
	set pos [$q index \"$pos + 1 line\"]\n\
    }\n\
    while {[$q get $pos] == \"\\n\"} {\n\
	set pos [$q index \"$pos + 1 line\"]\n\
	if [$q compare $pos == end] {\n\
	    return [$q index \"end - 1c\"]\n\
	}\n\
    }\n\
    if [regexp -indices {^[ 	]+(.)} [$q get $pos \"$pos lineend\"] \\\n\
	    dummy index] {\n\
	return [$q index \"$pos + [lindex $index 0] chars\"]\n\
    }\n\
    return $pos\n\
}",
"proc tkTextScrollPages {w count} {\n\
    set q [winfo command $w]\n\
    set bbox [$q bbox insert]\n\
    $q yview scroll $count pages\n\
    if {$bbox == \"\"} {\n\
	return [$q index @[expr [winfo height $w]/2],0]\n\
    }\n\
    return [$q index @[lindex $bbox 0],[lindex $bbox 1]]\n\
}",
"proc tkTextTranspose w {\n\
    set q [winfo command $w]\n\
    set pos insert\n\
    if [$q compare $pos != \"$pos lineend\"] {\n\
	set pos [$q index \"$pos + 1 char\"]\n\
    }\n\
    set new [$q get \"$pos - 1 char\"][$q get  \"$pos - 2 char\"]\n\
    if [$q compare \"$pos - 1 char\" == 1.0] {\n\
	return\n\
    }\n\
    $q delete \"$pos - 2 char\" $pos\n\
    $q insert insert $new\n\
    $q see insert\n\
}",
"proc tk_textCopy w {\n\
    if {[selection own -displayof $w] == \"$w\"} {\n\
	clipboard clear -displayof $w\n\
	catch {\n\
	    clipboard append -displayof $w [selection get -displayof $w]\n\
	}\n\
    }\n\
}",
"proc tk_textCut w {\n\
    set q [winfo command $w]\n\
    if {[selection own -displayof $w] == \"$w\"} {\n\
	clipboard clear -displayof $w\n\
	catch {\n\
	    clipboard append -displayof $w [selection get -displayof $w]\n\
	    $q delete sel.first sel.last\n\
	}\n\
    }\n\
}",
"proc tk_textPaste w {\n\
    set q [winfo command $w]\n\
    catch {\n\
	$q insert insert [selection get -displayof $w \\\n\
		-selection CLIPBOARD]\n\
    }\n\
}",
"bind all <Tab> {focus [tk_focusNext %W]}",
"bind all <Shift-Tab> {focus [tk_focusPrev %W]}",
"proc tkCancelRepeat {} {\n\
    global tkPriv\n\
    after cancel $tkPriv(afterId)\n\
    set tkPriv(afterId) {}\n\
}",
