'\"
'\" Copyright (c) 1995 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) labeledwidget.n 1.21 94/12/17 16:04:44
'/" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .HS name section [date [version]]
'\"	Replacement for .TH in other man pages.  See below for valid
'\"	section names.
'\"
'\" .AP type name in/out [indent]
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS [type [name]]
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .VS
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" @(#) man.macros 1.1 94/08/09 13:07:19
.\"
'\"	# Heading for Tcl/Tk man pages
.de HS
.ds ^3 \\0
.if !"\\$3"" .ds ^3 \\$3
.if '\\$2'cmds'      .TH "\\$1" 1 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'lib'       .TH "\\$1" 3 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'ncmds'     .TH "\\$1" n "\\*(^3" "\\$4" "\\$5"
.if '\\$2'tcl'       .TH "\\$1" n "\\*(^3"  Tcl   "Tcl Built-In Commands"
.if '\\$2'tk'        .TH "\\$1" n "\\*(^3"  Tk    "Tk Commands"
.if '\\$2'tclc'      .TH "\\$1" 3 "\\*(^3"  Tcl   "Tcl Library Procedures"
.if '\\$2'tkc'       .TH "\\$1" 3 "\\*(^3"  Tk    "Tk Library Procedures"
.if '\\$2'tclcmds'   .TH "\\$1" 1 "\\*(^3"  Tk    "Tcl Applications"
.if '\\$2'tkcmds'    .TH "\\$1" 1 "\\*(^3"  Tk    "Tk Applications"
.if '\\$2'iwid'      .TH "\\$1" 1 "\\*(^3"  Tk    "[incr Widgets]"
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.HS labeledwidget iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
labeledwidget \- Create and manipulate a labeled widget
.SH SYNOPSIS
\fBlabeledwidget\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Widget <- labeledwidget
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbackground\fR	\fBcursor\fR	\fBforeground\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBlabelBitmap\fR
Class:	\fBBitmap\fR
Command-Line Switch:	\fB-labelbitmap\fR
.fi
.IP
Specifies a bitmap to display in the widget, in any of the forms 
acceptable to \fBTk_GetBitmap\fR.  This option overrides the \fIlabeltext\fR
option.
.LP
.nf
Name:	\fBlabelFont\fR
Class:	\fBFont\fR
Command-Line Switch:	\fB-labelfont\fR
.fi
.IP
Specifies the font to be used for the label.
.LP
.nf
Name:	\fBlabelImage\fR
Class:	\fBImage\fR
Command-Line Switch:	\fB-labelimage\fR
.fi
.IP
Specifies a image to be used as the label. The image may be any of the
values created by the \fBimage create\fR command.  This option overrides
both the \fIlabelbitmap\fR and \fIlabeletext\fR options.
.LP
.nf
Name:	\fBlabelMargin\fR
Class:	\fBMargin\fR
Command-Line Switch:	\fB-labelmargin\fR
.fi
.IP
Specifies the distance between the childsite and label in any of the forms
acceptable to \fBTk_GetPixels\fR.  The default is 1 pixel.
.LP
.nf
Name:	\fBlabelPos\fR
Class:	\fBPosition\fR
Command-Line Switch:	\fB-labelpos\fR
.fi
.IP
Specifies the position of the label along the side of the childsite: \fBn\fR, 
\fBne\fR, \fBe\fR, \fBse\fR, \fBs\fR, \fBsw\fR, \fBw\fR, or \fBnw\fR.  The
default is w.
.LP
.nf
Name:	\fBlabelText\fR
Class:	\fBText\fR
Command-Line Switch:	\fB-labeltext\fR
.fi
.IP
Specifies the text of the label around the childsite.
.LP
.nf
Name:	\fBlabelVariable\fR
Class:	\fBVariable\fR
Command-Line Switch:	\fB-labelvariable\fR
.fi
.IP
Specifies the text variable of the label around the childsite.
.LP
.BE

.SH DESCRIPTION
.PP
The \fBlabeledwidget\fR command creates a labeled widget which contains 
a label and child site.  The child site is a frame 
which can filled with any widget via a derived class or though the use 
of the childsite method.  This class
was designed to be a general purpose base class for supporting the 
combination of label widget and a childsite.  The options include the
ability to position the label around the childsite widget, modify the
font and margin, and control the display of the labels.

.SH "METHODS"
.PP
The \fBlabeledwidget\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for labeledwidget widgets:
.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBchildsite\fR
Return the path name of the child site.
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBlabeledwidget\fR
command.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBlabeledwidget\fR
command.

.SH "STATIC METHODS"
.TP
\fBLabeledwidget::alignlabels\fR \fIwidget\fR ?\fIwidget ...\fR?
The alignlabels procedure takes a list of widgets derived from
the Labeledwidget class and uses the label margin to make each widget
have the same total space for the combination of label and margin.  The
net effect is to left align the labels.  Generally, this method is only 
useful with a label position of w, which is the default.

.SH "COMPONENTS"
.LP
.nf
Name:	\fBlabel\fR
Class:	\fBlabel\fR
.fi
.IP
The label component provides the label for the labeled widget.  See the 
"label" widget manual entry for details on the label component item.
.LP
.nf
Name:	\fBlwchildsite\fR
Class:	\fBframe\fR
.fi
.IP
The lwchildsite component is the user child site for the labeled widget.  See 
the "frame" widget manual entry for details on the lwchildsite component item.
.fi

.SH EXAMPLE
.IP
The labeledwidget was primarily meant to be a base class.  The
ScrolledListBox and EntryField are good examples of derived
classes of the labeledwidget class.  In order to provide equal
support for composite classes, the 'childsite' methods also exists.
The following is an example of 'childsite' method usage.
.LP
.DS
 labeledwidget .lw -labeltext "Canvas Widget" -labelpos s
 pack .lw -fill both -expand yes -padx 10 -pady 10

 set cw [canvas [.lw childsite].c -relief raised -width 200 -height 200]
 pack $cw -padx 10 -pady 10
.DE
.SH AUTHOR
Mark L. Ulferts
.SH KEYWORDS
labeledwidget, widget
