'\"
'\" Copyright (c) 1995 AT&T Bell Laboratories
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" $Id: import.n,v 1.1.1.1 1996/09/10 06:54:36 karl Exp $
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  If an argument is present, then a line break is
'\"	forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" SCCS: @(#) man.macros 1.8 96/02/15 20:02:24
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$1"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH import n "" Tcl "Tcl With Namespaces"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
import \- change the "import" list for a namespace
.SH SYNOPSIS
\fBimport \fIoption\fR ?\fIarg arg ...\fR?
.BE

.SH DESCRIPTION
.PP
The \fBimport\fR command is used to query or modify the import
list for the current namespace context.  Command, variable and
namespace names are sought first in the current namespace context,
then in all imported namespaces.  This means that commands/variables
can be referenced in an imported namespace without the usual
namespace qualifiers.  When a namespace is added to the import
list, it acts as if it were a part of the namespace that imports
it.
.PP
By default, each namespace imports its parent.  This allows commands
and variables at the global scope to be accessed transparently in
child namespaces.  Frequently-used libraries can also be added to
the import list, but it is a good idea to import namespaces sparingly.
If each namespace imported all of the others, there would be very
little advantage to using namespaces.
.PP
By default, namespaces are imported in a "public" mode.  This means
that public commands/variables can be accessed transparently, but
protected and private elements remain hidden.  Namespaces can also
be imported in a "protected" mode.  This means that public \fIand\fR
protected commands/variables can be accessed transparently, but
private elements remain hidden.  There is no way to import in a
"private" mode, so private elements always remain hidden from
other namespaces.
.PP
The \fIoption\fR argument determines what action is carried out
by the command.  The legal \fIoptions\fR (which may be abbreviated)
are:
.TP
\fBimport add \fIname\fR ?\fIname...\fR? ?\fB-\fIwhere \fIpos...\fR?
Adds one or more namespace \fIname\fR references to the import
list in the current namespace context.  Each \fIname\fR reference
may be a namespace name, or a list with two elements:  the first
element is the namespace name, and the second is the import
protection level, either "public" or "protected".
.sp
.RS
The \fB-\fIwhere\fR flag can be used to specify where the list
of \fIname\fR's should be added in the existing import list:
.TP
\fB-after \fIpos\fR ?\fIpos...\fR?
Namespace \fIname\fR's are inserted after the position of namespace
\fIpos\fR on the list.  If more than one \fIpos\fR namespace is
specified, the \fIname\fR's are inserted after the \fIpos\fR
nearest the end of the list.
.TP
\fB-before \fIpos\fR ?\fIpos...\fR?
Namespace \fIname\fR's are inserted before the position of namespace
\fIpos\fR on the list.  If more than one \fIpos\fR namespace is
specified, the \fIname\fR's are inserted before the \fIpos\fR
nearest the start of the list.
.RE
.TP
\fBimport all \fR?\fIname\fR?
Returns the namespace search path used for command/variable resolution
in namespace \fIname\fR, or in the current namespace context if
\fIname\fR is not specified.  This is the list of namespaces found by
starting at the target namespace, and following its tree of import
references.  Each element on the return list is itself a list containing
a namespace name and its import protection level (public or protected).
.TP
\fBimport list \fR?\fIimportList\fR?
Returns the import list in the current namespace context.  Each
element on the return list is itself a list containing a namespace
name and its import protection level (public or protected).
If a new \fIimportList\fR is specified, then the import list is set
to this.  The elements of \fIimportList\fR can be simple namespace
names or two-element lists with a namespace name and its import
protection level.
.TP
\fBimport remove \fIname\fR ?\fIname...\fR?
Removes one or more namespace \fIname\fR's from the import list
in the current namespace context.  Each \fIname\fR reference
can be simple namespace name or a two-element list with a
namespace name and its import protection level.

.SH KEYWORDS
namespace, import, private, protected, public
