#
# NeoScript - Server Side Programming based on Safe Tcl
#
# Copyright (C) NeoSoft, All Rights Reserved.  See NeoWebScript LICENSE
# files with this distribution for conditions on use and redistribution.
#
# These procs are loaded into safe interpreters
#
# $Id: client.tcl,v 1.3 1997/01/14 19:49:32 kunkee Exp $
#

# proc to import key value pairs of the form "-color blue"
# into an array in the caller's context.
#
# and dialog box thingie that uses it
#
# i am really missing incr tcl
#
#
#neo_dialog -text "This is an alert mesesage... or something."
#
#neo_dialog -text "This is another alert message."
#

proc import_keyvalue_pairs {arrayName string} {
    upvar $arrayName array

    set len [llength $string]
    if {$len % 2 != 0} {
        error "unmatched key-value pair"
    }

    for {set i 0} {$i < $len} {incr i 2} {
        set key [lindex $string $i]
        if {[string index $key 0] != "-"} {
            error "key $key of key-value pairs doesn't start with a dash"
        }
        set array([string range $key 1 end]) [lindex $string [expr $i + 1]]
    }
}

proc emit_standard_yahoo_link {} {
    html {<a href="http://www.yahoo.com"><img src="http://www.yahoo.com/images/recip.gif" alt="Yahoo!" border=0></a>}
}

proc emit_standard_magellan_search_link {} {
    html {<form method=GET action="http://www.mckinley.com/extsearch.cgi">
<IMG SRC="http://images.mckinley.com/img/type.gif" ALIGN=MIDDLE>
<B>Search for:  </B> <input type=text name=query size=30 value="">
<INPUT type=submit value="Search">
</form>}
}

proc search_neosoft {} {
	   html "<form method=post action=/cgi-bin/neowais-neosoft-search>\n"
	   html "<input type=text name=keywords width=20>\n"
	   html "<input type=hidden name=waisdir value=/usr/local/etc/httpd/htdocs/.index/NEOSOFT.src>\n"
	   html {<input type=submit value="Search NeoSoft!"}
	   html "\n"
	   html "</form>\n"
}

#
# convert an integer-seconds-since-1970 click value to
# RFC850 format, with the additional requirement that it be GMT only
# because that's the way netscape decided to do it.
#
proc neo_clock_to_rfc850_gmt {clock} {
    return [clock format $clock -format "%a, %d-%b-%y %T GMT" -gmt 1]
}

#
# Create a cookie (send a browser a little message that you'll get
# back when they retrieve pages.)
#
# neo_make_cookie cookieName cookieValue [-days expireInDays]
#    [-hours expireInHours] [-minutes expireInMinutes]
#    [-path uriPathCookieAppliesTo]
#    [-secure 1|0]
#
proc neo_make_cookie {name value args} {
    import_keyvalue_pairs params $args
    set cookie "<meta http-equiv=\"Set-Cookie\" content=\"$name=$value"

    set expiresIn 0
    if [info exists params(days)] {
	incr expiresIn [expr $params(days) * 86400]
    }

    if [info exists params(hours)] {
	incr expiresIn [expr $params(hours) * 3600]
    }

    if [info exists params(minutes)] {
	incr expiresIn [expr $params(minutes) * 60]
    }

    if {$expiresIn != 0} {
	append cookie "; expires=[neo_clock_to_rfc850_gmt [expr [clock seconds] + $expiresIn]]"
    }

   if [info exists params(path)] {
       append cookie "; path=$params(path)"
   }

   if [info exists params(domain)] {
       append cookie "; domain=$params(domain)"
   }

   if {[info exists params(secure)] && $params(secure) == 1} {
       append cookie "; secure"
   }
   append cookie "\">"
   return $cookie
}

#
# forms1 - neosoft forms1 manager for neoscript 
#

#
# this package allows you to define forms that will automatically
# fill in the values of the form elements with the contents of an array,
# where the names of the fields are fetched from correspondingly
# named elements of an array.
#
# If there is no corresponding element, a reasonable default
# value is set instead.  (Blank, in most cases.)
#

#
# set_array_defaults arrayName -key value -key value -key value
#
proc set_array_defaults {arrayName args} {
    upvar $arrayName array
    import_keyvalue_pairs array $args
}

#
# neo_form formName "form html parms"
#
proc neo_form {arrayName parms} {
    global neoFormDataName
    set neoFormDataName $arrayName

    html "<form $parms>"
}

#
# neo_form_field type name parms
#
# emit a form entry of
#
proc neo_form_field {type name {parms ""}} {
    global neoFormDataName
    upvar #0 $neoFormDataName data

    if ![info exists data($name)] {
	set data($name) ""
    }

    if ![string match *value=* [string tolower $parms]] {
	append parms " value=\"$data($name)\""
    }
    html "<input name=\"$name\" type=\"$type\" $parms>"
}

proc neo_form_radiobuttons {name parms values} {
    global neoFormDataName
    upvar #0 $neoFormDataName data
    if ![info exists data($name)] {
	set data($name) ""
    }
    set baseValue $data($name)

    foreach value $values {
	if {$baseValue == $value} {
	    set checked "checked"
	} else {
	    set checked ""
	}
	html "<input name=\"$name\" type=\"radio\" $parms value=\"$value\" $checked>$value"
    }
}

proc neo_form_select {name parms values} {
    global neoFormDataName
    upvar #0 $neoFormDataName data
    if ![info exists data($name)] {
	set data($name) ""
    }
    set baseValue $data($name)

    html "<select name=\"$name\" $parms>"

    foreach value $values {
	if {$baseValue == $value} {
	    set selected "selected"
	} else {
	    set selected ""
	}
	html "<option $selected>$value"
    }
    html "</select>"
}

proc neo_form_checkbox {name {parms ""}}  {
    global neoFormDataName
    upvar #0 $neoFormDataName data
    if ![info exists data($name)] {
	set data($name) "0"
    }

    if ![string match *value=* [string tolower $parms]] {
	append parms " value=\"$data($name)\""
    }
    html "<input name=\"$name\" type=\"checkbox\" $parms>"
}

proc neo_form_textarea {name {parms ""}} {
    global neoFormDataName
    upvar #0 $neoFormDataName data

    if ![info exists data($name)] {
	set data($name) ""
    }
    html "<textarea name=\"$name\" $parms>$data($name)</textarea>"
}

proc neo_form_submit {{text ""}} {
    if {$text == ""} {
	html "<input type=submit>"
    } else {
	html "<input type=submit value=\"$text\">"
    }
}

proc neo_form_reset {{text ""}} {
    if {$text == ""} {
	html "<input type=reset>"
    } else {
	html "<input type=reset value=\"$text\">"
    }
}

proc neo_form_end {} {
    html "</form>"
}
