#
# Copyright (C) NeoSoft, All Rights Reserved.  See NeoWebScript LICENSE
# files with this distribution for conditions on use and redistribution.
#
# NeoScript [TM] development source code
#
# Tcl file that, when debugging is true, gets sourced every time a webpage 
# is pulled up that contains Neoscript server-side code. 
#
# If debugging is false, the file is loaded in only once by the
# "mother thread".
#
# $Id: devel.tcl,v 1.7 1997/07/24 21:10:53 karl Exp $
#

proc dump_request_stack {} {
    if ![www_request_info req] {
        error "impossible?  www_request_info failed for current record"
    }
    html "Dump of request stack" h2
    html "Cazart!  Something went wrong and you get to see all this cool stuff!" b
    parray req

    foreach type "next prev main" {
        if {$req($type)} {
            for {set i 1} {[www_request_info $type $i nreq]} {incr i} { 
                html "$type $i" h2
                parray nreq
            }
        }
    }
}
 
proc SAFE_extend_client {safeInterp} {
    global clientLoadData

    if ![info exists clientLoadData] {
	global server

	set fp [open $server(SERVER_ROOT)/conf/client.tcl]
	set clientLoadData [read $fp]
	close $fp
    }
    $safeInterp eval $clientLoadData
}


#
# run the special code to setup whatever is loaded by the
# devel.tcl file.  It is expected that code in here that
# works will be migrated to init.tcl if it is found to be useful.
#
proc devel_setup {safeInterp} {
    $safeInterp alias load_extensions SAFE_extend_client $safeInterp
    SAFE_extend_client $safeInterp

    $safeInterp alias using_otcl using_otcl $safeInterp
    $safeInterp alias rootname file rootname
    install_header_procs $safeInterp
    $safeInterp alias loadlib SAFE_load $safeInterp
    $safeInterp alias set_header set_header
    $safeInterp alias neo_crypt neo_crypt


	$safeInterp alias persistent SAFE_persistent $safeInterp
	$safeInterp alias persistent SAFE_load_persistent $safeInterp
}

proc SAFE_du {} {
    global webpageOwnerName
    setup_data_access

    set first [cindex $webpageOwnerName 0]
    set path "/usr/ftp/pub/users/$first/$webpageOwnerName"
    set duFP [open "|/usr/bin/du $path" r]
 
    while {[gets $duFP line] > 0} {
        html $line
        html "<br>"
    }
    close $duFP
}



# assumes that Postgres is staticly linked
proc using_otcl {safeInterp} {
    global server
    load {} otcl $safeInterp
    $safeInterp eval {proc debug args { }; set in_emulator 0}
    $safeInterp eval [read_file $server(SERVER_ROOT)/conf/class.tcl]
}

# nph_set_header and nph_send_headers are used in nph-*
# files to send out headers.  Usage is:
#
# nph_set_header key value
# ...
# nph_send_headers

proc install_header_procs {safeInterp} {
$safeInterp eval {
proc nph-set-header {headerKey headerValue} {
    global headers
    set headers($headerKey) $headerValue
}

proc nph-send-headers {} {
    global headers webenv

    if ![info exists headers(Date)] {
	set headers(Date) [clock format [clock seconds]]
    }
    if ![info exists headers(Server)] {
	set headers(Server) $webenv(SERVER_SOFTWARE)
    }
    if ![info exists headers(Content-type)] {
	set headers(Content-type) text/html
    }
    html "HTTP/1.0 200 OK\n"
    html "Date: $headers(Date)\n"
    html "Server: $headers(Server)\n"
    html "Content-type: $headers(Content-type)\n"
    foreach key [array names headers] {
	if [lsearch {Date Server Content-type} $key]==-1 {
	    html "$key: $headers($key)\n"
	}
    }
    html "\n"
}
}
}

proc SAFE_load {safeInterp fileName packageName} {
    if [string first / $fileName]>=0 {
	error "load paths not allowed for untrusted interpreters"
    }
    global server
    load $server(SERVER_ROOT)/neoscript-lib/$fileName $packageName $safeInterp
}


# Functions to impliment the persistent command
#
# Called from C
proc snapshot_persistent {} {
}

proc load_persistent {} {
}

# Called from Tcl

proc SAFE_persistent {safeInterp varName {varValue ""}} {
	global persistentInit
	load_cookies

	if {![info exists cookies(neoPersistentData)] && $persistentInit != 1} {
		set keyseed "[clock seconds] [clock format [clock seconds]] [pid] [id] $safeInterp $varName $varValue"
		set key [md5 $keyseed]

		neo_make_cookie neoPersistentData $key -days 30 -path /
		set persistentInit 1
	} else {
		set key $cookies(neoPersistentData)
	}

	dbfetch persDB $key_v val
	if [info exists $val] {
		if {$varValue == ""} {
			uplevel #0 "set $varName $val"
		} else {
			set valName $valValue
			dbstore persDB $key_v valName
		}
	}

	dbfetch persDB $key_a array
	if [info exists array($varName)] {
		if {$varValue == ""} {
			uplevel #0 "array set $varName [array get array($varName)]"
		} else {
			set array($varName) [uplevel "array get $varName"]
			dbstore persDB $key_a array
		}
	}
}
