#
# NeoScript - Server Side Programming based on Safe Tcl
#
# Copyright (C) 1997 NeoSoft, All Rights Reserved.  See NeoWebScript LICENSE
# files with this distribution for conditions on use and redistribution.
#
# Helpful routines for interfacing with Postgres.
#
# $Id: postgres.tcl,v 1.1 1997/06/17 23:46:49 kunkee Exp $
#

#puts "Known packages: [package names]"
#puts "commands: [info commands pg_*]"
#puts "info loaded: [info loaded]"

set sqllog [open $server(SERVER_ROOT)/logs/sql_log "WRONLY APPEND CREAT"]

proc postgres_setup {safeInterp} {
    global NeoWebDirConf
    load {} Pg $safeInterp
    if {![info exists NeoWebDirConf(PostgresAny)] || $NeoWebDirConf(PostgresAny) == 0} {
	$safeInterp alias pg_connect SAFE_pg_connect $safeInterp
	$safeInterp alias pg_createdb SAFE_pg_createdb
	$safeInterp alias pg_log pg_log
	$safeInterp eval {
	    rename pg_exec __pg_exec
	    proc pg_exec args {
		set start [clock seconds]
		set err [catch {eval __pg_exec $args} result]
		set duration [expr [clock seconds] - $start]
		if $err {
		    global errorInfo
		    return -code error -errorInfo $errorInfo $result
		}
		catch {pg_log "$duration $args"}
		return $result
	    }
	}
    }
}

proc pg_log params {
    global sqllog webenv
    regsub {^/usr/ftp/(\./)?pub/users/[a-z]/} $webenv(SCRIPT_FILENAME) ~ path
    puts $sqllog "[clock format [clock seconds] -format "%D %T"] \
	$webenv(REMOTE_ADDR) $params $path"
    flush $sqllog
}

proc SAFE_pg_connect {safeInterp {databaseName {}} args} {
    global webpageOwnerName

    setup_data_access
    if {[lempty $databaseName] || $databaseName == $webpageOwnerName} {
      set databaseName $webpageOwnerName
    } else {
      set databaseName ${webpageOwnerName}__${databaseName}
    }
    set pgp_handle [eval pg_connect $databaseName $args]
    pg_log "pg_connect $databaseName"
    return [pg_handle $safeInterp $pgp_handle]
}

proc SAFE_pg_createdb {{databaseName {}}} {
    global webpageOwnerName

    setup_data_access
    if {[lempty $databaseName] || $databaseName == $webpageOwnerName} {
      set databaseName $webpageOwnerName
    } else {
      set databaseName ${webpageOwnerName}__${databaseName}
    }
    
    set sql_command "create database $databaseName;"
    set postgresFP [pg_connect template1]
    set result [pg_exec $postgresFP $sql_command]
    pg_disconnect $postgresFP
    pg_result $result -clear
    return
}


