proc dbdump {database {args ""}} {
	
	if [string match *-neowebscript* $args] {
		set args [lreplace $args [lsearch $args -neowebscript] [lsearch $args -neowebscript] {-neowebscript} {}]
	}
	if {$args != ""} {
		import_keyvalue_pairs data $args
	}

	if ![info exists data(pattern)] {set data(pattern) *}
	if ![info exists data(format)] {set data(format) parray}
	if ![info exists data(seperator)] {set data(seperator) ,}
	if ![info exists data(datafile)] {set data(datafile) remove}
	if {[info exists data(file)] && $data(datafile) == "remove"} {filerm data $data(file)}

	if [info exists data(file)] {set ofp [access_data_file $data(file)];seek $ofp 0 end}
    set keys ""
	foreach key [dbkeys $database *] {
		dbfetch $database $key array

		if [info exists data(file)] {
			if [info exists data(neowebscript)] {	
				if ![info exists num] {
					set num 1
					puts $ofp "#THIS FILE IS FORMATED FOR NEOSCRIPT DBIMPORT.  DO NOT REMOVE THIS COMMENT"
				}
				set line [list $key [array get array]]
				puts $ofp $line
				unset line
			} else {
				foreach elem [array names array] {
					append line "$array($elem)$data(seperator)"
				}
			puts $ofp "[crange $line 0 end-1]"	
			unset line
			unset array
			}
		}

		if [info exists data(format)] {
			if {$data(format) == "parray"} {
				html "\[$key\]"
				parray array
				unset array
			} elseif {$data(format) == "list"} {
				html "\[$key\]"
				foreach elem [array names array] {
					html "$elem=$array($elem), "
				}
				unset array
			} elseif {$data(format) == "delineated"} {
				if [info exists data(neowebscript)] {
					if ![info exists num2] {
						set num2 1
						html "#THIS FILE IS FORMATED FOR NEOSCRIPT DBIMPORT.  DO NOT REMOVE THIS COMMENT.\n"
					}
					set line [list $key [array get array]]
					html $line\n
					unset line
					unset array
				} else {
					foreach elem [array names array] {
						append line "$array($elem)$data(seperator)"
					}
					html "[crange $line 0 end-1]\n"
					unset line
					unset array
				}
			}
					
		}

    }

	if [info exists data(file)] {close $ofp}

    return
}

proc dbimport {file database args} {

	if [string match *-datafile* $args] {
		set args [lreplace $args [lsearch $args -datafile] [lsearch $args -datafile]]
		set ifp [access_data_file $file]
	} else {
		set ifp [open [pwd]/$file r]
	}

	import_keyvalue_pairs data $args
	set	n 0
	
	gets $ifp tmpline
	if {![string match "*NEOSCRIPT DBIMPORT*" $tmpline] && [info exists data(fields)]} {
		seek $ifp 0
		set haveFields 1
	} else {
		set data(fields) 0
	}

	if ![info exists data(seperator)] {set data(seperator) ,}
	if ![info exists data(fields)] {error "-fields not set";return 0}
	if ![info exists data(key)] {set data(key) numbers}
	if ![info exists data(db)] {set data(db) remove}
	if {$data(db) == "remove"} {filerm db $file}
	
	while {[gets $ifp line] != -1} {
		if ![info exists haveFields] {
			array set storage [lindex $line 1]
			set key [lindex $line 0]
			dbstore $file $key storage
			unset storage
			continue
		} else {
			set fields $data(fields)
		}
		incr n
		for {set i 0} {$i < [llength $fields]} {incr i} {
			if {[lindex $fields $i] != "key"} {
				set array([lindex $fields $i]) [lindex $line $i]
				if {[lindex $fields $i] == $data(key)} {
					set key [lindex $line $i]
				}
			} else {
				set id [lindex $line $i]
			}
		}

		if {[info exists data(key)] && $data(key) != "numbers"} {
			set id $key
		} elseif {[info exists id]} {
		} else {
			set id $n
		}

		dbstore $file $id array
	}	
    return
}
