#
# Manages db-style databases for DB authentication
#
#
proc manage_passwords {dbName command args} {
	switch $command {
		"add" {
			if {![llength $args] == 2} {
				html "Usage:  manage_passwords dbName add username password"
				return
			}
			
			set seed [format "%c%s" [expr {[clock seconds] % 26} + 97] [expr [clock seconds] % 9]]
			set hashedPass [neo_crypt [lindex $args 1] $seed]
			dbstore $dbName [lindex $args 0] $hashedPass -singleVar
		}
		"delete" {
			if {![llength $args] == 1} {
				html "Usage:  manage_passwords dbName delete key"
				return
			}

			dbdelkey $dbName [lindex $args 0]
		}
		"view" {
			if {![llength $args] == 0} {
				html "Usage:  manage_passwords dbName view ?pattern?"
				return
			}
			return [dbkeys $dbName]
		}
		default {
			html "Usage:  manage_passwords dbName command ?args?"
			return
		}
	}
}

