#!/bin/sh

NEOROOT=`pwd`

if test -z "`echo -n`"
then
   _ECHO="echo -n"
   _ENDECHO=""
else
   _ECHO="echo"
   _ENDECHO="\\c"
fi

echon ( ) {
   $_ECHO "$*$_ENDECHO"
}

if test ! -d $NEOROOT/httpd -o ! -f $NEOROOT/LICENSE.NeoWebScript
then
   echo This script must be run from the top-level directory after unpacking.
   exit 1
fi

cat << EOF
PLEASE NOTE: you should have Tcl built and installed before building
the NeoWebScript server.   Minimally, you need Tcl, TclX, and Neo, and
Gd.

EOF

SERVERROOT=$NEOROOT/httpd
cat << EOF
ServerRoot will be ${SERVERROOT}.  This is the directory which contains
the configuration directory, the log files, and other auxilliary information
needed by NeoWebScript and the Apache webserver.

EOF

sedflags="s%@SERVERROOT@%$SERVERROOT%"

DOCUMENTROOT=$SERVERROOT/htdocs
cat << EOF
The root directory of all of your documents is called the DocumentRoot.
By default, your DocumentRoot will be $DOCUMENTROOT.
This can be configured to a distinct directory if you wish.  You can
safely point to an existing DocumentRoot on your system.

EOF

ans=""
while test "$ans" != "y"
do
echon "Enter path to DocumentRoot (or hit return if $DOCUMENTROOT): "
read ans < /dev/tty
if test -n "$ans"
then
   DOCUMENTROOT="$ans"
fi
echo
echo "DocumentRoot will be $DOCUMENTROOT."
echon "Is this correct? (y/n) "
read ans < /dev/tty
done

if test ! -d $DOCUMENTROOT
then
   echon "$DOCUMENTROOT does not exist.  Should I create it? (y/n) "
   read ans < /dev/tty
   if test "$ans" = y
   then
      set -e
      mkdir -p $DOCUMENTROOT
      set +e
   fi
fi
if test $DOCUMENTROOT != $SERVERROOT/htdocs
then
      ln -s $SERVERROOT/httpd/htdocs/neowebscript $DOCUMENTROOT
      ln -s $SERVERROOT/httpd/htdocs/gifs $DOCUMENTROOT
      ln -s $SERVERROOT/httpd/htdocs/index.html $DOCUMENTROOT
fi

sedflags="$sedflags;s%@DOCUMENTROOT@%$DOCUMENTROOT%"

cat << EOF

The ServerAdmin directive should contain the email address of the
webserver administrator.
EOF

ans=""
while test "$ans" != "y"
do
echo
echo "Please enter the email address of the Web server administrator:"
read ans < /dev/tty
if test -n "$ans"
then
   SERVERADMIN="$ans"
fi
echo
echo "ServerAdmin will be $SERVERADMIN."
echon "Is this correct? (y/n) "
read ans < /dev/tty
done

sedflags="$sedflags;s%@SERVERADMIN@%$SERVERADMIN%"

cat << EOF

The Port directive determines which TCP port the webserver will listen
to.  The standard port is 80.  If you wish to make this an experimental
server on another port, choose a high number, such as 8080.
EOF

ans=""
while test "$ans" != "y"
do
SERVERPORT=80
echo
echo "Please enter the TCP port the webserver should use [$SERVERPORT]:"
read ans < /dev/tty
if test -n "$ans"
then
   SERVERPORT="$ans"
fi
echo
echo "Port will be $SERVERPORT."
echon "Is this correct? (y/n) "
read ans < /dev/tty
done

sedflags="$sedflags;s%@SERVERPORT@%$SERVERPORT%"

cat << EOF

The ServerName directive sets the server name to issue in response headers.
By default, this is taken from the hostname, `hostname`.  You should enter
a different name if you want to prefix "www." for example, or if your
system does not present a fully qualified host name.  In any case, if you
enter a name, it should exist in the DNS database, unless perhaps this is
a corporate server that will not be seen by others on the Internet.
EOF

ans=""
while test "$ans" != "y"
do
SERVERNAME="default"
echo
echo "Please enter the server name [$SERVERNAME]:"
read ans < /dev/tty
if test -n "$ans"
then
   SERVERNAME="$ans"
fi
echo
echo "ServerName will be $SERVERNAME."
echon "Is this correct? (y/n) "
read ans < /dev/tty
done
if test -z "$SERVERNAME" -o "$SERVERNAME" = default
then
   SERVERNAME=""
else
   SERVERNAME="ServerName $SERVERNAME"
fi

sedflags="$sedflags;s%@SERVERNAME@%$SERVERNAME%"


{
echo Entering $NEOROOT/httpd
cd $NEOROOT/httpd
if test ! -f neowebscript
then
    echo "Creating management script 'neowebscript' for system restart"
    sed -e "$sedflags" ../install/neowebscript.in > neowebscript
    chmod +x neowebscript
fi
if test ! -d logs
then
  echo Creating logs directory
  mkdir logs
  echo Setting ownership and permissions of logs to nobody:nobody 755
  chown nobody:nobody logs
  chmod 755 logs
else
  echo Logs directory already exists
fi
if test ! -d neoscript-data
then
  echo "Creating neoscript-data/{system,users}"
  mkdir neoscript-data
  mkdir neoscript-data/system neoscript-data/users
  echo Setting ownership and permissions of neoscript-data/system and neoscript-data/users to nobody:nobody 755
  chown nobody:nobody neoscript-data/system neoscript-data/users
  chmod 755 neoscript-data/system neoscript-data/users
else
  echo Neoscript-data directories already exist.
fi
if test ! -d bin
then
  echo "Creating httpd/bin and src/Makefile for webunpack and getpass"
  mkdir bin
fi
if test -s /usr/include/shadow.h
then
  sedflags="$sedflags;s%@SHADOW_FLAGS@%-DHAVE_SHADOW%"
fi
sed -e "$sedflags" $NEOROOT/src/Makefile.in > $NEOROOT/src/Makefile
cd conf
echo Entering httpd/conf
for f in access httpd srm
do
  if test ! -f $f.conf
  then
    echo Initializing $f.conf from $f.conf-dist
    sed -e "$sedflags" $f.conf-dist > $f.conf
  else
    echo $f.conf already exists
  fi
done
echo Leaving httpd/conf
echo Leaving httpd
}

{
# Fix up symbolic links in demo directory
#
echo Entering $DOCUMENTROOT/neowebscript/demos
cd $DOCUMENTROOT/neowebscript/demos
for f in lottery environment counter clock graffitiwall guestbook \
	emailform emailscript
do
   if test ! -s $f.txt
   then
      ln -s $f.html $f.txt
   fi
done
echo Leaving $DOCUMENTROOT/neowebscript/demos
}

{
# Copy some useful files and directories from Apache
#
echo Copying $NEOROOT/apache_1.2.0/icons
cp -R $NEOROOT/apache_1.2.0/icons $SERVERROOT
echo Creating symlinks to the Apache manual
ln -s $NEOROOT/apache_1.2.0/htdocs/manual $DOCUMENTROOT/apache_manual
}

#echo Installing startup script in /etc/init.d/neowebscript
#ln -s ../init.d/neowebscript /etc/rc3.d/S99neowebscript
#ln -s $NEOROOT/httpd/neowebscript /etc/init.d
#
#/etc/init.d/neowebscript start
