set g [gd create 100 100]
gd color new $g 255 255 255
random seed
set c1 [gd color new $g [random 256] [random 256] [random 256]]
set c2 [gd color new $g [random 256] [random 256] [random 256]]
gd fillrectangle $g $c1 25 25 75 75
set diam [expr int(sqrt(2*(50*50)))]
gd arc $g $c2 50 50 $diam  $diam  0 360
gd writeGIF $g $imageFile
gd destroy $g
return

/*
 * GD composite command:
 *
 * gd create <width> <height>
 * 	Return a handle to a new gdImage that is width X height.
 * gd createFromGIF <filehandle>
 * gd createFromGD <filehandle>
 * gd createFromXBM <filehandle>
 * 	Return a handle to a new gdImage created by reading a GIF
 * 	(resp. GD or XBM) image from the file open on filehandle.
 *
 * gd destroy <gdhandle>
 * 	Destroy the gdImage referred to by gdhandle.
 *
 * gd writeGIF <gdhandle> <filehandle>
 * gd writeGD  <gdhandle> <filehandle>
 * 	Write the image in gdhandle to filehandle as a GIF (resp. GD)
 * 	file.
 *
 * gd color new <gdhandle> <red> <green> <blue>
 * 	Allocate a new color with the given RGB values.  Return the color
 * 	index.  Returns -1 on failure.
 * gd color exact <gdhandle> <red> <green> <blue>
 * gd color closest <gdhandle> <red> <green> <blue>
 * 	Find a color in the image that exactly matches (resp., is closest to)
 * 	the given RGB color.  Returns the index (or -1 if no exact match).
 * gd color free <gdhandle> <index>
 * 	Free the color at the given index for reuse.
 * gd color transparent <gdhandle> <index>
 * 	Mark the color index as the transparent background color.
 * gd color get <gdhandle> [<index>]
 * 	Return the RGB value at <index>, or {} if it is not allocated.
 * 	If <index> is not specified, return a list of {index R G B} values
 * 	for all allocated colors.
 * gd color gettransparent <gdhandle>
 * 	Return the transparent color index.
 * 
 * gd brush <gdhandle> <brushhandle>
 * 	Set the brush image to be used for brushed lines.  Transparent
 * 	pixels in the brush will not change the image when the brush
 * 	is applied. 
 * gd style <gdhandle> <index> ...
 * 	Set the line style to the list of color indices.  This is interpreted
 * 	in one of two ways.  For a simple styled line, each color index is
 * 	applied to points along the line in turn.  The transparent index
 * 	value may be used to leave gaps in the line.  For a styled, brushed
 * 	line, a 0 (or the transparent index) means not to fill the pixel,
 * 	and a non-zero value means to apply the brush.
 * gd tile <gdhandle> <tilehandle>
 * 	Set the tile image to be used for tiled fills.  Transparent pixels in
 * 	the tile will not change the underlying image during tiling.
 * 
 * In all drawing functions, the color index is a number, or may be one of the
 * strings styled, brushed, tiled, \"styled brushed\" or \"brushed styled\".  
 * The style, brush, or tile currently in effect will be used.  Brushing and
 * styling apply to lines, tiling to filled areas.
 * 
 * gd set <gdhandle> <index> <x> <y>
 * 	Set the pixel at (x,y) to index.
 * gd line <gdhandle> <index> <x1> <y1> <x2> <y2>
 * 	Draw a line in color <index> from (x1,y1) to (x2,y2).
 * gd rectangle <gdhandle> <index> <x1> <y1> <x2> <y2>
 * gd fillrectangle <gdhandle> <index> <x1> <y1> <x2> <y2>
 * 	Draw the outline of (resp. fill) a rectangle in color <index>
 * 	with corners at (x1,y1) and (x2,y2).
 * gd arc <gdhandle> <index> <cx> <cy> <width> <height> <start> <end>
 * 	Draw an arc in color <index>, centered at (cx,cy) in a rectangle
 * 	width x height, starting at start degrees and ending at end degrees.
 *	start must be > end.
 * gd polygon <gdhandle> <index> <x1> <y1> ...
 * gd fillpolygon <gdhandle> <index> <x1> <y1> ...
 * 	Draw the outline of, or fill, a polygon specified by the x, y
 * 	coordinate list.  
 * 
 * gd fill <gdhandle> <index> <x> <y>
 * gd fill <gdhandle> <index> <x> <y> <borderindex>
 * 	Fill with color index, starting from (x,y) within a region
 * 	of pixels all the color of the pixel at (x,y) (resp., within a
 * 	border colored borderindex).
 *
 * gd size <gdhandle>
 * 	Returns a list {width height} of the image.
 *
 * gd fonts
 * 	Returns a list of available fonts: {fontname width height}
 *
 * gd text <gdhandle> <fontname> <index> <x> <y> <string>
 * gd textup <gdhandle> <fontname> <index> <x> <y> <string>
 * 	Draw text with font fontname, in color index, with upper left
 * 	corner at (x,y).  textup draws text rotated 90 degrees, running up.
 *
 * gd copy <desthandle> <srchandle> <destx> <desty> <srcx> <srcy> <w> <h>
 * gd copy <desthandle> <srchandle> <destx> <desty> <srcx> <srcy> \
 * 		<destw> <desth> <srcw> <srch>
 * 	Copy a subimage from srchandle(srcx, srcy) to
 * 	desthandle(destx, desty), size w x h.  Or, resize the subimage
 * 	in copying from srcw x srch to destw x desth.
 * 
 */

