#
# display_logo ?name (nws|neosoft|tcltk|tclpowered)?
#              ?-size AxB?
#              ?(img tag name/value attributes as keyvalue pairs)?
#
proc display_logo {args} {
    import_keyvalue_pairs data $args

    # just set some default values for args
    set def_dir "/nws-common/logos"

    # array of existing logos, should eventually be checked live
    # the first item in each list is the default pick, when read live
    # this must be set some other way.

    set logos(nws) "{267x92 167x42} 267x92 {http://www.neosoft.com/neowebscript/} {NeoWebScript}"
    set logos(neosoft) "{337x57 171x29 282x45} 337x57 {http://www.neosoft.com/} {NeoSoft, Inc.}"
    set logos(tcltk) "{68x100 43x64 120x181 354x520} 68x100 {http://www.scriptics.com/} {Tcl/Tk}"
    set logos(tclpowered) "{63x100 47x75 95x150 111x175 127x200} 63x100 {http://www.scriptics.com/} {Tcl Powered!}"

    if {[info exists data(name)]} {
        set name $data(name)
        unset data(name)
    } else {
        set name nws
    }

    if {[lempty [array names logos $name]]} {
        set output " $name is not a valid logo name, the allowable names are: "
        append output "[lsort [array names logos]] "
        return $output
    }

    if {[info exists data(size)]} {
        set size $data(size)
        unset data(size)
        if {[lempty [lmatch [lindex $logos($name) 0] $size]]} {
            set output " $size is not a valid size for logo $name, the valid "
            append output "sizes are [lsort [lindex $logos($name) 0]] "
            return $output
        }
    } else {
        set size [lindex $logos($name) 1]
    }

    lassign [split $size x] width height

    if {![info exists data(width)]} {set data(width) $width}
    if {![info exists data(border)]} {set data(border) 0}
    if {![info exists data(alt)]} {set data(alt) [lindex $logos($name) 3]}
    if {![info exists data(height)]} {set data(height) $height}
    if {[info exists data(href)]} {
        set href $data(href)
        unset data(href)
    } else {set href [lindex $logos($name) 2]}

    catch {unset data(src)}
    catch {unset data(usemap)}

    set image_tag "<img src=$def_dir/$name/$name$size.gif"  

    set arglist [array names data]
    loop x 0 [llength $arglist] 1 {
        set temp [lindex $arglist $x]
        append image_tag " $temp=\"$data($temp)\""        
    }

    if {[cequal $name nws] && [cequal $size 267x92]} {
        set maptop [expr round($height * .63)]  
        append image_tag " usemap=#nws_emit_logomap"
        return "
<map name=nws_emit_logomap>
<AREA SHAPE=\"RECT\" COORDS=\"0,0,$data(width),$maptop\" HREF=\"http://www.NeoSoft.com/neowebscript/index.html\">
<AREA SHAPE=\"RECT\" COORDS=\"0,[expr $maptop + 1],$data(width),$data(height)\" HREF=\"http://www.neosoft.com\">
</map>
$image_tag >\n"
    } else {
        return "\n<a href=$href>$image_tag></a>\n"
    }
    return ""
}
