proc nfile {args} {
    if {[llength $args] < 2 || [llength $args] > 5} {
	set usg "Usage: nfile ?-project? <command> <type> 
	    <?project:?file1> ?project:?file2?"
	return -code error $usg
    }

    set project 0
    set search [lsearch $args "-project"]
    if {$search > -1} {
	set args [lreplace $args $search $search]
	set project 1
    }

    lassign $args command type file1 file2

    set typeList {db data log}
    if {[lsearch $typeList $type] < 0} {
	return -code error "Illegal nfile type: $type"
    }

    set prefix file
    if $project {
	set prefix project
    }

    switch $command {
	copy {
	    ${prefix}cp $type $file1 $file2
	}

	delete {
	    ${prefix}rm $type $file1
	}

	move {
	    ${prefix}mv $type $file1 $file2
	}

	exists {
	    if $project {
		set result [project_exists $type $file1]
		return $result
	    }
	    file_exists $type $file1
	}

	list {
	    if [lempty $file1] {
		set file1 *
	    }
	    if $project {
		set result [list_projects $type $file1]
		return $result
	    }
	    list_files $type $file1
	}
    }
}
