#
# NeoWebScript - Server Side Programming based on Safe Tcl
#
# Copyright (C) NeoSoft, All Rights Reserved.  See NeoWebScript LICENSE
# files with this distribution for conditions on use and redistribution.
#
# $Id: neoform1.tcl,v 1.1.1.1 1999/03/31 20:53:26 damon Exp $
#
# forms1 - neosoft forms1 manager for neowebscript 
#

#
# this package allows you to define forms that will automatically
# fill in the values of the form elements with the contents of an array,
# where the names of the fields are fetched from correspondingly
# named elements of an array.
#
# If there is no corresponding element, a reasonable default
# value is set instead.  (Blank, in most cases.)
#

#
# neo_form formName "form html parms"
#
safe_proc neo_form {{arrayName {response}} {parms {}}} {
    global neoFormDataName webenv
    set neoFormDataName $arrayName

    if {$parms == {}} {
	set parms "method=post action=\"$webenv(DOCUMENT_NAME)\""
    }
    html "<form $parms>"
}

#
# neo_form_field type name parms
#
# emit a form entry of
#
safe_proc neo_form_field {type name {parms ""}} {
    global neoFormDataName
    upvar #0 $neoFormDataName data

    if ![info exists data($name)] {
	set data($name) ""
    }

    if ![string match *value=* [string tolower $parms]] {
	append parms " value=\"[escape_attribute $data($name)]\""
    }
    html "<input name=\"[escape_attribute $name]\" type=\"[escape_attribute $type]\" $parms>"
}

safe_proc neo_form_radiobuttons {name parms values} {
    global neoFormDataName
    upvar #0 $neoFormDataName data
    if ![info exists data($name)] {
	set data($name) ""
    }
    set baseValue $data($name)

    foreach value $values {
	if {$baseValue == $value} {
	    set checked "checked"
	} else {
	    set checked ""
	}
	html "<input name=\"[escape_attribute $name]\" type=\"radio\" $parms value=\"[escape_attribute $value]\" $checked>[escape_attribute $value]"
    }
}

safe_proc neo_form_select {name parms values} {
    global neoFormDataName
    upvar #0 $neoFormDataName data
    if ![info exists data($name)] {
	set data($name) ""
    }
    set baseValue $data($name)

    html "<select name=\"[escape_attribute $name]\" $parms>"

    foreach value $values {
	if {$baseValue == $value} {
	    set selected " selected"
	} else {
	    set selected ""
	}
	html "<option${selected}>[escape_attribute $value]"
    }
    html "</select>"
}

safe_proc neo_form_checkbox {name {parms ""}}  {
    global neoFormDataName
    upvar #0 $neoFormDataName data 
    if ![info exists data($name)] {
        set data($name) "0"
    }

    if ![string match *value=* [string tolower $parms]] {
        append parms " value=\"[escape_attribute $data($name)]\""
    } else {
        set valueid [lsearch -glob [string tolower $parms] "*value=*"] 
        set data($name) [lindex [split [lindex $parms $valueid] =] end]
    }

    if {$data($name) == "1"} { 
        append parms " checked"
    }

    html "<input name=\"[escape_attribute $name]\" type=\"checkbox\"${parms}>"
}

safe_proc neo_form_textarea {name {parms ""}} {
    global neoFormDataName
    upvar #0 $neoFormDataName data

    if ![info exists data($name)] {
	set data($name) ""
    }
    html "<textarea name=\"[escape_attribute $name]\" $parms>[escape_attribute $data($name)]</textarea>"
}

safe_proc neo_form_submit {{text {}} {parms {}}} {
    if {$parms == {} && [string match *=* [string tolower $text]]} {
	set parms $text
    }
    set typeid [lsearch -glob [string tolower $parms] "*type=*"]
    if {$typeid > -1} { 
        set type [lindex [split [lindex $parms $typeid] =] end]
    } else {
        set type submit
    }   
    if {[clength $text] == 0} {
        set value $type
    } else {
        set value [escape_attribute $text]
    }
    html "<input type=\"$type\" value=\"$value\" $parms>"
}   

safe_proc neo_form_reset {{text ""}} {
    if {$text == ""} {
	html "<input type=reset>"
    } else {
	html "<input type=reset value=\"[escape_attribute $text]\">"
    }
}

safe_proc neo_form_end {} {
    html "</form>"
}

