proc debug {args} {
    global webenv DEBUGGING debug

    if ![info exists DEBUGGING] { set DEBUGGING 1 }

    if !$DEBUGGING return

    if [info exists debug(ip)] { set data(ip) $debug(ip) }
    if [info exists debug(subst)] {
	set data(subst) $debug(subst)
    } else {
	set data(subst) off
    }
    if [info exists debug(seperator)] {
	set data(seperator) $debug(seperator)
    } else {
	set data(seperator) <br>
    }

    set looking 0
    set endit 0
    foreach arg $args {
	if $endit {
	    lappend list $arg
	    continue
	}
	if $looking {
	    set data($varName) $arg
	    set looking 0
	    continue
	}
	if {[cindex $arg 0] == "-"} {
	    if {$arg == "--"} {
		set endit 1
		continue
	    }
	    set varName [crange $arg 1 end]
	    set looking 1
	    continue
	}
	lappend list $arg
    }

    if [info exists data(ip)] {
	set can_see 0
	foreach ip $data(ip) {
	    if [string match $data(ip)* $webenv(REMOTE_ADDR)] {
		set can_see 1
		break
	    }
	}
	if !$can_see return
    }

    if {[string tolower $data(subst)] != "on"} {
	html [join $list]
	return
    }

    set lastWasArray 0
    foreach varName $list {
	upvar $varName var
	if [array exists var] {
	    parray $varName
	    set lastWasArray 1
	} elseif [info exists var] {
	    if !$lastWasArray {
		html $data(seperator)
	    }
	    html $var
	    set lastWasArray 0
	} else {
	    if !$lastWasArray {
		html $data(seperator)
	    }
	    html $varName
	    set lastWasArray 0
	}
    }
}
