/*
 * scotty.h
 *
 * Copyright (c) 1993, 1994
 *                    J. Schoenwaelder
 *                    TU Braunschweig, Germany
 *                    Institute for Operating Systems and Computer Networks
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that this copyright
 * notice appears in all copies.  The University of Braunschweig
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

#include <tcl.h>

#define SCOTTY_VERSION "0.8"

/*
 * The filename where we will find the ntping binary.
 */

#ifndef NTPING
#define NTPING "/usr/local/bin/ntping"
#endif

#ifdef HAVE_ICMP
extern int icmp_cmd _ANSI_ARGS_((ClientData, Tcl_Interp*, int, char**));
extern void icmp_close _ANSI_ARGS_((void));
#endif

#ifdef HAVE_RPC
extern int rpc_cmd _ANSI_ARGS_((ClientData, Tcl_Interp*, int, char**));
extern int mount_cmd _ANSI_ARGS_((ClientData, Tcl_Interp*, int, char**));
#endif

#ifdef HAVE_DNS
extern int dns_cmd _ANSI_ARGS_((ClientData, Tcl_Interp*, int, char**));
#endif

#ifdef HAVE_SYSLOG
extern int syslog_cmd _ANSI_ARGS_((ClientData, Tcl_Interp*, int, char **));
#endif

#ifdef HAVE_TCP
extern int accept_cmd   _ANSI_ARGS_((ClientData, Tcl_Interp*, int, char **));
extern int connect_cmd  _ANSI_ARGS_((ClientData, Tcl_Interp*, int, char **));
extern int shutdown_cmd _ANSI_ARGS_((ClientData, Tcl_Interp*, int, char **));
#endif

#ifdef HAVE_SELECT
extern int Tcl_SelectCmd _ANSI_ARGS_((ClientData, Tcl_Interp*, int, char **));
#endif

#ifdef HAVE_SNMP
extern void snmp_init _ANSI_ARGS_((Tcl_Interp*));
#endif

#ifdef HAVE_READLINE

#define HISTSIZE 200         /* the length of the history buffer */

/* 
 * the readline headers have no prototypes 
 */

extern int read_history _ANSI_ARGS_((char*));
extern void stifle_history _ANSI_ARGS_((int));
extern int write_history _ANSI_ARGS_((char*));
extern void using_history _ANSI_ARGS_((void));
extern char *readline _ANSI_ARGS_((char*));
extern void add_history _ANSI_ARGS_((char*));
extern char **completion_matches _ANSI_ARGS_((char*, char* (*)(char*, int)));
extern char** (*rl_attempted_completion_function) 
                                              _ANSI_ARGS_((char*, int, int));
extern int where_history _ANSI_ARGS_((void));
extern int history_set_pos _ANSI_ARGS_((int));
extern char* remove_history _ANSI_ARGS_((int));

#endif

extern char* xstrdup _ANSI_ARGS_((char*));
extern char* xmalloc _ANSI_ARGS_((unsigned));
extern char* xrealloc _ANSI_ARGS_((char*, unsigned));
