#! /usr/local/bin/scotty -inf
##
## Tool Manager for [TK]INED.
##
## Copyright (c) 1993, 1994
##                    J. Schoenwaelder
##                    TU Braunschweig, Germany
##                    Institute for Operating Systems and Computer Networks
##
## Permission to use, copy, modify, and distribute this
## software and its documentation for any purpose and without
## fee is hereby granted, provided that this copyright
## notice appears in all copies.  The University of Braunschweig
## makes no representations about the suitability of this
## software for any purpose.  It is provided "as is" without
## express or implied warranty.
##

##
## This nice procedure allows us to use static variables. It was
## posted on the net by Karl Lehenbauer.
##

proc static {args} {
    set procName [lindex [info level [expr [info level]-1]] 0]
    foreach varName $args {
        uplevel 1 "upvar #0 {$procName:$varName} $varName"
    }
}

##
## Test if we are at home.
##

proc local {} {
    if {[catch {dns ptr [nslook [exec hostname]]} name]} {
	return 0
    }
    return [string match "*cs.tu-bs.de" $name]
}

##
## Search for the interpreter. Return the absolute path or an
## empty string if not found.
##

proc find_interpreter {fname} {
    global auto_path
    if [file exists $fname] { 
	return [file dirname $fname]/[file tail $fname]
    }
    foreach dir $auto_path {
        if [file exists $dir/$fname] {
            return [file dirname $dir/$fname]/$fname
        }
    }
    return ""
}

##
## start the interpreter named fname (searching the path)
##

proc load_interpreter {fname} {
    set fullname [find_interpreter $fname]
    if {$fullname==""} {
	set fullname [find_interpreter $fname.tcl]
    }
    if {$fullname==""} {
	ined acknowledge "Unable to find $fname nor $fname.tcl."
    } else {
            ined create INTERPRETER $fullname
    }
}

##
## fire up various tcl scripts for different tasks
##

proc "IP Trouble" {list} {
    load_interpreter ip_trouble.tcl
}

proc "IP Monitor" {list} {
    load_interpreter ip_monitor.tcl
}

proc "IP Layout" {list} {
    load_interpreter ip_layout.tcl
}

proc "IP Discover" {list} {
    load_interpreter ip_discover.tcl
}

proc "Communication" {list} {
    load_interpreter comm.tcl
}

proc "GAME" {list} {
    load_interpreter game.tcl
}

proc "SNMP Trouble" {list} {
    load_interpreter snmp_trouble.tcl
}

proc "SNMP Monitor" {list} {
    load_interpreter snmp_monitor.tcl
}

proc "SNMP CISCO" {list} {
    load_interpreter snmp_cisco.tcl
}

proc "BONES Info" {list} {
    load_interpreter bones.tcl
}

proc "Show Clipboard" {list} {
    static log

    if {[info exists log]} {
	if {[ined -noupdate retrieve $log] != ""} {
	    if {[ined confirm "Replace previous clipboard?"] != "yes"} return
	}
	ined -noupdate delete $log
    }
    set log [ined -noupdate create LOG]
    ined -noupdate name $log "tkined clipboard"
}

proc "Start Interpreter" {list} {
    static file
    
    if {![info exists file]} { set file "" }
    set file [ ined request "Please enter the name of the interpreter." \
	      "{{Filename:} $file}" ]
    if {$file == ""} return
    
    load_interpreter $file
}

##
## Let the user type a command and execute it.
##

proc "Execute Ined Command" {list} {
    static cmd

    if {![info exists cmd]} { set cmd "ined " }
    set res [ined request "Execute an ined tcl command." "{Command: {$cmd}}"]
    if {$res == ""} return
    set cmd [join $res]

    if [catch {eval $cmd} result] {
	ined acknowledge "Ined command failed:" $result
    } else {
	if {[string length $result] <= 80} {
	    ined acknowledge "Result of $cmd:" $result
	} else {
	    ined browse "Result of $cmd:" $result
	}
    }
}

##
## Display some help about this tool.
##

proc "help TOOL Manager" {list} {
    ined browse "Help about TOOL Manager" {
	"The TOOL Manager is responsible to dynamically load new tools" 
	"into INED. It currently knows about the following tools. (Note" 
	"that not all of them may be available on your site.)" 
	"" 
	"IP Trouble:" 
	"    A set of commands to find out why something is broken." 
	"" 
	"IP Monitor:" 
	"    Some simple monitoring commands. They allow you to sit down" 
	"    and watch whats going on." 
	"" 
	"IP Layout:" 
	"    These commands help you to layout your network." 
	"" 
	"IP Discover:"   
	"    Discover the IP structure of you network. This saves a lot"   
        "    of time when starting INED without a useable network map." 
	"" 
	"Communication:" 
	"    Allows you to create a connection between two or more tkineds." 
	"" 
	"SNMP Trouble:" 
	"    Commands to query and monitor your SNMP devices." 
	"" 
	"SNMP Monitor:" 
	"    Monitor SNMP variables. Needs more work to be serious." 
	"" 
	"SNMP CISCO:" 
	"    SNMP commands specific to the CISCO MIB." 
	"" 
	"GAME:" 
	"    A tedious game. It is just here since it has been the first" 
	"    external command written for INED." 
	"" 
	"Show Clipboard:" 
	"    Open a clipboard where you may save some notices." 
	"" 
	"Start Interpreter:" 
	"    Prompt the user for the file name of an interpeter to start." 
	"" 
	"Execute Ined Command:" 
        "    Enter one of the INED TCL commands and see what happens." 
    }
}

##
## Delete the TOOL Manager and exit this interpreter.
##

proc "delete TOOL Manager" {list} {
    global tools
    foreach id $tools {	ined delete $id }
    exit
}

if {[local]} {
    set tools [ined create TOOL "TOOL Manager" \
	"IP Trouble" "IP Monitor" "IP Layout" "IP Discover" "" \
	"Communication" "" \
	"SNMP Trouble" "SNMP Monitor" "SNMP CISCO" "" \
	"BONES Info" "" \
	"GAME" "" \
	"Show Clipboard" "Start Interpreter" "Execute Ined Command" "" \
	"help TOOL Manager" "delete TOOL Manager" ]
} else {
    set tools [ined create TOOL "TOOL Manager" \
	"IP Trouble" "IP Monitor" "IP Layout" "IP Discover" "" \
	"Communication" "" \
	"GAME" "" \
	"Show Clipboard" "Start Interpreter" "Execute Ined Command" "" \
	"help TOOL Manager" "delete TOOL Manager" ]
}
