#!./tclnm

source Config.edit

puts stdout "\nStarting installation"

proc install_tclnm_src {dir name file} {
    global bin_dir
    exec sed "1,1s,^#!.*,#!${bin_dir}/tclnm," $file > $dir/$name
    exec chmod  755 $dir/$name
}

proc install_bin_exec {dir name file} {
    exec install -c -m 555 $file $dir/$name
}

proc install_mib_stuff {} {
    global mib_dir smicfile

    install_tclnm_src $mib_dir smic2dbm Scripts/smic2dbm
    system "cp Smic_z/*.smic_z $mib_dir"
    #system "cd $mib_dir ; chmod 444 *.smic_z ; smic2dbm *.smic_z ; rm -f tmp.*"
}


puts stdout "making directories"
foreach i "$bin_dir $tool_dir $mib_dir" {
    if {![file exists $i]} {
	puts stdout "m $i"
	exec mkdir -p $i
    }
}

puts stdout "install tclnm"
install_bin_exec $bin_dir tclnm tclnm

if {$libtk != ""} {
    puts stdout "install wishnm"
    install_bin_exec $bin_dir wishnm wishnm
}

puts stdout "install tclnm.tcl"
install_tclnm_src $tclnm_dir tclnm.tcl tclnm.tcl

puts stdout "install tcl_mib.tcl"
install_tclnm_src $mib_dir tcl_mib.tcl tcl_mib/tcl_mib.tcl

puts stdout "install in $mib_dir"
install_mib_stuff

foreach i [glob -nocomplain Scripts/Tools/*] {
    if {[file isfile $i]} {
	set n [lindex [split $i /] 2]
	puts stderr "installing $n"
	install_tclnm_src $tool_dir $n $i
	install_tclnm_src $bin_dir ${toolprefix}$n $i
    }
}

foreach j { Synoptics } {
    if {![file exists $tool_dir/$j]} {
	puts stdout "m $tool_dir/$j"
	exec mkdir -p $tool_dir/$j
    }
    foreach i [glob -nocomplain Scripts/$j/*] {
	if {[file isfile $i]} {
	    set n [lindex [split $i /] 2]
	    puts stderr "installing $j/$n"
	    install_tclnm_src $tool_dir/$j $n $i
	}
    } 
}
