/* tcl_curses.c */

#include <stdio.h>
#include <memory.h>
#include <stdlib.h>
#include <string.h>
#include <curses.h>

#include <tcl.h>
#include "tcl_misc.h"
#include "whats_here.h"
#include "param.h"

static char *TraceDebug();
static int CursesProc();
static int WinProc();

typedef struct
    {
    int		debug;
    WINDOW	*stdscr;
    char	where[64];
    } t_cldat;

typedef struct
    {
    t_cldat	*cd;
    WINDOW	*win;
    char	where[64];
    } t_cldat2;

/****************************************************************************
 *
 * curses_init(interp)
 * ===================
 * 
 * Initialize the curses interface.
 *
 ****************************************************************************/

void
init_tcl_curses(interp)
    Tcl_Interp	*interp;
    {
    t_cldat *cd;
    extern endwin();

    cd = (t_cldat *)ckalloc(sizeof *cd);
    memset((void*)cd,0,sizeof *cd);
    Tcl_CreateCommand(interp,"curses",CursesProc,(ClientData)cd,(void (*)())endwin);
    }

static char*
TraceDebug(cd,interp,name1,name2,flags)
    t_cldat *cd;
    Tcl_Interp	*interp;
    char *name1;
    char *name2;
    int flags;
    {
    cd->debug=0;
    if(flags & TCL_TRACE_WRITES) 
	cd->debug = 
	    atoi(Tcl_GetVar(interp,"Curses(DEBUG)",flags&TCL_GLOBAL_ONLY));
    if(flags & TCL_TRACE_UNSETS) 
	Tcl_SetVar(interp,"Curses(DEBUG)","0",flags&TCL_GLOBAL_ONLY);
    if(flags & TCL_TRACE_DESTROYED)
	Tcl_TraceVar(interp,"Curses(DEBUG)",
	    TCL_TRACE_WRITES|TCL_TRACE_UNSETS,TraceDebug,(ClientData)cd);
    fprintf(stderr,"[CURSES]: debug is now %d\n",cd->debug);
    return 0;
    }
    
static int
ExitProc(cd,interp,argc,argv)
    t_cldat *cd;
    Tcl_Interp  *interp;
    int argc;
    char **argv;
    {
    int i;

    if(argc == 2)
	i=atoi(argv[1]);
    else
	i=0;
    /*
    Tcl_DeleteInterp(interp);
    */
    endwin();
    exit(i);
    return TCL_OK;
    }

static int
CursesProc(cd,interp,argc,argv)
    t_cldat *cd;
    Tcl_Interp  *interp;
    int argc;
    char **argv;
    {
    int i;
    t_cldat2 *cd2;

    if(cd->debug)
	{
	fprintf(stderr,"[CURSES]: CursesProc %d ",argc);
	for(i=0;i<argc;i++)
	    fprintf(stderr,"{%s} ",argv[i]);
	fprintf(stderr,"\n");
	}
    strcpy(cd->where,"[CURSES] ");
    strcat(cd->where,argv[0]);

    if(argc<2)
	return Error(interp,cd->where,"no args.");

    argc--; argv++;
    strcat(cd->where," ");
    strcat(cd->where,argv[0]);

    IFW("initscr")
/*XX curses initscr */
	{
	CHKNARG(1,1,cd->where);
	if(cd->stdscr)
	    return Error(interp,cd->where,"initscr has been called once.");
	cd2 = (t_cldat2 *)ckalloc(sizeof *cd2);
	memset((void*)cd2,0,sizeof *cd2);
	cd2->cd=cd;
	if(cd2->win = initscr())
	    {
	    char value[30];

	    cd->stdscr = cd2->win;
	    Tcl_CreateCommand(interp,"stdscr",WinProc,(ClientData)cd2,0);
	    Tcl_DeleteCommand(interp,"exit");
	    Tcl_CreateCommand(interp,"exit",ExitProc,(ClientData)cd,0);
	    sprintf(value,"%d", LINES);
# if TODO
	    Tcl_SetVar(interp,"Curses(LINES)",value,
		TCL_LEAVE_ERR_MSG|TCL_GLOBAL_ONLY);
	    sprintf(value,"%d", COLS);
	    Tcl_SetVar(interp,"Curses(COLS)",value,
		TCL_LEAVE_ERR_MSG|TCL_GLOBAL_ONLY);
#endif
	    return TCL_OK;
	    }
	return Failed(interp,cd->where,0);
	}

    if(!cd->stdscr) 	/* Not yet initscr */
	return Error(interp,cd->where,"must 'initscr' first.");

    IFW("endwin")
/*XX curses endwin */
	{
	CHKNARG(1,1,cd->where);
	if(endwin() == OK) 
	    {
	    cd->stdscr = (WINDOW*)0;
	    return TCL_OK;
	    }
	return Failed(interp,cd->where,0);
	}
 
    IFW("cbreak")
/*XX curses cbreak */
	{
	CHKNARG(1,1,cd->where);
	cbreak();
	return TCL_OK;
	}

#ifdef XYX_halfdelay
    IFW("halfdelay")
/*XX curses halfdelay <tenths> */
	{
	CHKNARG(2,2,cd->where);
	if(halfdelay(atoi(argv[1])) == OK) return TCL_OK;
	return Failed(interp,cd->where,0);
	}
#endif
    IFW("nocbreak")
/*XX curses nocbreak */
	{
	CHKNARG(1,1,cd->where);
	nocbreak();
	return TCL_OK;
	}
 
    IFW("echo")
/*XX curses echo */
	{ CHKNARG(1,1,cd->where); echo(); return TCL_OK; }

    IFW("noecho")
/*XX curses noecho */
	{ CHKNARG(1,1,cd->where); noecho(); return TCL_OK; }
 
    IFW("raw")
/*XX curses raw */
	{ CHKNARG(1,1,cd->where); raw(); return TCL_OK; }

    IFW("noraw")
/*XX curses noraw */
	{ CHKNARG(1,1,cd->where); noraw(); return TCL_OK; }
 
    IFW("nl")
/*XX curses nl */
	{ CHKNARG(1,1,cd->where); nl(); return TCL_OK; }

    IFW("nonl")
/*XX curses nonl */
	{ CHKNARG(1,1,cd->where); nonl(); return TCL_OK; }
 
    IFW("newwin")
/*XX curses newwin <win> <nlin> <ncol> <begin_y> <begin_x> */
	{ 
	WINDOW *w;

	CHKNARG(6,6,cd->where); 
	w = newwin(atoi(argv[2]),atoi(argv[3]),atoi(argv[4]),atoi(argv[5]));
	if(!w)
	    return Failed(interp,cd->where,0);
	cd2 = (t_cldat2 *)ckalloc(sizeof *cd2);
	memset((void*)cd2,0,sizeof *cd2);
	cd2->cd=cd;
	cd2->win=w;
	Tcl_CreateCommand(interp,argv[1],WinProc,(ClientData)cd2,0);
	return TCL_OK; 
	}
 
    return HUH(interp,cd->where);
    }

static int
WinProc(cd2,interp,argc,argv)
    t_cldat2 *cd2;
    Tcl_Interp  *interp;
    int argc;
    char **argv;
    {
    int i;
    char *w2;

    if(cd2->cd->debug)
	{
	fprintf(stderr,"[CURSES]: WinProc %d ",argc);
	for(i=0;i<argc;i++)
	    fprintf(stderr,"{%s} ",argv[i]);
	fprintf(stderr,"\n");
	}
    strcpy(cd2->where,"[CURSES] ");
    strcat(cd2->where,argv[0]);

    if(argc<2)
	return Error(interp,cd2->where,"no args.");

    argc--; argv++;
    strcat(cd2->where," ");
    w2 = cd2->where + strlen(cd2->where);

    while(argc && **argv == '-')
	{
	strcpy(w2,argv[0]);
	IFW("-m")
/*XX <win> [-m <lin> <pos>] */
	    {
	    CHKNARG(3,100000,cd2->where);
	    if(OK != wmove(cd2->win,atoi(argv[1]),atoi(argv[2])))
		return Failed(interp,cd2->where,0);
	    argv += 3; argc -= 3;
	    continue;
	    }
	IFW("-a")
/*XX <win> [-a <{|so|ul|rev|blink|dim|bold}*> ] */
	    {
	    char *s,*t;

	    CHKNARG(2,100000,cd2->where);
	    strcat(w2," ");
	    strcat(w2,argv[1]);
	    i=0;
#ifdef A_STANDOUT
	    for(t=argv[1];t && *t;t=s)
		{
		for(s=t;*s && !isspace(*s);s++) ;
		if(!*s) s=0;
		else *s++ = '\0';
		if(!strcmp(t,"so")) i |= A_STANDOUT;
		else if(!strcmp(t,"ul")) i |= A_UNDERLINE;
		else if(!strcmp(t,"rev")) i |= A_REVERSE;
		else if(!strcmp(t,"blink")) i |= A_BLINK;
		else if(!strcmp(t,"dim")) i |= A_DIM;
		else if(!strcmp(t,"bold")) i |= A_BOLD;
		else 
		    return Error(interp,cd2->where,"unknown attribute");
		}
	    /* no usefull return value ?? */
	    wattrset(cd2->win,i);
#endif
	    argv += 2; argc -= 2;
	    continue;
	    }
	return HUH(interp,cd2->where);
	}
    if(!argc)
	return TCL_OK;
    strcpy(w2,argv[0]);
    IFW("addstr")
/*XX <win> addstr <string> */
	{
	CHKNARG(2,2,cd2->where);
	if(OK == waddstr(cd2->win,argv[1]))
	    return TCL_OK;
	return Failed(interp,cd2->where,0);
	}

#ifdef XYX_wtimeout
    IFW("timeout")
/*XX curses timeout <flag> */
	{
	CHKNARG(2,2,cd2->where);
	wtimeout(cd2->win,atoi(argv[1]));
	return TCL_OK;
	}
#endif
#ifdef XYX_nodelay
    IFW("nodelay")
/*XX curses nodelay <flag> */
	{
	CHKNARG(2,2,cd2->where);
	if(nodelay(cd2->win,atoi(argv[1])) == OK) return TCL_OK;
	return Failed(interp,cd2->where,0);
	}
#endif
    IFW("clrtoeol")
/*XX <win> clrtoeol */
	{ wclrtoeol(cd2->win); return TCL_OK; }
    IFW("clrtobot")
/*XX <win> clrtobot */
	{ wclrtobot(cd2->win); return TCL_OK; }
    IFW("refresh")
/*XX <win> refresh */
	{ wrefresh(cd2->win); return TCL_OK; }
    IFW("erase")
/*XX <win> erase */
	{ werase(cd2->win); return TCL_OK; }
    IFW("clear")
/*XX <win> clear */
	{ wclear(cd2->win); return TCL_OK; }
    IFW("delwin")
/*XX <win> delwin */
	{ delwin(cd2->win); return(Tcl_DeleteCommand(interp, argv[0])); }
    IFW("getch")
/*XX <win> getch */
	{
	char buf[2];
	int i;
	buf[1]=0;
	i=wgetch(cd2->win);
	if(i == ERR)
	    Tcl_SetResult(interp,"",TCL_STATIC);
	else
	    {
	    buf[0]=i;
	    Tcl_SetResult(interp,buf,TCL_VOLATILE);
	    }
	return TCL_OK; 
	}
    return HUH(interp,cd2->where);
    }
