/* tcl_mib.c */

#include <tcl.h>
#include <tclExtend.h>

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include "param.h"

#ifdef notyet
#define IFW(st) if(**argv==*st && !strcmp(*argv,st))
#define ERR_N_ARG(syntax) { Tcl_AppendResult(interp, "bad # arg: ", \
	"\nSyntax is: ", syntax, 0) ; return TCL_ERROR; }
#define CHKNARG(min,max,syntax) if(argc<min || argc>max) ERR_N_ARG(syntax)

/*
 * t_cldat
 * -------
 */

typedef struct {
    int	dummy;
    } t_cldat;

/*
 * t_desc
 * ------
 */

typedef struct {
    int	dummy;
    } t_desc;

/*
 * MibProc(cd,interp,argc,argv)
 * ============================
 *
 * Do the actual work.
 *
 */

static int
MibProc(cd,interp,argc,argv)
    t_cldat	*cd;
    Tcl_Interp	*interp;
    int		argc;
    char	**argv;
    {
    int i,z;
    char *p;

    argv++; argc--;
    if(!argc)
	ERR_N_ARG("mib <args>");

    p = Tcl_Merge(argc,argv);
    z = Tcl_VarEval(interp,"proto_mib ", p, 0);
    free(p);
    return z;
    }

#endif /* notyet */
/*
 * init_tcl_mib(interp)
 * ====================
 *
 * Initialize the MIB interface for the interpreter 'interp'
 *
 */

int
init_tcl_mib(interp)
    Tcl_Interp	*interp;
    {
#if notyet
    t_cldat *cd;
    int z;

    cd = (t_cldat *)ckalloc(sizeof *cd);
    memset((void*)cd,0,sizeof *cd);
    Tcl_CreateCommand(interp,"mib",MibProc,(ClientData)cd,0);
    z=Tcl_Eval(interp,"source [info lib]/mib_proto.tcl",0,0);
    if(z == TCL_OK) return;
    Tcl_Eval(interp,"source mib_proto.tcl",0,0);
#else /* notyet */
    Tcl_SetVar(interp,"tcl_mib_path",MIBPATH,0);
    return Tcl_VarEval(interp,
            "foreach i ",MIBPATH," { ",
                "if {[file exists $i/tcl_mib.tcl]} { ",
                "source $i/tcl_mib.tcl ; return ",
                "} ",
            "}\n",
            "error {tcl_mib.tcl not found}",
            0);
#endif /* notyet */
    }
