#
#global mib_dbm mib_str mib_rec mib_idx mib_last mib_rlast
set tcl_mib_path {. /local/lib/tclnm/mib}
foreach i $tcl_mib_path {
    if {![catch {dbm open $i/mib r} mib_dbm]} { 
	set tcl_mib_dir $i ; break 
	dbm cache $mib_dbm
    }
}
if {[catch {set tcl_mib_dir}]} {
    puts stderr "Warning: Couldn't find MIB, tcl_mib not available."
    return;
}

set mib_str [open $tcl_mib_dir/mib.str r]
set mib_rec ""
set mib_idx ""
set mib_last "-"
set mib_rlast "-"

proc read_string {arg} {
    global mib_str
    if {[llength $arg] == 0} { return "" }
    seek $mib_str [lindex $arg 0]
    return [read $mib_str [lindex $arg 1]]
    }

proc mib_find oid {
    global mib_dbm
    set l [split $oid .]
    dbm fetch $mib_dbm "o _ [lindex $l 1]" r
    foreach i [lrange $l 2 end] {
        if {[dbm fetch $mib_dbm "o $r $i" x]} {
            set r $x
        } else {
            append r ".[format "%d" $i]"
        }
        }
    return $r
    }

proc mib_find_oid {oid} {
    global mib_dbm mib_rec mib_last mib_rlast mib_idx

    #puts stdout "*> $oid"
    if {$oid==$mib_last} {
	#puts stdout "2> <$mib_rlast>"
	return $mib_rlast
	}
    set mib_last $oid
    set l [split $oid "."]
    set x [llength $l]
    incr x -1
    while {$x > 0} {
        #puts stdout "0> [join [lrange $l 0 $x] .]>"
	set mib_idx [join [lrange $l 0 $x] .]
        if {[dbm fetch $mib_dbm "n $mib_idx" mib_rec]} {
            set y [expr $x+1]
            set mib_rlast [join [lrange $l $y end] .]
	    #puts stdout "1> [join [lrange $l 0 $x] .]> <$mib_rlast>"
            return $mib_rlast
        }
        incr x -1
    }
}

proc mib_desc { oid } { global mib_rec
    set l [mib_find_oid $oid]
    return [read_string [lindex $mib_rec 6]] }

proc mib_ref { oid } { global mib_rec
    set l [mib_find_oid $oid]
    return [read_string [lindex $mib_rec 7]] }

proc mib_type { oid } { global mib_rec
    set l [mib_find_oid $oid]
    return "[lindex $mib_rec 1]" }

proc mib_symb { oid } { global mib_rec
    set l [mib_find_oid $oid]
    return "[lindex $mib_rec 3]" }

proc mib_symb_oid { oid } { global mib_rec
    set l [mib_find_oid $oid]
    #puts stdout "2> [lindex $mib_rec 0]->$l" 
    return "[lindex $mib_rec 0].$l" }

proc mib_fmt_DisplayString { o t v } {
    set s ""
    foreach x [split $v "-"] {
	append s [format "%c" $x]
        }
    return \"$s\"
    }

proc mib_fmt_OID {o t v} {
    return [mib_symb_oid $v]
    }

proc mib_fmt_TimeTicks {o t v} {
    set f [expr $v%100] ; set v [expr $v/100]
    set s [expr $v%60] ; set v [expr $v/60]
    set m [expr $v%60] ; set v [expr $v/60]
    set h [expr $v%24] ; set v [expr $v/24]
    set d [expr $v%7] ; set v [expr $v/7]
    set r ""
    append r [format "%02dw " $v]
    append r [format "%01dd " $d]
    append r [format "%02dh " $h]
    append r [format "%02dm " $m]
    append r [format "%02d.%02ds" $s $f]
    return "{$r}"
    }

proc mib_fmt_PhysAddress { o t v } { global mib_rec
    set s ""
    foreach x [split $v "-"] {
	append s [format ":%02x" $x]
        }
    return [string range $s 1 end]
}

proc mib_fmt_Enum { o t v } { global mib_rec mib_idx
    set l [mib_find_oid $o]
    set t [lindex $mib_rec 2]
    #puts stdout "<$t>"
    set n [lindex $t 0]
    set j 2
    for {set x 1} { $x <= $n } { incr x } {
	if { $v == [lindex $t $j] } {
	    incr j -1
	    return [lindex $t $j]
	    }
	incr j 2
	}
    return $v
    }

proc mib_format {oid type val} {
    global mib_rec
    set l [mib_find_oid $oid]
    set s [lindex $mib_rec 3]
    lappend s [lindex $mib_rec 1] $type
    foreach t $s {
	set w mib_fmt_$t
	if {$w == [info commands $w]} {
	    return "$oid $t {[$w "$oid" "$type" "$val"]}"
        }
    }
    return "$oid $type \"$val\""
}

proc dump_n {oid} {
    global mib_dbm
    set l [split $oid "."]
    set x [llength $l]
    incr x -1
    while {$x > 0} {
        #puts stdout "trying <n [join [lrange $l 0 $x] .]>"
        if {[dbm fetch $mib_dbm "n [join [lrange $l 0 $x] .]" y]} {
            set y [expr $x+1]
            dump_nn "[join [lrange $l 0 $x] .]" "[join [lrange $l $y end] .]"
            return
        }
        incr x -1
        
        }
    }

proc dump_nn {oid suf} {
    global mib_dbm
    dbm fetch $mib_dbm "n $oid" l
    #puts stdout "    <$oid>.<$suf> [string length $l]"
    puts stdout "    OID     [lindex $l 0].$suf"
    puts stdout "    type    [lindex $l 1]"
    puts stdout "    targ    [lindex $l 2]"
    puts stdout "    symb    [lindex $l 3]"
    puts stdout "    stat    [lindex $l 4]"
    puts stdout "    access  [lindex $l 5]"
    puts stdout "    desc    [lindex $l 6]"
    set x [read_string [lindex $l 6]]
    regsub  -all "\n" $x "\n            " x
    puts stdout "            $x" 
    puts stdout "    ref     [lindex $l 7]"
    set x [read_string [lindex $l 7]]
    regsub  -all "\n" $x "\n            " x
    puts stdout "            $x" 
    puts stdout "    defval  [lindex $l 8]"
    puts stdout "    mib     [lindex $l 9]"
    }

proc mib_oid {o} {
    global mib_rec
    set l [mib_find_oid $o]
    return "[lindex $mib_rec 0] $l"
    }

###################

proc mib {cmd args} { 
    global mib_dbm mib_str
    #puts stdout "MIB <$cmd> <$args>" 
    case $cmd in {
	symboid { return [mib_symb_oid [lindex $args 0]] }
	oid { return [mib_oid [lindex $args 0]] }
	desc    { return [mib_desc [lindex $args 0]] }
	ref     { return [mib_ref [lindex $args 0]] }
	type    { return [mib_type [lindex $args 0]] }
	symb    { return [mib_symb [lindex $args 0]] }
	format  { return "[mib_format [lindex $args 0] [lindex $args 1] [lindex $args 2]]" }
	parse_oid  { return [mib_parse_oid [lindex $args 0] [lindex $args 1]] }
	parse_value { return "$args" } 
    }
    error "Unknow argument to mib command: '$cmd'"
}

proc mib_parse_oid { oid prefix } {
    global mib_dbm
    if {[string index $oid 0] != "."} {
	set l [concat [split $prefix .] [split $oid .]]
    } else {
	set l [split $oid .]
    }
    if {[string trim $l "0123456789 "]==""} {
	return [join "{} $l" "."]
	}
    set i [lindex $l 1]
    if {![catch {set x [format "%d" $i]} s]} {
	set r ".$x"
    } else {
	if {[dbm fetch $mib_dbm "o _ $i" x]} {
	    set r $x
	} else {
	    error "Unknown label '$i' in oid '$oid'"
	}
    }
    foreach i [lrange $l 2 end] {
	if {![catch {set x [format "%d" $i]} s]} {
	    append r ".$x"
	} else {
	    if {[dbm fetch $mib_dbm "o $r $i" x]} {
		set r $x
	    } else {
		error "Unknown label '$i' in oid '$oid'"
	    }
        }
        }
    return $r
    }

